/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine.gds;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class GdsAccessResult {
    private boolean isAllowed;
    private boolean isAudited;
    private long policyId = -1L;
    private Long policyVersion;
    private String maskType;
    private String maskedValue;
    private String maskCondition;
    private List<String> rowFilters;
    private Set<String> datasets;
    private Set<String> projects;
    private Set<String> allowedByDatasets;
    private Set<String> allowedByProjects;

    public boolean getIsAllowed() {
        return this.isAllowed;
    }

    public void setIsAllowed(boolean allowed) {
        this.isAllowed = allowed;
    }

    public boolean getIsAudited() {
        return this.isAudited;
    }

    public void setIsAudited(boolean audited) {
        this.isAudited = audited;
    }

    public long getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(long policyId) {
        this.policyId = policyId;
    }

    public Long getPolicyVersion() {
        return this.policyVersion;
    }

    public void setPolicyVersion(Long policyVersion) {
        this.policyVersion = policyVersion;
    }

    public String getMaskType() {
        return this.maskType;
    }

    public void setMaskType(String maskType) {
        this.maskType = maskType;
    }

    public String getMaskedValue() {
        return this.maskedValue;
    }

    public void setMaskedValue(String maskedValue) {
        this.maskedValue = maskedValue;
    }

    public String getMaskCondition() {
        return this.maskCondition;
    }

    public void setMaskCondition(String maskCondition) {
        this.maskCondition = maskCondition;
    }

    public List<String> getRowFilters() {
        return this.rowFilters;
    }

    public void setRowFilters(List<String> rowFilters) {
        this.rowFilters = rowFilters;
    }

    public Set<String> getDatasets() {
        return this.datasets;
    }

    public Set<String> getProjects() {
        return this.projects;
    }

    public Set<String> getAllowedByDatasets() {
        return this.allowedByDatasets;
    }

    public Set<String> getAllowedByProjects() {
        return this.allowedByProjects;
    }

    public void addDataset(String name) {
        if (this.datasets == null) {
            this.datasets = new HashSet<String>();
        }
        this.datasets.add(name);
    }

    public void addProject(String name) {
        if (this.projects == null) {
            this.projects = new HashSet<String>();
        }
        this.projects.add(name);
    }

    public void addAllowedByDataset(String name) {
        if (this.allowedByDatasets == null) {
            this.allowedByDatasets = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.allowedByDatasets.add(name);
    }

    public void addAllowedByProject(String name) {
        if (this.allowedByProjects == null) {
            this.allowedByProjects = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.allowedByProjects.add(name);
    }

    public int hashCode() {
        return Objects.hash(this.isAllowed, this.isAudited, this.policyId, this.policyVersion, this.maskType, this.maskedValue, this.maskCondition, this.rowFilters, this.datasets, this.projects, this.allowedByDatasets, this.allowedByProjects);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        GdsAccessResult other = (GdsAccessResult)obj;
        return Objects.equals(this.isAllowed, other.isAllowed) && Objects.equals(this.isAudited, other.isAudited) && Objects.equals(this.policyId, other.policyId) && Objects.equals(this.policyVersion, other.policyVersion) && Objects.equals(this.maskType, other.maskType) && Objects.equals(this.maskedValue, other.maskedValue) && Objects.equals(this.maskCondition, other.maskCondition) && Objects.equals(this.rowFilters, other.rowFilters) && Objects.equals(this.datasets, other.datasets) && Objects.equals(this.projects, other.projects) && Objects.equals(this.allowedByDatasets, other.allowedByDatasets) && Objects.equals(this.allowedByProjects, other.allowedByProjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerGdsAccessResult={");
        sb.append("isAllowed={").append(this.isAllowed).append("}");
        sb.append(", isAudited={").append(this.isAudited).append("}");
        sb.append(", policyId={").append(this.policyId).append("}");
        sb.append(", policyVersion={").append(this.policyVersion).append("}");
        sb.append(", maskType={").append(this.maskType).append("}");
        sb.append(", maskedValue={").append(this.maskedValue).append("}");
        sb.append(", maskCondition={").append(this.maskCondition).append("}");
        sb.append(", rowFilters={").append(this.rowFilters).append("}");
        sb.append(", datasets={").append(this.datasets).append("}");
        sb.append(", projects={").append(this.projects).append("}");
        sb.append(", allowedByDatasets={").append(this.allowedByDatasets).append("}");
        sb.append(", allowedByProjects={").append(this.allowedByProjects).append("}");
        sb.append("}");
        return sb;
    }
}

