/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerResourceEvaluator;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerResourceTrie<T extends RangerResourceEvaluator> {
    private static final Logger LOG = LoggerFactory.getLogger(RangerResourceTrie.class);
    private static final Logger TRACE_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.trace");
    private static final Logger PERF_TRIE_INIT_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.init");
    private static final Logger PERF_TRIE_OP_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.op");
    private static final String DEFAULT_WILDCARD_CHARS = "*?";
    private static final String TRIE_BUILDER_THREAD_COUNT = "ranger.policyengine.trie.builder.thread.count";
    private final RangerServiceDef.RangerResourceDef resourceDef;
    private final boolean optIgnoreCase;
    private final boolean optWildcard;
    private final String wildcardChars;
    private final boolean isOptimizedForRetrieval;
    private final boolean isOptimizedForSpace;
    private final Character separatorChar;
    private final TrieNode<T> root;
    private Set<T> inheritedEvaluators;

    public RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators) {
        this(resourceDef, evaluators, true, null);
    }

    public RangerResourceTrie(RangerResourceTrie<T> other) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.copyTrie(name=" + other.resourceDef.getName() + ")");
        }
        this.resourceDef = other.resourceDef;
        this.optIgnoreCase = other.optIgnoreCase;
        this.optWildcard = other.optWildcard;
        this.wildcardChars = other.wildcardChars;
        this.isOptimizedForSpace = other.isOptimizedForSpace;
        this.isOptimizedForRetrieval = other.isOptimizedForRetrieval;
        this.separatorChar = other.separatorChar;
        this.inheritedEvaluators = other.inheritedEvaluators != null ? new HashSet<T>(other.inheritedEvaluators) : null;
        this.root = this.copyTrieSubtree(other.root, null);
        this.wrapUpUpdate();
        if (!this.isOptimizedForRetrieval) {
            LOG.debug("Trie for {} is not optimized for retrieval. Resetting isSetup flag by calling undoSetup() on the root", (Object)this.resourceDef.getName());
            this.root.undoSetup();
        }
        RangerPerfTracer.logAlways(perf);
        if (PERF_TRIE_INIT_LOG.isDebugEnabled()) {
            PERF_TRIE_INIT_LOG.debug(this.toString());
        }
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("Trie Dump from RangerResourceTrie.copyTrie(name={}):\n[{}]", (Object)other.resourceDef.getName(), (Object)this.dumpTrie());
        }
    }

    public RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators, boolean isOptimizedForRetrieval, RangerPluginContext pluginContext) {
        this(resourceDef, evaluators, isOptimizedForRetrieval, false, pluginContext);
    }

    public <E> RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<E> evaluators, boolean isOptimizedForRetrieval, boolean isOptimizedForSpace, RangerPluginContext pluginContext) {
        int builderThreadCount;
        LOG.debug("==> RangerResourceTrie({}, evaluatorCount={}, isOptimizedForRetrieval={}, isOptimizedForSpace={})", new Object[]{resourceDef.getName(), evaluators.size(), isOptimizedForRetrieval, isOptimizedForSpace});
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(name=" + resourceDef.getName() + ")");
        }
        RangerPluginConfig config = pluginContext != null ? pluginContext.getConfig() : null;
        int n = builderThreadCount = config != null ? config.getInt(TRIE_BUILDER_THREAD_COUNT, 1) : 1;
        if (builderThreadCount < 1) {
            builderThreadCount = 1;
        }
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("builderThreadCount is set to [{}]", (Object)builderThreadCount);
        }
        Map<String, String> matcherOptions = resourceDef.getMatcherOptions();
        boolean optReplaceTokens = RangerAbstractResourceMatcher.getOptionReplaceTokens(matcherOptions);
        boolean optReplaceReqExpressions = RangerAbstractResourceMatcher.getOptionReplaceReqExpressions(matcherOptions);
        String tokenReplaceSpecialChars = "";
        if (optReplaceTokens) {
            char delimiterStart = RangerAbstractResourceMatcher.getOptionDelimiterStart(matcherOptions);
            char delimiterEnd = RangerAbstractResourceMatcher.getOptionDelimiterEnd(matcherOptions);
            char delimiterEscape = RangerAbstractResourceMatcher.getOptionDelimiterEscape(matcherOptions);
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterStart;
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterEnd;
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterEscape;
        }
        if (optReplaceReqExpressions) {
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + "${{".charAt(0);
        }
        this.resourceDef = resourceDef;
        this.optIgnoreCase = RangerAbstractResourceMatcher.getOptionIgnoreCase(matcherOptions);
        this.optWildcard = RangerAbstractResourceMatcher.getOptionWildCard(matcherOptions);
        this.wildcardChars = this.optWildcard ? DEFAULT_WILDCARD_CHARS + tokenReplaceSpecialChars : tokenReplaceSpecialChars;
        this.isOptimizedForSpace = isOptimizedForSpace;
        this.isOptimizedForRetrieval = !isOptimizedForSpace && isOptimizedForRetrieval;
        this.separatorChar = Character.valueOf(ServiceDefUtil.getCharOption(matcherOptions, "pathSeparatorChar", '/'));
        TrieNode<T> tmpRoot = this.buildTrie(resourceDef, evaluators, builderThreadCount);
        this.root = builderThreadCount > 1 && tmpRoot == null ? this.buildTrie(resourceDef, evaluators, 1) : tmpRoot;
        this.wrapUpUpdate();
        RangerPerfTracer.logAlways(perf);
        if (PERF_TRIE_INIT_LOG.isDebugEnabled()) {
            PERF_TRIE_INIT_LOG.debug(this.toString());
        }
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("Trie Dump from RangerResourceTrie.init(name={}):\n[{}]", (Object)resourceDef.getName(), (Object)this.dumpTrie());
        }
        LOG.debug("<== RangerResourceTrie({}, evaluatorCount={}, isOptimizedForRetrieval={}, isOptimizedForSpace={}): {}", new Object[]{resourceDef.getName(), evaluators.size(), this.isOptimizedForRetrieval, this.isOptimizedForSpace, this});
    }

    public Set<T> getEvaluatorsForResource(Object resource) {
        return this.getEvaluatorsForResource(resource, RangerAccessRequest.ResourceElementMatchingScope.SELF);
    }

    public Set<T> getEvaluatorsForResource(Object resource, RangerAccessRequest.ResourceElementMatchingScope scope) {
        return this.getEvaluatorsForResource(resource, scope, (Predicate)null);
    }

    public Set<T> getEvaluatorsForResource(Object resource, RangerAccessRequest.ResourceElementMatchingScope scope, Predicate predicate) {
        EvalCollector ret = new EvalCollector(predicate);
        this.traverse(resource, scope, ret);
        return ret.getResult();
    }

    public Set<T> getEvaluatorsForResource(Object resource, RangerAccessRequest.ResourceElementMatchingScope scope, Set<T> filter) {
        return this.getEvaluatorsForResource(resource, scope, filter, null);
    }

    public Set<T> getEvaluatorsForResource(Object resource, RangerAccessRequest.ResourceElementMatchingScope scope, Set<T> filter, Predicate predicate) {
        EvalSubsetCollector<T> ret = new EvalSubsetCollector<T>(filter, predicate);
        this.traverse(resource, scope, ret);
        return ret.getResult();
    }

    public int getEvaluatorsCountForResource(Object resource, RangerAccessRequest.ResourceElementMatchingScope scope) {
        return this.getEvaluatorsCountForResource(resource, scope, null);
    }

    public int getEvaluatorsCountForResource(Object resource, RangerAccessRequest.ResourceElementMatchingScope scope, Predicate predicate) {
        EvalCountCollector ret = new EvalCountCollector(predicate);
        this.traverse(resource, scope, ret);
        return ret.getResult();
    }

    public void add(RangerPolicy.RangerPolicyResource resource, T evaluator) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.add(name=" + resource + ")");
        }
        if (resource == null) {
            if (evaluator.isAncestorOf(this.resourceDef)) {
                this.addInheritedEvaluator(evaluator);
            }
        } else if (resource.getIsExcludes().booleanValue()) {
            this.addInheritedEvaluator(evaluator);
        } else if (CollectionUtils.isNotEmpty(resource.getValues())) {
            for (String value : resource.getValues()) {
                this.insert(this.root, value, resource.getIsRecursive(), evaluator);
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("Trie Dump from RangerResourceTrie.add(name={}):\n[{}]", (Object)resource, (Object)this.dumpTrie());
        }
    }

    public void delete(RangerPolicy.RangerPolicyResource resource, T evaluator) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.delete(name=" + resource + ")");
        }
        if (resource == null) {
            if (evaluator.isAncestorOf(this.resourceDef)) {
                this.removeInheritedEvaluator(evaluator);
            }
        } else if (resource.getIsExcludes().booleanValue()) {
            this.removeInheritedEvaluator(evaluator);
        } else {
            for (String value : resource.getValues()) {
                TrieNode<T> node = this.getNodeForResource(value);
                if (node == null) continue;
                ((TrieNode)node).removeEvaluatorFromSubtree(evaluator);
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace("Trie Dump from RangerResourceTrie.delete(name={}):\n[{}]", (Object)resource, (Object)this.dumpTrie());
        }
    }

    public void wrapUpUpdate() {
        if (this.root != null) {
            this.root.wrapUpUpdate();
            if (TRACE_LOG.isTraceEnabled()) {
                TRACE_LOG.trace("Trie Dump from RangerResourceTrie.wrapUpUpdate(name={}):\n[{}]", (Object)this.resourceDef.getName(), (Object)this.dumpTrie());
            }
        }
    }

    public StringBuilder dumpTrie() {
        StringBuilder sb = new StringBuilder();
        if (this.root != null) {
            this.root.toString("", sb);
        }
        return sb;
    }

    public void traverse(Object resource, RangerAccessRequest.ResourceElementMatchingScope scope, TraverseMatchHandler<T> handler) {
        if (resource instanceof String) {
            this.traverse((String)resource, scope, handler);
        } else if (resource instanceof Collection) {
            Collection resources = (Collection)resource;
            if (CollectionUtils.isEmpty((Collection)resources)) {
                this.traverse("", scope, handler);
            } else {
                this.traverse(resources, scope, handler);
            }
        }
    }

    public void traverse(Collection<String> resources, RangerAccessRequest.ResourceElementMatchingScope scope, TraverseMatchHandler<T> handler) {
        for (String resource : resources) {
            this.traverse(resource, scope, handler);
        }
    }

    public void traverse(String resource, RangerAccessRequest.ResourceElementMatchingScope scope, TraverseMatchHandler<T> handler) {
        boolean isSelfMatch;
        int i;
        String childStr;
        LOG.debug("==> RangerResourceTrie.traverse({}, {})", (Object)resource, (Object)scope);
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerResourceTrie.traverse(resource=" + resource + ")");
        }
        TrieNode<T> curr = this.root;
        TrieNode<T> parent = null;
        TrieNode<T> child = null;
        int len = resource.length();
        handler.process(this.inheritedEvaluators);
        for (i = 0; i < len; i += childStr.length()) {
            if (!this.isOptimizedForSpace) {
                curr.setupIfNeeded(parent);
            } else if (handler.process(curr.getWildcardEvaluators())) break;
            child = curr.getChild(this.getLookupChar(resource, i));
            if (child == null || !resource.regionMatches(this.optIgnoreCase, i, childStr = child.getStr(), 0, childStr.length())) break;
            parent = curr;
            curr = child;
        }
        if (!this.isOptimizedForSpace) {
            curr.setupIfNeeded(parent);
        } else {
            handler.process(curr.getWildcardEvaluators());
        }
        boolean bl = isSelfMatch = i == len;
        if (!this.isOptimizedForSpace) {
            handler.process(isSelfMatch ? curr.getEvaluators() : curr.getWildcardEvaluators());
        } else if (isSelfMatch) {
            handler.process(curr.getEvaluators());
        }
        if (scope == RangerAccessRequest.ResourceElementMatchingScope.SELF_OR_CHILD) {
            boolean resourceEndsWithSep;
            boolean bl2 = resourceEndsWithSep = resource.charAt(resource.length() - 1) == this.separatorChar.charValue();
            if (isSelfMatch) {
                if (resourceEndsWithSep) {
                    curr.getChildren().values().forEach(c -> c.collectChildEvaluators(this.separatorChar, 0, handler));
                } else if ((curr = curr.getChild(this.separatorChar)) != null) {
                    curr.collectChildEvaluators(this.separatorChar, 1, handler);
                }
            } else if (child != null) {
                int remainingLen = len - i;
                boolean isPrefixMatch = child.getStr().regionMatches(this.optIgnoreCase, 0, resource, i, remainingLen);
                if (isPrefixMatch) {
                    if (resourceEndsWithSep) {
                        child.collectChildEvaluators(this.separatorChar, remainingLen, handler);
                    } else if (child.getStr().charAt(remainingLen) == this.separatorChar.charValue()) {
                        child.collectChildEvaluators(this.separatorChar, remainingLen + 1, handler);
                    }
                }
            }
        } else if (scope == RangerAccessRequest.ResourceElementMatchingScope.SELF_OR_PREFIX) {
            curr.collectChildEvaluators(resource, i, handler);
        }
        RangerPerfTracer.logAlways(perf);
        LOG.debug("<== RangerResourceTrie.traverse({}, {})", (Object)resource, (Object)scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TrieData trieData = this.getTrieData();
        sb.append("resourceName=").append(this.resourceDef.getName());
        sb.append("; optIgnoreCase=").append(this.optIgnoreCase);
        sb.append("; optWildcard=").append(this.optWildcard);
        sb.append("; wildcardChars=").append(this.wildcardChars);
        sb.append("; nodeCount=").append(trieData.nodeCount);
        sb.append("; leafNodeCount=").append(trieData.leafNodeCount);
        sb.append("; singleChildNodeCount=").append(trieData.singleChildNodeCount);
        sb.append("; maxDepth=").append(trieData.maxDepth);
        sb.append("; evaluatorListCount=").append(trieData.evaluatorListCount);
        sb.append("; wildcardEvaluatorListCount=").append(trieData.wildcardEvaluatorListCount);
        sb.append("; evaluatorListRefCount=").append(trieData.evaluatorListRefCount);
        sb.append("; wildcardEvaluatorListRefCount=").append(trieData.wildcardEvaluatorListRefCount);
        return sb.toString();
    }

    TrieNode<T> getRoot() {
        return this.root;
    }

    private void addInheritedEvaluator(T evaluator) {
        if (this.inheritedEvaluators == null) {
            this.inheritedEvaluators = new HashSet<T>();
        }
        this.inheritedEvaluators.add(evaluator);
    }

    private void removeInheritedEvaluator(T evaluator) {
        if (CollectionUtils.isNotEmpty(this.inheritedEvaluators) && this.inheritedEvaluators.contains(evaluator)) {
            this.inheritedEvaluators.remove(evaluator);
            if (CollectionUtils.isEmpty(this.inheritedEvaluators)) {
                this.inheritedEvaluators = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrieNode<T> copyTrieSubtree(TrieNode<T> source, TrieNode<T> parent) {
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            source.toString(sb);
            TRACE_LOG.trace("==> copyTrieSubtree({})", (Object)sb);
        }
        TrieNode dest = new TrieNode(((TrieNode)source).str);
        if (parent != null) {
            ((TrieNode)parent).addChild(dest);
        }
        Map map = ((TrieNode)source).children;
        synchronized (map) {
            dest.isSetup = ((TrieNode)source).isSetup;
            dest.isSharingParentWildcardEvaluators = ((TrieNode)source).isSharingParentWildcardEvaluators;
            if (((TrieNode)source).isSharingParentWildcardEvaluators) {
                if (dest.getParent() != null) {
                    dest.wildcardEvaluators = dest.getParent().getWildcardEvaluators();
                } else {
                    dest.wildcardEvaluators = null;
                }
            } else if (((TrieNode)source).wildcardEvaluators != null) {
                dest.wildcardEvaluators = new HashSet(((TrieNode)source).wildcardEvaluators);
            } else {
                dest.wildcardEvaluators = null;
            }
            if (((TrieNode)source).evaluators != null) {
                if (((TrieNode)source).evaluators == ((TrieNode)source).wildcardEvaluators) {
                    dest.evaluators = dest.wildcardEvaluators;
                } else {
                    dest.evaluators = new HashSet(((TrieNode)source).evaluators);
                }
            } else {
                dest.evaluators = null;
            }
        }
        Map<Character, TrieNode<T>> children = source.getChildren();
        for (Map.Entry<Character, TrieNode<T>> entry : children.entrySet()) {
            this.copyTrieSubtree(entry.getValue(), dest);
        }
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sourceAsString = new StringBuilder();
            StringBuilder destAsString = new StringBuilder();
            source.toString(sourceAsString);
            dest.toString(destAsString);
            TRACE_LOG.trace("<== copyTrieSubtree({}) : {}", (Object)sourceAsString, (Object)destAsString);
        }
        return dest;
    }

    private <E> TrieNode<T> buildTrie(RangerServiceDef.RangerResourceDef resourceDef, List<E> evaluators, int builderThreadCount) {
        HashMap<Character, Integer> builderThreadMap;
        ArrayList<ResourceTrieBuilderThread> builderThreads;
        LOG.debug("==> buildTrie({}, evaluatorCount={}, isMultiThreaded={})", new Object[]{resourceDef.getName(), evaluators.size(), builderThreadCount > 1});
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(resourceDef=" + resourceDef.getName() + ")");
        }
        TrieNode<RangerResourceEvaluator> ret = new TrieNode<RangerResourceEvaluator>(null);
        boolean isMultiThreaded = builderThreadCount > 1;
        String resourceName = resourceDef.getName();
        int lastUsedThreadIndex = 0;
        if (isMultiThreaded) {
            builderThreads = new ArrayList<ResourceTrieBuilderThread>();
            for (int i = 0; i < builderThreadCount; ++i) {
                ResourceTrieBuilderThread t = new ResourceTrieBuilderThread();
                t.setDaemon(true);
                builderThreads.add(t);
                t.start();
            }
            builderThreadMap = new HashMap<Character, Integer>();
        } else {
            builderThreads = null;
            builderThreadMap = null;
        }
        for (E evaluator : evaluators) {
            List<RangerResourceEvaluator> resourceEvaluators;
            if (evaluator instanceof RangerPolicyEvaluator) {
                resourceEvaluators = ((RangerPolicyEvaluator)evaluator).getResourceEvaluators();
            } else if (evaluator instanceof RangerResourceEvaluator) {
                resourceEvaluators = Collections.singletonList((RangerResourceEvaluator)evaluator);
            } else {
                LOG.error("buildTrie(): unexpected evaluator class {}", (Object)evaluator.getClass().getCanonicalName());
                resourceEvaluators = Collections.emptyList();
            }
            for (RangerResourceEvaluator rangerResourceEvaluator : resourceEvaluators) {
                RangerPolicy.RangerPolicyResource policyResource;
                Map<String, RangerPolicy.RangerPolicyResource> policyResources = rangerResourceEvaluator.getPolicyResource();
                RangerPolicy.RangerPolicyResource rangerPolicyResource = policyResource = policyResources != null ? policyResources.get(resourceName) : null;
                if (policyResource == null) {
                    if (!rangerResourceEvaluator.isAncestorOf(resourceDef)) continue;
                    this.addInheritedEvaluator(rangerResourceEvaluator);
                    continue;
                }
                if (policyResource.getIsExcludes().booleanValue()) {
                    this.addInheritedEvaluator(rangerResourceEvaluator);
                    continue;
                }
                RangerResourceMatcher resourceMatcher = rangerResourceEvaluator.getResourceMatcher(resourceName);
                if (resourceMatcher != null && resourceMatcher.isMatchAny()) {
                    ret.addWildcardEvaluator(rangerResourceEvaluator);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
                for (String resource : policyResource.getValues()) {
                    if (!isMultiThreaded) {
                        this.insert(ret, resource, policyResource.getIsRecursive(), rangerResourceEvaluator);
                        continue;
                    }
                    try {
                        lastUsedThreadIndex = this.insert(ret, resource, policyResource.getIsRecursive(), rangerResourceEvaluator, builderThreadMap, builderThreads, lastUsedThreadIndex);
                    }
                    catch (InterruptedException ex) {
                        LOG.error("Failed to dispatch {} to {}", (Object)resource, builderThreads.get(lastUsedThreadIndex));
                        LOG.error("Failing and retrying with one thread");
                        ret = null;
                        break;
                    }
                }
                if (ret != null) continue;
                break;
            }
            if (ret != null) continue;
            break;
        }
        if (ret != null && isMultiThreaded) {
            for (ResourceTrieBuilderThread t : builderThreads) {
                try {
                    t.add("", false, null);
                    t.join();
                    ret.getChildren().putAll(t.getSubtrees());
                }
                catch (InterruptedException ex) {
                    LOG.error("BuilderThread {} was interrupted:", (Object)t, (Object)ex);
                    LOG.error("Failing and retrying with one thread");
                    ret = null;
                    break;
                }
            }
            this.cleanUpThreads(builderThreads);
        }
        RangerPerfTracer.logAlways(perf);
        LOG.debug("<== buildTrie({}, evaluatorCount={}, isMultiThreaded={}) :{}", new Object[]{resourceDef.getName(), evaluators.size(), isMultiThreaded, ret});
        return ret;
    }

    private void cleanUpThreads(List<ResourceTrieBuilderThread> builderThreads) {
        if (CollectionUtils.isNotEmpty(builderThreads)) {
            for (ResourceTrieBuilderThread t : builderThreads) {
                try {
                    if (!t.isAlive()) continue;
                    t.interrupt();
                    t.join();
                }
                catch (InterruptedException ex) {
                    LOG.error("Could not terminate thread {}", (Object)t);
                }
            }
        }
    }

    private TrieData getTrieData() {
        TrieData ret = new TrieData();
        this.root.populateTrieData(ret);
        ret.maxDepth = this.getMaxDepth();
        return ret;
    }

    private int getMaxDepth() {
        return this.root.getMaxDepth();
    }

    private Character getLookupChar(char ch) {
        return Character.valueOf(this.optIgnoreCase ? Character.toLowerCase(ch) : ch);
    }

    private Character getLookupChar(String str, int index) {
        return this.getLookupChar(str.charAt(index));
    }

    private int insert(TrieNode<T> currentRoot, String resource, boolean isRecursive, T evaluator, Map<Character, Integer> builderThreadMap, List<ResourceTrieBuilderThread> builderThreads, int lastUsedThreadIndex) throws InterruptedException {
        int ret = lastUsedThreadIndex;
        String prefix = this.getNonWildcardPrefix(resource);
        if (StringUtils.isNotEmpty((String)prefix)) {
            char c = this.getLookupChar(prefix.charAt(0)).charValue();
            Integer index = builderThreadMap.get(Character.valueOf(c));
            if (index == null) {
                ret = (lastUsedThreadIndex + 1) % builderThreads.size();
                index = ret;
                builderThreadMap.put(Character.valueOf(c), index);
            }
            builderThreads.get(index).add(resource, isRecursive, evaluator);
        } else {
            currentRoot.addWildcardEvaluator(evaluator);
        }
        return ret;
    }

    private void insert(TrieNode<T> currentRoot, String resource, boolean isRecursive, T evaluator) {
        boolean isWildcard;
        TrieNode<T> curr = currentRoot;
        String prefix = this.getNonWildcardPrefix(resource);
        boolean bl = isWildcard = prefix.length() != resource.length();
        if (StringUtils.isNotEmpty((String)prefix)) {
            curr = curr.getOrCreateChild(prefix);
        }
        if (isWildcard || isRecursive) {
            curr.addWildcardEvaluator(evaluator);
        } else {
            curr.addEvaluator(evaluator);
        }
    }

    private int getNonWildcardPrefixLength(String str) {
        int minIndex = str.length();
        for (int i = 0; i < this.wildcardChars.length(); ++i) {
            int index = str.indexOf(this.wildcardChars.charAt(i));
            if (index == -1 || index >= minIndex) continue;
            minIndex = index;
        }
        return minIndex;
    }

    private String getNonWildcardPrefix(String str) {
        int prefixLen = this.getNonWildcardPrefixLength(str);
        return prefixLen < str.length() ? str.substring(0, prefixLen) : str;
    }

    private TrieNode<T> getNodeForResource(String resource) {
        TrieNode<T> child;
        int i;
        String childStr;
        LOG.debug("==> RangerResourceTrie.getNodeForResource({})", (Object)resource);
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerResourceTrie.getNodeForResource(resource=" + resource + ")");
        }
        TrieNode<T> curr = this.root;
        int len = this.getNonWildcardPrefixLength(resource);
        for (i = 0; i < len && (child = curr.getChild(this.getLookupChar(resource, i))) != null && resource.regionMatches(this.optIgnoreCase, i, childStr = child.getStr(), 0, childStr.length()); i += childStr.length()) {
            curr = child;
        }
        curr = i == len ? curr : null;
        RangerPerfTracer.logAlways(perf);
        LOG.debug("<== RangerResourceTrie.getNodeForResource({})", (Object)resource);
        return curr;
    }

    class TrieNode<U extends T> {
        private final Map<Character, TrieNode<U>> children = new HashMap<Character, TrieNode<U>>();
        private String str;
        private TrieNode<U> parent;
        private volatile Set<U> evaluators;
        private volatile Set<U> wildcardEvaluators;
        private boolean isSharingParentWildcardEvaluators;
        private volatile boolean isSetup;

        TrieNode(String str) {
            this.str = str;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        String getStr() {
            return this.str;
        }

        void setStr(String str) {
            this.str = str;
        }

        TrieNode<U> getParent() {
            return this.parent;
        }

        void setParent(TrieNode<U> parent) {
            this.parent = parent;
        }

        Map<Character, TrieNode<U>> getChildren() {
            return this.children;
        }

        Set<U> getEvaluators() {
            return this.evaluators;
        }

        Set<U> getWildcardEvaluators() {
            return this.wildcardEvaluators;
        }

        TrieNode<U> getChild(Character ch) {
            return this.children.get(ch);
        }

        void populateTrieData(TrieData trieData) {
            ++trieData.nodeCount;
            if (this.wildcardEvaluators != null) {
                if (this.isSharingParentWildcardEvaluators) {
                    ++trieData.wildcardEvaluatorListRefCount;
                } else {
                    ++trieData.wildcardEvaluatorListCount;
                }
            }
            if (this.evaluators != null) {
                if (this.evaluators == this.wildcardEvaluators) {
                    ++trieData.evaluatorListRefCount;
                } else {
                    ++trieData.evaluatorListCount;
                }
            }
            if (!this.children.isEmpty()) {
                if (this.children.size() == 1) {
                    ++trieData.singleChildNodeCount;
                }
                for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                    TrieNode<U> child = entry.getValue();
                    child.populateTrieData(trieData);
                }
            } else {
                ++trieData.leafNodeCount;
            }
        }

        int getMaxDepth() {
            int ret = 0;
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                int maxChildDepth = child.getMaxDepth();
                if (maxChildDepth <= ret) continue;
                ret = maxChildDepth;
            }
            return ret + 1;
        }

        TrieNode<U> getOrCreateChild(String str) {
            int len = str.length();
            TrieNode<U> child = this.children.get(RangerResourceTrie.this.getLookupChar(str, 0));
            if (child == null) {
                child = new TrieNode<U>(str);
                this.addChild(child);
            } else {
                boolean isExactMatch;
                String childStr = child.getStr();
                int childStrLen = childStr.length();
                boolean bl = isExactMatch = RangerResourceTrie.this.optIgnoreCase ? StringUtils.equalsIgnoreCase((String)childStr, (String)str) : StringUtils.equals((String)childStr, (String)str);
                if (!isExactMatch) {
                    int index;
                    int numOfCharactersToMatch = Math.min(childStrLen, len);
                    for (index = 1; index < numOfCharactersToMatch && RangerResourceTrie.this.getLookupChar(childStr, index) == RangerResourceTrie.this.getLookupChar(str, index); ++index) {
                    }
                    if (index == numOfCharactersToMatch) {
                        if (childStrLen > len) {
                            TrieNode<U> newChild = new TrieNode<U>(str);
                            this.addChild(newChild);
                            child.setStr(childStr.substring(index));
                            super.addChild(child);
                            child = newChild;
                        } else {
                            child = child.getOrCreateChild(str.substring(index));
                        }
                    } else {
                        String matchedPart = str.substring(0, index);
                        TrieNode<U> newChild = new TrieNode<U>(matchedPart);
                        this.addChild(newChild);
                        child.setStr(childStr.substring(index));
                        super.addChild(child);
                        child = newChild.getOrCreateChild(str.substring(index));
                    }
                }
            }
            return child;
        }

        void addEvaluator(U evaluator) {
            if (this.evaluators == null) {
                this.evaluators = new HashSet<U>();
            }
            this.evaluators.add(evaluator);
        }

        void addWildcardEvaluator(U evaluator) {
            if (this.wildcardEvaluators == null) {
                this.wildcardEvaluators = new HashSet<U>();
            }
            this.wildcardEvaluators.add(evaluator);
        }

        void removeEvaluator(U evaluator) {
            if (CollectionUtils.isNotEmpty(this.evaluators)) {
                this.evaluators.remove(evaluator);
                if (CollectionUtils.isEmpty(this.evaluators)) {
                    this.evaluators = null;
                }
            }
        }

        void removeWildcardEvaluator(U evaluator) {
            if (CollectionUtils.isNotEmpty(this.wildcardEvaluators)) {
                this.wildcardEvaluators.remove(evaluator);
                if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                    this.wildcardEvaluators = null;
                }
            }
        }

        void undoSetup() {
            for (TrieNode<U> child : this.children.values()) {
                child.undoSetup();
            }
            if (this.isSetup) {
                if (this.evaluators != null) {
                    if (this.evaluators == this.wildcardEvaluators) {
                        this.evaluators = null;
                    } else if (this.wildcardEvaluators != null) {
                        this.evaluators.removeAll(this.wildcardEvaluators);
                        if (CollectionUtils.isEmpty(this.evaluators)) {
                            this.evaluators = null;
                        }
                    }
                }
                if (this.wildcardEvaluators != null) {
                    if (this.isSharingParentWildcardEvaluators) {
                        this.wildcardEvaluators = null;
                    } else {
                        Set<U> parentWildcardEvaluators;
                        Set<U> set = parentWildcardEvaluators = this.getParent() == null ? null : this.getParent().getWildcardEvaluators();
                        if (parentWildcardEvaluators != null) {
                            this.wildcardEvaluators.removeAll(parentWildcardEvaluators);
                            if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                                this.wildcardEvaluators = null;
                            }
                        }
                    }
                }
                this.isSharingParentWildcardEvaluators = false;
                this.isSetup = false;
            }
        }

        void removeSelfFromTrie() {
            LOG.debug("==> removeSelfFromTrie({})", (Object)this);
            if (this.evaluators == null && this.wildcardEvaluators == null && this.children.isEmpty()) {
                TrieNode<U> parent = this.getParent();
                if (parent != null) {
                    parent.children.remove(Character.valueOf(this.str.charAt(0)));
                }
            } else {
                LOG.debug("removeSelfFromTrie({}): node is not removed from Trie : [evaluators:{}, wildcard-evaluators:{}, number-of-children-nodes:{}]", new Object[]{this, this.evaluators, this.wildcardEvaluators, this.children.size()});
            }
            LOG.debug("<== removeSelfFromTrie({})", (Object)this);
        }

        void wrapUpUpdate() {
            if (RangerResourceTrie.this.isOptimizedForRetrieval) {
                RangerPerfTracer postSetupPerf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
                    postSetupPerf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(name=" + RangerResourceTrie.this.resourceDef.getName() + "-postSetup)");
                }
                this.postSetup(null);
                RangerPerfTracer.logAlways(postSetupPerf);
            }
        }

        void postSetup(Set<U> parentWildcardEvaluators) {
            this.setup(parentWildcardEvaluators);
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                child.postSetup(this.wildcardEvaluators);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setupIfNeeded(TrieNode<U> parent) {
            boolean setupNeeded;
            boolean bl = setupNeeded = !this.isSetup;
            if (setupNeeded) {
                Map<Character, TrieNode<U>> map = this.children;
                synchronized (map) {
                    boolean bl2 = setupNeeded = !this.isSetup;
                    if (setupNeeded) {
                        this.setup(parent == null ? null : parent.getWildcardEvaluators());
                        if (TRACE_LOG.isTraceEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            this.toString(sb);
                            TRACE_LOG.trace("Set up is completed for this TriNode as a part of access evaluation : [{}]", (Object)sb);
                        }
                    }
                }
            }
        }

        void setup(Set<U> parentWildcardEvaluators) {
            if (!this.isSetup) {
                if (parentWildcardEvaluators != null) {
                    if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                        this.wildcardEvaluators = parentWildcardEvaluators;
                    } else {
                        for (RangerResourceEvaluator evaluator : parentWildcardEvaluators) {
                            this.addWildcardEvaluator(evaluator);
                        }
                    }
                }
                boolean bl = this.isSharingParentWildcardEvaluators = this.wildcardEvaluators == parentWildcardEvaluators;
                if (this.wildcardEvaluators != null) {
                    if (CollectionUtils.isEmpty(this.evaluators)) {
                        this.evaluators = this.wildcardEvaluators;
                    } else {
                        for (RangerResourceEvaluator evaluator : this.wildcardEvaluators) {
                            this.addEvaluator(evaluator);
                        }
                    }
                }
                this.isSetup = true;
            }
        }

        void collectChildEvaluators(Character sep, int startIdx, TraverseMatchHandler<U> handler) {
            int sepPos;
            if (!RangerResourceTrie.this.isOptimizedForSpace) {
                this.setupIfNeeded(this.getParent());
            }
            int n = sepPos = startIdx < this.str.length() ? this.str.indexOf(sep.charValue(), startIdx) : -1;
            if (sepPos == -1) {
                if (RangerResourceTrie.this.isOptimizedForSpace) {
                    handler.process(this.wildcardEvaluators);
                }
                handler.process(this.evaluators);
                this.children.values().forEach(c -> c.collectChildEvaluators(sep, 0, handler));
            } else if (sepPos == this.str.length() - 1) {
                if (RangerResourceTrie.this.isOptimizedForSpace) {
                    handler.process(this.wildcardEvaluators);
                }
                handler.process(this.evaluators);
            }
        }

        void collectChildEvaluators(String resource, int startIndex, TraverseMatchHandler<U> handler) {
            Character startChar;
            TrieNode<U> childNode;
            if (startIndex == resource.length()) {
                this.collectChildEvaluators(handler);
            } else if (startIndex < resource.length() && (childNode = this.children.get(startChar = RangerResourceTrie.this.getLookupChar(resource, startIndex))) != null) {
                if (!RangerResourceTrie.this.isOptimizedForSpace) {
                    childNode.setupIfNeeded(childNode.getParent());
                }
                String childStr = childNode.getStr();
                int lenToMatch = Math.min(resource.length() - startIndex, childStr.length());
                if (resource.regionMatches(RangerResourceTrie.this.optIgnoreCase, startIndex, childStr, 0, lenToMatch)) {
                    handler.process(childNode.wildcardEvaluators);
                    handler.process(childNode.evaluators);
                    if (resource.length() == startIndex + lenToMatch) {
                        super.collectChildEvaluators(handler);
                    } else {
                        childNode.children.values().forEach(c -> c.collectChildEvaluators(resource, startIndex + childStr.length(), handler));
                    }
                }
            }
        }

        void toString(StringBuilder sb) {
            String nodeValue = this.str;
            sb.append("nodeValue=").append(nodeValue == null ? "ROOT" : nodeValue);
            sb.append("; isSetup=").append(this.isSetup);
            sb.append("; isSharingParentWildcardEvaluators=").append(this.isSharingParentWildcardEvaluators);
            sb.append("; childCount=").append(this.children.size());
            sb.append("; evaluators=[");
            if (this.evaluators != null) {
                for (RangerResourceEvaluator evaluator : this.evaluators) {
                    sb.append(evaluator.getId()).append("|,|");
                }
            }
            sb.append("]");
            sb.append("; wildcardEvaluators=[ ");
            if (this.wildcardEvaluators != null) {
                for (RangerResourceEvaluator evaluator : this.wildcardEvaluators) {
                    sb.append(evaluator.getId()).append("|,|");
                }
            }
            sb.append("]");
        }

        void toString(String prefix, StringBuilder sb) {
            String nodeValue = prefix + (this.str != null ? this.str : "");
            if (!nodeValue.equals(prefix)) {
                prefix = prefix + "|";
            }
            sb.append(prefix);
            this.toString(sb);
            sb.append("]\n");
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                child.toString(nodeValue, sb);
            }
        }

        private void addChild(TrieNode<U> child) {
            this.children.put(RangerResourceTrie.this.getLookupChar(child.getStr(), 0), child);
            child.setParent(this);
        }

        private void collectChildEvaluators(TraverseMatchHandler<U> childEvaluators) {
            Stack<TrieNode<U>> nodes = new Stack<TrieNode<U>>();
            nodes.addAll(this.children.values());
            while (!nodes.isEmpty()) {
                TrieNode childNode = (TrieNode)nodes.pop();
                if (!RangerResourceTrie.this.isOptimizedForSpace) {
                    childNode.setupIfNeeded(childNode.getParent());
                }
                childEvaluators.process(childNode.wildcardEvaluators);
                childEvaluators.process(childNode.evaluators);
                nodes.addAll(childNode.children.values());
            }
        }

        private void removeEvaluatorFromSubtree(U evaluator) {
            LOG.debug("==> removeEvaluatorFromSubtree({})", (Object)evaluator.getId());
            if (CollectionUtils.isNotEmpty(this.wildcardEvaluators) && this.wildcardEvaluators.contains(evaluator)) {
                this.removeWildcardEvaluator(evaluator);
            } else {
                this.removeEvaluator(evaluator);
            }
            this.removeSelfFromTrie();
            LOG.debug("<== removeEvaluatorFromSubtree({})", (Object)evaluator.getId());
        }
    }

    class ResourceTrieBuilderThread
    extends Thread {
        private final TrieNode<T> thisRoot;
        private final BlockingQueue<org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem> workQueue;

        ResourceTrieBuilderThread() {
            this.thisRoot = new TrieNode(null);
            this.workQueue = new LinkedBlockingQueue<org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem>();
        }

        @Override
        public void run() {
            block3: {
                WorkItem workItem;
                LOG.debug("Running {}", (Object)this);
                while (true) {
                    try {
                        workItem = (WorkItem)this.workQueue.take();
                    }
                    catch (InterruptedException exception) {
                        LOG.error("Thread={} is interrupted", (Object)this, (Object)exception);
                        break block3;
                    }
                    if (workItem.evaluator == null) break;
                    RangerResourceTrie.this.insert(this.thisRoot, workItem.resourceName, workItem.isRecursive, workItem.evaluator);
                }
                LOG.debug("Received termination signal. {}", (Object)workItem);
            }
            LOG.debug("Exiting {}", (Object)this);
        }

        void add(String resourceName, boolean isRecursive, T evaluator) throws InterruptedException {
            this.workQueue.put((org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem)new WorkItem(this, resourceName, isRecursive, evaluator));
        }

        Map<Character, TrieNode<T>> getSubtrees() {
            return this.thisRoot.getChildren();
        }

        static class WorkItem {
            final String resourceName;
            final boolean isRecursive;
            final T evaluator;
            final /* synthetic */ ResourceTrieBuilderThread this$1;

            WorkItem(String resourceName, boolean isRecursive, T evaluator) {
                this.this$1 = this$1;
                this.resourceName = resourceName;
                this.isRecursive = isRecursive;
                this.evaluator = evaluator;
            }

            public String toString() {
                return "resourceName=" + this.resourceName + "isRecursive=" + this.isRecursive + "evaluator=" + (this.evaluator != null ? Long.valueOf(this.evaluator.getId()) : null);
            }
        }
    }

    public static class EvalCountCollector<T extends RangerResourceEvaluator>
    implements TraverseMatchHandler<T> {
        private final Predicate predicate;
        private int result;

        public EvalCountCollector(Predicate predicate) {
            this.predicate = predicate;
        }

        public int getResult() {
            return this.result;
        }

        @Override
        public boolean process(Set<T> evaluators) {
            if (evaluators != null) {
                if (this.predicate == null) {
                    this.result += evaluators.size();
                } else {
                    for (RangerResourceEvaluator evaluator : evaluators) {
                        if (!this.predicate.evaluate((Object)evaluator)) continue;
                        ++this.result;
                    }
                }
            }
            return false;
        }
    }

    public static class EvalSubsetCollector<T extends RangerResourceEvaluator>
    implements TraverseMatchHandler<T> {
        private final Predicate predicate;
        private final Set<T> filter;
        private Set<T> result;

        public EvalSubsetCollector(Set<T> filter, Predicate predicate) {
            this.predicate = predicate;
            this.filter = filter == null ? Collections.emptySet() : filter;
            this.result = null;
        }

        public Set<T> getResult() {
            return this.result;
        }

        @Override
        public boolean process(Set<T> evaluators) {
            if (evaluators != null && !evaluators.isEmpty()) {
                if (this.result == null) {
                    this.result = new HashSet<T>();
                }
                EvalSubsetCollector.intersect(this.filter, evaluators, this.result);
                if (this.predicate != null) {
                    this.result.removeIf(evaluator -> !this.predicate.evaluate(evaluator));
                }
            }
            return this.result != null && this.filter.size() == this.result.size();
        }

        private static <T> void intersect(Set<T> a, Set<T> b, Set<T> result) {
            Set<Object> smaller = a.size() < b.size() ? a : b;
            Set larger = smaller == a ? b : a;
            smaller.forEach(item -> {
                if (larger.contains(item)) {
                    result.add(item);
                }
            });
        }
    }

    public static class EvalCollector<T extends RangerResourceEvaluator>
    implements TraverseMatchHandler<T> {
        private final Predicate predicate;
        private Set<T> result;
        private boolean isOwnedResult;

        public EvalCollector(Predicate predicate) {
            this.predicate = predicate;
            this.result = null;
        }

        public Set<T> getResult() {
            return this.result;
        }

        @Override
        public boolean process(Set<T> evaluators) {
            block9: {
                if (evaluators == null || evaluators.isEmpty()) break block9;
                if (this.result == null) {
                    if (this.predicate == null) {
                        this.result = evaluators;
                    } else {
                        this.result = new HashSet<T>();
                        this.isOwnedResult = true;
                        for (RangerResourceEvaluator evaluator : evaluators) {
                            if (!this.predicate.evaluate((Object)evaluator)) continue;
                            this.result.add(evaluator);
                        }
                    }
                } else {
                    if (!this.isOwnedResult) {
                        this.result = new HashSet<T>(this.result);
                        this.isOwnedResult = true;
                    }
                    if (this.predicate == null) {
                        this.result.addAll(evaluators);
                    } else {
                        for (RangerResourceEvaluator evaluator : evaluators) {
                            if (!this.predicate.evaluate((Object)evaluator)) continue;
                            this.result.add(evaluator);
                        }
                    }
                }
            }
            return false;
        }
    }

    static class TrieData {
        int nodeCount;
        int leafNodeCount;
        int singleChildNodeCount;
        int maxDepth;
        int evaluatorListCount;
        int wildcardEvaluatorListCount;
        int evaluatorListRefCount;
        int wildcardEvaluatorListRefCount;

        TrieData() {
        }
    }

    public static interface TraverseMatchHandler<T extends RangerResourceEvaluator> {
        public boolean process(Set<T> var1);
    }
}

