/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceReadOnly;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;

public class RangerAccessResourceImpl
implements RangerMutableResource {
    private String ownerUser;
    private Map<String, Object> elements;
    private String stringifiedValue;
    private String stringifiedCacheKeyValue;
    private String leafName;
    private RangerServiceDef serviceDef;

    public RangerAccessResourceImpl() {
        this(null, null);
    }

    public RangerAccessResourceImpl(Map<String, Object> elements) {
        this(elements, null);
    }

    public RangerAccessResourceImpl(Map<String, Object> elements, String ownerUser) {
        this.elements = elements;
        this.ownerUser = ownerUser;
    }

    @Override
    public String getOwnerUser() {
        return this.ownerUser;
    }

    @Override
    public boolean exists(String name) {
        return this.elements != null && this.elements.containsKey(name);
    }

    @Override
    public Object getValue(String name) {
        Object ret = null;
        if (this.elements != null && this.elements.containsKey(name)) {
            ret = this.elements.get(name);
        }
        return ret;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public Set<String> getKeys() {
        Set<String> ret = null;
        if (this.elements != null) {
            ret = this.elements.keySet();
        }
        return ret;
    }

    @Override
    public String getLeafName() {
        String ret = this.leafName;
        if (ret == null && this.serviceDef != null && this.serviceDef.getResources() != null) {
            List<RangerServiceDef.RangerResourceDef> resourceDefs = this.serviceDef.getResources();
            for (int idx = resourceDefs.size() - 1; idx >= 0; --idx) {
                RangerServiceDef.RangerResourceDef resourceDef = resourceDefs.get(idx);
                if (resourceDef == null || !this.exists(resourceDef.getName())) continue;
                this.leafName = ret = resourceDef.getName();
                break;
            }
        }
        return ret;
    }

    @Override
    public String getAsString() {
        String ret = this.stringifiedValue;
        if (ret == null && this.serviceDef != null && this.serviceDef.getResources() != null) {
            StringBuilder sb = new StringBuilder();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                if (resourceDef == null || !this.exists(resourceDef.getName())) continue;
                if (sb.length() > 0) {
                    sb.append("/");
                }
                sb.append(this.getValue(resourceDef.getName()));
            }
            if (sb.length() > 0) {
                this.stringifiedValue = ret = sb.toString();
            }
        }
        return ret;
    }

    @Override
    public String getCacheKey() {
        String ret = this.stringifiedCacheKeyValue;
        if (ret == null && this.serviceDef != null && this.serviceDef.getResources() != null) {
            StringBuilder sb = new StringBuilder();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                if (resourceDef == null || !this.exists(resourceDef.getName())) continue;
                if (sb.length() > 0) {
                    sb.append("/");
                }
                sb.append(resourceDef.getName()).append("=").append(this.getValue(resourceDef.getName()));
            }
            if (sb.length() > 0) {
                this.stringifiedCacheKeyValue = ret = sb.toString();
            }
        }
        return ret;
    }

    @Override
    public Map<String, Object> getAsMap() {
        return this.elements == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.elements);
    }

    @Override
    public RangerAccessResource getReadOnlyCopy() {
        return new RangerAccessResourceReadOnly(this);
    }

    @Override
    public void setServiceDef(RangerServiceDef serviceDef) {
        this.serviceDef = serviceDef;
        this.stringifiedValue = null;
        this.stringifiedCacheKeyValue = null;
        this.leafName = null;
    }

    @Override
    public void setOwnerUser(String ownerUser) {
        this.ownerUser = ownerUser;
    }

    @Override
    public void setValue(String name, Object value) {
        if (value == null) {
            if (this.elements != null) {
                this.elements.remove(name);
                if (this.elements.isEmpty()) {
                    this.elements = null;
                }
            }
        } else {
            if (this.elements == null) {
                this.elements = new HashMap<String, Object>();
            }
            this.elements.put(name, value);
        }
        this.stringifiedValue = null;
        this.stringifiedCacheKeyValue = null;
        this.leafName = null;
    }

    public int hashCode() {
        int ret = 7;
        ret = 31 * ret + ObjectUtils.hashCode((Object)this.ownerUser);
        ret = 31 * ret + ObjectUtils.hashCode(this.elements);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RangerAccessResourceImpl)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RangerAccessResourceImpl other = (RangerAccessResourceImpl)obj;
        return ObjectUtils.equals((Object)this.ownerUser, (Object)other.ownerUser) && ObjectUtils.equals(this.elements, other.elements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerResourceImpl={");
        sb.append("ownerUser={").append(this.ownerUser).append("} ");
        sb.append("elements={");
        if (this.elements != null) {
            for (Map.Entry<String, Object> e : this.elements.entrySet()) {
                sb.append(e.getKey()).append("=").append(e.getValue()).append("; ");
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    protected String getStringifiedValue() {
        return this.stringifiedValue;
    }

    protected void setStringifiedValue(String val) {
        this.stringifiedValue = val;
    }
}

