/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheMap<K, V>
extends LinkedHashMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheMap.class);
    private static final long serialVersionUID = 1L;
    private static final float RANGER_CACHE_DEFAULT_LOAD_FACTOR = 0.75f;
    protected int initialCapacity;

    public CacheMap(int initialCapacity) {
        super(initialCapacity, 0.75f, true);
        this.initialCapacity = initialCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry eldest) {
        boolean result = this.size() > this.initialCapacity;
        LOG.debug("CacheMap.removeEldestEntry(), result:{}", (Object)result);
        return result;
    }
}

