/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyResourceSignature;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.model.validation.RangerValidator;
import org.apache.ranger.plugin.model.validation.RangerZoneResourceMatcher;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.store.SecurityZoneStore;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.RangerResourceEvaluatorsRetriever;
import org.apache.ranger.plugin.util.SearchFilter;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSecurityZoneValidator
extends RangerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSecurityZoneValidator.class);
    private final SecurityZoneStore securityZoneStore;

    public RangerSecurityZoneValidator(ServiceStore store, SecurityZoneStore securityZoneStore) {
        super(store);
        this.securityZoneStore = securityZoneStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(RangerSecurityZone securityZone, RangerValidator.Action action) throws Exception {
        LOG.debug("==> RangerSecurityZoneValidator.validate({}, {})", (Object)securityZone, (Object)action);
        ArrayList<ValidationFailureDetails> failures = new ArrayList<ValidationFailureDetails>();
        boolean valid = this.isValid(securityZone, action, failures);
        try {
            if (!valid) {
                String message = RangerSecurityZoneValidator.serializeFailures(failures);
                throw new Exception(message);
            }
        }
        finally {
            LOG.debug("<== RangerSecurityZoneValidator.validate({}, {})", (Object)securityZone, (Object)action);
        }
    }

    @Override
    boolean isValid(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        LOG.debug("==> RangerSecurityZoneValidator.isValid({}, {}, {})", new Object[]{id, action, failures});
        boolean ret = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            ret = false;
        } else if (id == null) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone id was null/missing").field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("id")).build());
            ret = false;
        } else if (this.getSecurityZone(id) == null) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_ZONE_ID;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone id does not exist").field("id").errorCode(error.getErrorCode()).becauseOf(error.getMessage(id)).build());
            ret = false;
        }
        LOG.debug("<== RangerSecurityZoneValidator.isValid({}, {}, {}) : {}", new Object[]{id, action, failures, ret});
        return ret;
    }

    @Override
    boolean isValid(String name, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        LOG.debug("==> RangerSecurityZoneValidator.isValid({}, {}, {})", new Object[]{name, action, failures});
        boolean ret = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            ret = false;
        } else if (StringUtils.isEmpty((String)name)) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone name was null/missing").field("name").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("name")).build());
            ret = false;
        } else if (this.getSecurityZone(name) == null) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_ZONE_ID;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone does not exist").field("name").errorCode(error.getErrorCode()).becauseOf(error.getMessage(name)).build());
            ret = false;
        }
        LOG.debug("<== RangerSecurityZoneValidator.isValid({}, {}, {}) : {}", new Object[]{name, action, failures, ret});
        return ret;
    }

    private boolean isValid(RangerSecurityZone securityZone, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        RangerSecurityZone existingZone;
        LOG.debug("==> RangerSecurityZoneValidator.isValid({}, {}, {})", new Object[]{securityZone, action, failures});
        if (action != RangerValidator.Action.CREATE && action != RangerValidator.Action.UPDATE) {
            throw new IllegalArgumentException("isValid(RangerSecurityZone, ...) is only supported for create/update");
        }
        boolean ret = true;
        String zoneName = securityZone.getName();
        if (StringUtils.isEmpty((String)StringUtils.trim((String)zoneName))) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone name was null/missing").field("name").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("name")).build());
            ret = false;
        }
        if (action == RangerValidator.Action.CREATE) {
            securityZone.setId(-1L);
            existingZone = this.getSecurityZone(zoneName);
            if (existingZone != null) {
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_ZONE_NAME_CONFLICT;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone name exists").field("name").errorCode(error.getErrorCode()).becauseOf(error.getMessage(existingZone.getId())).build());
                ret = false;
            }
        } else {
            Long zoneId = securityZone.getId();
            existingZone = this.getSecurityZone(zoneId);
            if (existingZone == null) {
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_ZONE_ID;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone with id does not exist").field("id").errorCode(error.getErrorCode()).becauseOf(error.getMessage(zoneId)).build());
                ret = false;
            } else if (StringUtils.isNotEmpty((String)StringUtils.trim((String)zoneName)) && !StringUtils.equals((String)zoneName, (String)existingZone.getName()) && (existingZone = this.getSecurityZone(zoneName)) != null) {
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_ZONE_NAME_CONFLICT;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone name").field("name").errorCode(error.getErrorCode()).becauseOf(error.getMessage(existingZone.getId())).build());
                ret = false;
            }
        }
        ret = ret && this.validateWithinSecurityZone(securityZone, action, failures);
        ret = ret && this.validateAgainstAllSecurityZones(securityZone, action, failures);
        LOG.debug("<== RangerSecurityZoneValidator.isValid({}, {}, {}) : {}", new Object[]{securityZone, action, failures, ret});
        return ret;
    }

    private boolean validateWithinSecurityZone(RangerSecurityZone securityZone, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        ValidationErrorCode error;
        LOG.debug("==> RangerSecurityZoneValidator.validateWithinSecurityZone({}, {}, {})", new Object[]{securityZone, action, failures});
        boolean ret = true;
        if (CollectionUtils.isEmpty(securityZone.getAdminUsers()) && CollectionUtils.isEmpty(securityZone.getAdminUserGroups()) && CollectionUtils.isEmpty(securityZone.getAdminRoles())) {
            error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_USER_AND_GROUPS_AND_ROLES;
            failures.add(new ValidationFailureDetailsBuilder().field("security zone admin users/user-groups/roles").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            ret = false;
        }
        if (CollectionUtils.isEmpty(securityZone.getAuditUsers()) && CollectionUtils.isEmpty(securityZone.getAuditUserGroups()) && CollectionUtils.isEmpty(securityZone.getAuditRoles())) {
            error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_USER_AND_GROUPS_AND_ROLES;
            failures.add(new ValidationFailureDetailsBuilder().field("security zone audit users/user-groups/roles").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            ret = false;
        }
        if (MapUtils.isNotEmpty(securityZone.getServices())) {
            for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> entry : securityZone.getServices().entrySet()) {
                RangerSecurityZone.RangerSecurityZoneService securityZoneService;
                String serviceName = entry.getKey();
                ret = this.validateSecurityZoneService(serviceName, securityZoneService = entry.getValue(), failures) && ret;
            }
        }
        LOG.debug("<== RangerSecurityZoneValidator.validateWithinSecurityZone({}, {}, {}) : {}", new Object[]{securityZone, action, failures, ret});
        return ret;
    }

    private boolean validateAgainstAllSecurityZones(RangerSecurityZone securityZone, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        String zoneName;
        LOG.debug("==> RangerSecurityZoneValidator.validateAgainstAllSecurityZones({}, {}, {})", new Object[]{securityZone, action, failures});
        if (securityZone.getId() != -1L) {
            RangerSecurityZone existingZone = this.getSecurityZone(securityZone.getId());
            zoneName = existingZone.getName();
        } else {
            zoneName = securityZone.getName();
        }
        boolean ret = true;
        for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> entry : securityZone.getServices().entrySet()) {
            RangerServiceDef serviceDef;
            String serviceName = entry.getKey();
            RangerSecurityZone.RangerSecurityZoneService securityZoneService = entry.getValue();
            if (CollectionUtils.isEmpty(securityZoneService.getResources())) continue;
            SearchFilter filter = new SearchFilter();
            List<RangerSecurityZone> zones = null;
            filter.setParam("serviceName", serviceName);
            filter.setParam("notZoneName", zoneName);
            try {
                zones = this.securityZoneStore.getSecurityZones(filter);
            }
            catch (Exception excp) {
                LOG.error("Failed to get Security-Zones", (Throwable)excp);
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INTERNAL_ERROR;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf(error.getMessage(excp.getMessage())).errorCode(error.getErrorCode()).build());
                ret = false;
            }
            if (CollectionUtils.isEmpty(zones)) continue;
            RangerService service = this.getService(serviceName);
            RangerServiceDef rangerServiceDef = serviceDef = service != null ? this.getServiceDef(service.getType()) : null;
            if (serviceDef == null) {
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INTERNAL_ERROR;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf(error.getMessage(serviceName)).errorCode(error.getErrorCode()).build());
                ret = false;
                continue;
            }
            zones.add(securityZone);
            ret = ret && this.validateZoneServiceInAllZones(zones, serviceName, serviceDef, failures);
        }
        LOG.debug("<== RangerSecurityZoneValidator.validateAgainstAllSecurityZones({}, {}, {}) : {}", new Object[]{securityZone, action, failures, ret});
        return ret;
    }

    private boolean validateZoneServiceInAllZones(List<RangerSecurityZone> zones, String serviceName, RangerServiceDef serviceDef, List<ValidationFailureDetails> failures) {
        LOG.debug("==> RangerSecurityZoneValidator.validateZoneServiceInAllZones({}, {}, {}, {})", new Object[]{zones, serviceName, serviceDef, failures});
        boolean ret = true;
        RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(serviceDef);
        ArrayList<RangerZoneResourceMatcher> matchers = new ArrayList<RangerZoneResourceMatcher>();
        HashSet resourceNames = new HashSet();
        for (RangerSecurityZone zone : zones) {
            List<HashMap<String, List<String>>> resources;
            Map<String, RangerSecurityZone.RangerSecurityZoneService> zoneServices = zone.getServices();
            RangerSecurityZone.RangerSecurityZoneService zoneService = zoneServices != null ? zoneServices.get(serviceName) : null;
            List<HashMap<String, List<String>>> list = resources = zoneService != null ? zoneService.getResources() : null;
            if (CollectionUtils.isEmpty(resources)) continue;
            for (Map map : resources) {
                HashMap<String, RangerPolicy.RangerPolicyResource> policyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
                for (Map.Entry entry : map.entrySet()) {
                    String resourceDefName = (String)entry.getKey();
                    List resourceValues = (List)entry.getValue();
                    RangerPolicy.RangerPolicyResource policyResource = new RangerPolicy.RangerPolicyResource(resourceValues, (Boolean)false, (Boolean)EmbeddedServiceDefsUtil.isRecursiveEnabled(serviceDef, resourceDefName));
                    policyResources.put(resourceDefName, policyResource);
                }
                RangerZoneResourceMatcher matcher = new RangerZoneResourceMatcher(zone.getName(), policyResources, serviceDefHelper, null);
                matchers.add(matcher);
                resourceNames.addAll(policyResources.keySet());
            }
        }
        HashMap trieMap = new HashMap();
        for (String resourceName : resourceNames) {
            RangerServiceDef.RangerResourceDef resourceDef = ServiceDefUtil.getResourceDef(serviceDef, resourceName);
            trieMap.put(resourceName, new RangerResourceTrie(resourceDef, matchers));
        }
        block4: for (RangerSecurityZone zone : zones) {
            List<HashMap<String, List<String>>> resources = zone.getServices().get(serviceName).getResources();
            for (Map map : resources) {
                Collection collection = RangerResourceEvaluatorsRetriever.getEvaluators(trieMap, map);
                LOG.debug("Resource:[{}], matched-zones:[{}]", (Object)map, collection);
                if (CollectionUtils.isEmpty(collection) || collection.size() == 1) continue;
                RangerAccessResourceImpl accessResource = new RangerAccessResourceImpl();
                accessResource.setServiceDef(serviceDef);
                for (Map.Entry entry : map.entrySet()) {
                    accessResource.setValue((String)entry.getKey(), entry.getValue());
                }
                HashSet<String> matchedZoneNames = new HashSet<String>();
                for (RangerZoneResourceMatcher zoneMatcher : collection) {
                    LOG.debug("Trying to match resource:[{}] using zoneMatcher:[{}]", (Object)accessResource, (Object)zoneMatcher);
                    if (zoneMatcher.getPolicyResourceMatcher().isMatch((RangerAccessResource)accessResource, RangerPolicyResourceMatcher.MatchScope.ANY, null)) {
                        LOG.debug("Matched resource:[{}] using zoneMatcher:[{}]", (Object)accessResource, (Object)zoneMatcher);
                        matchedZoneNames.add(zoneMatcher.getSecurityZoneName());
                        continue;
                    }
                    LOG.debug("Did not match resource:[{}] using zoneMatcher:[{}]", (Object)accessResource, (Object)zoneMatcher);
                }
                LOG.info("The following zone-names matched resource:[{}]: {}", (Object)map, matchedZoneNames);
                if (matchedZoneNames.size() <= 1) continue;
                ValidationErrorCode validationErrorCode = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_ZONE_RESOURCE_CONFLICT;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf(validationErrorCode.getMessage(matchedZoneNames, map)).errorCode(validationErrorCode.getErrorCode()).build());
                ret = false;
                continue block4;
            }
        }
        LOG.debug("<== RangerSecurityZoneValidator.validateZoneServiceInAllZones({}, {}, {}, {}) : {}", new Object[]{zones, serviceName, serviceDef, failures, ret});
        return ret;
    }

    private boolean validateSecurityZoneService(String serviceName, RangerSecurityZone.RangerSecurityZoneService securityZoneService, List<ValidationFailureDetails> failures) {
        LOG.debug("==> RangerSecurityZoneValidator.validateSecurityZoneService({}, {}, {})", new Object[]{serviceName, securityZoneService, failures});
        boolean ret = true;
        RangerService service = this.getService(serviceName);
        if (service == null) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_SERVICE_NAME;
            failures.add(new ValidationFailureDetailsBuilder().field("security zone resource service-name").becauseOf(error.getMessage(serviceName)).errorCode(error.getErrorCode()).build());
            ret = false;
        } else {
            RangerServiceDef serviceDef = this.getServiceDef(service.getType());
            if (serviceDef == null) {
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_SERVICE_TYPE;
                failures.add(new ValidationFailureDetailsBuilder().field("security zone resource service-type").becauseOf(error.getMessage(service.getType())).errorCode(error.getErrorCode()).build());
                ret = false;
            } else if (CollectionUtils.isNotEmpty(securityZoneService.getResources())) {
                HashSet<String> resourceSignatures = new HashSet<String>();
                for (Map map : securityZoneService.getResources()) {
                    Set<String> resourceDefNames = map.keySet();
                    RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(serviceDef);
                    boolean isValidHierarchy = false;
                    block1: for (int policyType : RangerPolicy.POLICY_TYPES) {
                        Set<List<RangerServiceDef.RangerResourceDef>> resourceHierarchies = serviceDefHelper.getResourceHierarchies(policyType, resourceDefNames);
                        LOG.debug("Size of resourceHierarchies for resourceDefNames:[{}, policyType={}] = {}", new Object[]{resourceDefNames, policyType, resourceHierarchies.size()});
                        for (List<RangerServiceDef.RangerResourceDef> resourceHierarchy : resourceHierarchies) {
                            if (RangerDefaultPolicyResourceMatcher.isHierarchyValidForResources(resourceHierarchy, map)) {
                                isValidHierarchy = true;
                                continue block1;
                            }
                            LOG.info("gaps found in resource, skipping hierarchy:[{}]", resourceHierarchies);
                        }
                    }
                    if (!isValidHierarchy) {
                        ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_RESOURCE_HIERARCHY;
                        failures.add(new ValidationFailureDetailsBuilder().field("security zone resource hierarchy").becauseOf(error.getMessage(serviceName, resourceDefNames)).errorCode(error.getErrorCode()).build());
                        ret = false;
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        String resourceName = (String)entry.getKey();
                        List resourceValues = (List)entry.getValue();
                        if (!CollectionUtils.isEmpty((Collection)resourceValues)) continue;
                        ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_RESOURCES;
                        failures.add(new ValidationFailureDetailsBuilder().field("security zone resources").subField("resources").isMissing().becauseOf(error.getMessage(resourceName)).errorCode(error.getErrorCode()).build());
                        ret = false;
                    }
                    RangerPolicyResourceSignature resourceSignature = RangerPolicyResourceSignature.from(map);
                    if (resourceSignatures.add(resourceSignature.getSignature())) continue;
                    ValidationErrorCode validationErrorCode = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_DUPLICATE_RESOURCE_ENTRY;
                    failures.add(new ValidationFailureDetailsBuilder().field("security zone resources").subField("resources").becauseOf(validationErrorCode.getMessage(map, serviceName)).errorCode(validationErrorCode.getErrorCode()).build());
                    ret = false;
                }
            }
        }
        LOG.debug("<== RangerSecurityZoneValidator.validateSecurityZoneService({}, {}, {}) : {}", new Object[]{serviceName, securityZoneService, failures, ret});
        return ret;
    }
}

