/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerAdminConfig;
import org.apache.ranger.plugin.model.RangerGds;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPolicyResourceSignature {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPolicyResourceSignature.class);
    static final int SignatureVersion = 1;
    static final RangerPolicyResourceSignature EmptyResourceSignature = new RangerPolicyResourceSignature((RangerPolicy)null);
    private final String strValue;
    private final String hashValue;
    private final RangerPolicy policy;

    public RangerPolicyResourceSignature(RangerPolicy policy) {
        this.policy = policy;
        PolicySerializer serializer = new PolicySerializer(this.policy);
        this.strValue = serializer.toString();
        this.hashValue = RangerAdminConfig.getInstance().isFipsEnabled() ? DigestUtils.sha512Hex((String)this.strValue) : DigestUtils.sha256Hex((String)this.strValue);
    }

    public RangerPolicyResourceSignature(RangerGds.RangerSharedResource resource) {
        this(RangerPolicyResourceSignature.toSignatureString(resource));
    }

    public RangerPolicyResourceSignature(Map<String, RangerPolicy.RangerPolicyResource> resources) {
        this(RangerPolicyResourceSignature.toSignatureString(resources));
    }

    RangerPolicyResourceSignature(String string) {
        this.policy = null;
        this.strValue = string == null ? "" : string;
        this.hashValue = RangerAdminConfig.getInstance().isFipsEnabled() ? DigestUtils.sha384Hex((String)this.strValue) : DigestUtils.sha256Hex((String)this.strValue);
    }

    public static RangerPolicyResourceSignature from(Map<String, List<String>> resources) {
        return new RangerPolicyResourceSignature(RangerPolicyResourceSignature.toPolicyResources(resources));
    }

    public static String toSignatureString(Map<String, RangerPolicy.RangerPolicyResource> resource) {
        TreeMap<String, ResourceSerializer> resources = new TreeMap<String, ResourceSerializer>();
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resource.entrySet()) {
            String resourceName = entry.getKey();
            ResourceSerializer resourceView = new ResourceSerializer(entry.getValue());
            resources.put(resourceName, resourceView);
        }
        return ((Object)resources).toString();
    }

    public static String toSignatureString(Map<String, RangerPolicy.RangerPolicyResource> resource, List<Map<String, RangerPolicy.RangerPolicyResource>> additionalResources) {
        String ret = RangerPolicyResourceSignature.toSignatureString(resource);
        if (additionalResources != null && !additionalResources.isEmpty()) {
            ArrayList<String> signatures = new ArrayList<String>(additionalResources.size() + 1);
            signatures.add(ret);
            for (Map<String, RangerPolicy.RangerPolicyResource> additionalResource : additionalResources) {
                signatures.add(RangerPolicyResourceSignature.toSignatureString(additionalResource));
            }
            Collections.sort(signatures);
            ret = ((Object)signatures).toString();
        }
        return ret;
    }

    public static String toSignatureString(RangerGds.RangerSharedResource resource) {
        Map<String, RangerPolicy.RangerPolicyResource> policyResource;
        if (StringUtils.isNotBlank((String)resource.getSubResourceType()) && resource.getSubResource() != null && CollectionUtils.isNotEmpty(resource.getSubResource().getValues())) {
            policyResource = new HashMap<String, RangerPolicy.RangerPolicyResource>(resource.getResource());
            policyResource.put(resource.getSubResourceType(), resource.getSubResource());
        } else {
            policyResource = resource.getResource();
        }
        String signature = RangerPolicyResourceSignature.toSignatureString(policyResource);
        if (StringUtils.isNotEmpty((String)resource.getConditionExpr())) {
            signature = signature + resource.getConditionExpr();
        }
        return String.format("{version=%d,ret=%s}", 1, signature);
    }

    public String getSignature() {
        return this.hashValue;
    }

    public int hashCode() {
        return Objects.hashCode(this.hashValue);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RangerPolicyResourceSignature)) {
            return false;
        }
        RangerPolicyResourceSignature that = (RangerPolicyResourceSignature)object;
        return Objects.equals(this.hashValue, that.hashValue);
    }

    public String toString() {
        return String.format("%s: %s", this.hashValue, this.strValue);
    }

    String asString() {
        return this.strValue;
    }

    private static Map<String, RangerPolicy.RangerPolicyResource> toPolicyResources(Map<String, List<String>> resources) {
        TreeMap<String, RangerPolicy.RangerPolicyResource> ret = new TreeMap<String, RangerPolicy.RangerPolicyResource>();
        for (Map.Entry<String, List<String>> entry : resources.entrySet()) {
            ret.put(entry.getKey(), new RangerPolicy.RangerPolicyResource(entry.getValue(), (Boolean)false, (Boolean)false));
        }
        return ret;
    }

    static class CustomConditionSerialiser {
        final List<RangerPolicy.RangerPolicyItemCondition> rangerPolicyConditions;

        CustomConditionSerialiser(List<RangerPolicy.RangerPolicyItemCondition> rangerPolicyConditions) {
            this.rangerPolicyConditions = rangerPolicyConditions;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            TreeMap conditionMap = new TreeMap();
            for (RangerPolicy.RangerPolicyItemCondition rangerPolicyCondition : this.rangerPolicyConditions) {
                if (rangerPolicyCondition.getType() == null) continue;
                String type = rangerPolicyCondition.getType();
                ArrayList<String> values = new ArrayList<String>();
                if (rangerPolicyCondition.getValues() != null) {
                    values.addAll(rangerPolicyCondition.getValues());
                    Collections.sort(values);
                }
                conditionMap.put(type, values);
            }
            if (MapUtils.isNotEmpty(conditionMap)) {
                builder.append("{");
                builder.append("RangerPolicyConditions=");
                builder.append(conditionMap);
                builder.append("}");
            }
            return builder.toString();
        }
    }

    public static class ResourceSerializer {
        final RangerPolicy.RangerPolicyResource policyResource;

        public ResourceSerializer(RangerPolicy.RangerPolicyResource policyResource) {
            this.policyResource = policyResource;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{");
            if (this.policyResource != null) {
                builder.append("values=");
                if (this.policyResource.getValues() != null) {
                    ArrayList<String> values = new ArrayList<String>(this.policyResource.getValues());
                    Collections.sort(values);
                    builder.append(values);
                }
                builder.append(",excludes=");
                if (this.policyResource.getIsExcludes() == null) {
                    builder.append(Boolean.FALSE);
                } else {
                    builder.append(this.policyResource.getIsExcludes());
                }
                builder.append(",recursive=");
                if (this.policyResource.getIsRecursive() == null) {
                    builder.append(Boolean.FALSE);
                } else {
                    builder.append(this.policyResource.getIsRecursive());
                }
            }
            builder.append("}");
            return builder.toString();
        }
    }

    static class PolicySerializer {
        final RangerPolicy policy;

        PolicySerializer(RangerPolicy policy) {
            this.policy = policy;
        }

        public String toString() {
            if (!this.isPolicyValidForResourceSignatureComputation()) {
                return "";
            }
            int type = 0;
            if (this.policy.getPolicyType() != null) {
                type = this.policy.getPolicyType();
            }
            String resource = RangerPolicyResourceSignature.toSignatureString(this.policy.getResources(), this.policy.getAdditionalResources());
            if (CollectionUtils.isNotEmpty(this.policy.getValiditySchedules())) {
                resource = resource + this.policy.getValiditySchedules().toString();
            }
            if (this.policy.getPolicyPriority() != null && this.policy.getPolicyPriority() != 0) {
                resource = resource + this.policy.getPolicyPriority();
            }
            if (!StringUtils.isEmpty((String)this.policy.getZoneName())) {
                resource = resource + this.policy.getZoneName();
            }
            if (this.policy.getConditions() != null) {
                CustomConditionSerialiser customConditionSerialiser = new CustomConditionSerialiser(this.policy.getConditions());
                resource = resource + customConditionSerialiser.toString();
            }
            if (!this.policy.getIsEnabled().booleanValue()) {
                resource = resource + this.policy.getGuid();
            }
            return String.format("{version=%d,type=%d,resource=%s}", 1, type, resource);
        }

        boolean isPolicyValidForResourceSignatureComputation() {
            LOG.debug("==> RangerPolicyResourceSignature.isPolicyValidForResourceSignatureComputation({})", (Object)this.policy);
            boolean valid = false;
            if (this.policy == null) {
                LOG.debug("isPolicyValidForResourceSignatureComputation: policy was null!");
            } else if (this.policy.getResources() == null) {
                LOG.debug("isPolicyValidForResourceSignatureComputation: resources collection on policy was null!");
            } else if (this.policy.getResources().containsKey(null)) {
                LOG.debug("isPolicyValidForResourceSignatureComputation: resources collection has resource with null name!");
            } else if (!this.policy.getIsEnabled().booleanValue() && StringUtils.isEmpty((String)this.policy.getGuid())) {
                LOG.debug("isPolicyValidForResourceSignatureComputation: policy GUID is empty for a disabled policy!");
            } else {
                valid = true;
            }
            LOG.debug("<== RangerPolicyResourceSignature.isPolicyValidForResourceSignatureComputation({}): {}}", (Object)this.policy, (Object)valid);
            return valid;
        }
    }
}

