/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ranger.plugin.model.RangerPrincipal;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerGrant
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RangerPrincipal principal;
    private List<String> accessTypes;
    private List<Condition> conditions;

    public RangerGrant() {
        this(null, null, null);
    }

    public RangerGrant(RangerPrincipal principal, List<String> accessTypes, List<Condition> conditions) {
        this.setPrincipal(principal);
        this.setAccessTypes(accessTypes);
        this.setConditions(conditions);
    }

    public RangerPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(RangerPrincipal principal) {
        this.principal = principal;
    }

    public List<String> getAccessTypes() {
        return this.accessTypes;
    }

    public void setAccessTypes(List<String> accessTypes) {
        if (this.accessTypes == null) {
            this.accessTypes = new ArrayList<String>();
        }
        if (this.accessTypes == accessTypes) {
            return;
        }
        this.accessTypes.clear();
        if (accessTypes != null) {
            this.accessTypes.addAll(accessTypes);
        }
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        if (this.conditions == conditions) {
            return;
        }
        this.conditions.clear();
        if (conditions != null) {
            this.conditions.addAll(conditions);
        }
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.accessTypes, this.conditions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangerGrant other = (RangerGrant)obj;
        return Objects.equals(this.principal, other.principal) && Objects.equals(this.accessTypes, other.accessTypes) && Objects.equals(this.conditions, other.conditions);
    }

    public String toString() {
        return "RangerGrant{principal='" + this.principal.toString() + ", accessTypes=" + this.accessTypes + ", conditions=" + this.conditions + '}';
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Condition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String type;
        private List<String> values;

        public Condition() {
            this(null, null);
        }

        public Condition(String type, List<String> values) {
            this.setType(type);
            this.setValues(values);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            if (this.values == values) {
                return;
            }
            this.values.clear();
            if (values != null) {
                this.values.addAll(values);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Condition that = (Condition)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.values);
        }

        public String toString() {
            return "Conditions{type='" + this.type + '\'' + ", values=" + this.values + '}';
        }
    }
}

