/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ClosedByInterruptException;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreEnricher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRetriever;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerUserStoreRefresher
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(RangerUserStoreRefresher.class);
    private static final Logger PERF_REFRESHER_INIT_LOG = RangerPerfTracer.getPerfLogger("userstore.init");
    private final RangerUserStoreRetriever userStoreRetriever;
    private final RangerUserStoreEnricher userStoreEnricher;
    private final BlockingQueue<DownloadTrigger> userStoreDownloadQueue;
    private final String cacheFile;
    private long lastKnownVersion;
    private long lastActivationTimeInMillis;
    private boolean hasProvidedUserStoreToReceiver;
    private final RangerRESTClient rangerRESTClient;

    public RangerUserStoreRefresher(RangerUserStoreRetriever userStoreRetriever, RangerUserStoreEnricher userStoreEnricher, RangerRESTClient restClient, long lastKnownVersion, BlockingQueue<DownloadTrigger> userStoreDownloadQueue, String cacheFile) {
        this.userStoreRetriever = userStoreRetriever;
        this.userStoreEnricher = userStoreEnricher;
        this.rangerRESTClient = restClient;
        this.lastKnownVersion = lastKnownVersion;
        this.userStoreDownloadQueue = userStoreDownloadQueue;
        this.cacheFile = cacheFile;
        this.setName("RangerUserStoreRefresher(serviceName=" + userStoreRetriever.getServiceName() + ")-" + this.getId());
    }

    public long getLastActivationTimeInMillis() {
        return this.lastActivationTimeInMillis;
    }

    public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
        this.lastActivationTimeInMillis = lastActivationTimeInMillis;
    }

    @Override
    public void run() {
        LOG.debug("==> RangerUserStoreRefresher().run()");
        while (true) {
            DownloadTrigger trigger = null;
            try {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_REFRESHER_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_REFRESHER_INIT_LOG, "RangerUserStoreRefresher.run(lastKnownVersion=" + this.lastKnownVersion + ")");
                }
                trigger = this.userStoreDownloadQueue.take();
                this.populateUserStoreInfo();
                RangerPerfTracer.log(perf);
                continue;
            }
            catch (InterruptedException excp) {
                LOG.debug("RangerUserStoreRefresher().run() : interrupted! Exiting thread", (Throwable)excp);
            }
            finally {
                if (trigger == null) continue;
                trigger.signalCompletion();
                continue;
            }
            break;
        }
        LOG.debug("<== RangerUserStoreRefresher().run()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RangerUserStore populateUserStoreInfo() throws InterruptedException {
        RangerUserStore rangerUserStore = null;
        if (this.userStoreEnricher != null && this.userStoreRetriever != null) {
            try {
                rangerUserStore = this.userStoreRetriever.retrieveUserStoreInfo(this.lastKnownVersion, this.lastActivationTimeInMillis);
                if (rangerUserStore == null && !this.hasProvidedUserStoreToReceiver) {
                    rangerUserStore = this.loadFromCache();
                }
                if (rangerUserStore != null) {
                    this.userStoreEnricher.setRangerUserStore(rangerUserStore);
                    if (rangerUserStore.getUserStoreVersion() != -1L) {
                        this.saveToCache(rangerUserStore);
                    }
                    LOG.info("RangerUserStoreRefresher.populateUserStoreInfo() - Updated userstore-cache to new version, lastKnownVersion={}; newVersion={}", (Object)this.lastKnownVersion, (Object)(rangerUserStore.getUserStoreVersion() == null ? -1L : rangerUserStore.getUserStoreVersion()));
                    this.hasProvidedUserStoreToReceiver = true;
                    this.lastKnownVersion = rangerUserStore.getUserStoreVersion() == null ? -1L : rangerUserStore.getUserStoreVersion();
                    this.setLastActivationTimeInMillis(System.currentTimeMillis());
                    return rangerUserStore;
                }
                LOG.debug("RangerUserStoreRefresher.populateUserStoreInfo() - No need to update userstore-cache. lastKnownVersion={}", (Object)this.lastKnownVersion);
                return rangerUserStore;
            }
            catch (RangerServiceNotFoundException snfe) {
                LOG.error("Caught ServiceNotFound exception :", (Throwable)snfe);
                if (!this.userStoreEnricher.isDisableCacheIfServiceNotFound()) return rangerUserStore;
                this.disableCache();
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = -1L;
                return rangerUserStore;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception e) {
                LOG.error("Encountered unexpected exception. Ignoring", (Throwable)e);
                return rangerUserStore;
            }
        } else if (this.rangerRESTClient != null) {
            LOG.debug("RangerUserStoreRefresher.populateUserStoreInfo() for Ranger Raz");
            try {
                rangerUserStore = this.retrieveUserStoreInfo();
                if (rangerUserStore == null && !this.hasProvidedUserStoreToReceiver) {
                    rangerUserStore = this.loadFromCache();
                }
                if (rangerUserStore != null) {
                    if (rangerUserStore.getUserStoreVersion() != -1L) {
                        this.saveToCache(rangerUserStore);
                    }
                    LOG.info("RangerUserStoreRefresher.populateUserStoreInfo() - Updated userstore-cache for raz to new version, lastKnownVersion={}; newVersion={}", (Object)this.lastKnownVersion, (Object)(rangerUserStore.getUserStoreVersion() == null ? -1L : rangerUserStore.getUserStoreVersion()));
                    this.hasProvidedUserStoreToReceiver = true;
                    this.lastKnownVersion = rangerUserStore.getUserStoreVersion() == null ? -1L : rangerUserStore.getUserStoreVersion();
                    this.setLastActivationTimeInMillis(System.currentTimeMillis());
                    return rangerUserStore;
                }
                LOG.debug("RangerUserStoreRefresher.populateUserStoreInfo() - No need to update userstore-cache for raz. lastKnownVersion={}", (Object)this.lastKnownVersion);
                return rangerUserStore;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception e) {
                LOG.error("Encountered unexpected exception. Ignoring", (Throwable)e);
                return rangerUserStore;
            }
        } else {
            LOG.error("RangerUserStoreRefresher.populateUserStoreInfo() - no userstore receiver to update userstore-cache");
        }
        return rangerUserStore;
    }

    public void cleanup() {
        LOG.debug("==> RangerUserStoreRefresher.cleanup()");
        this.stopRefresher();
        LOG.debug("<== RangerUserStoreRefresher.cleanup()");
    }

    public void startRefresher() {
        try {
            super.start();
        }
        catch (Exception excp) {
            LOG.error("RangerUserStoreRefresher.startRetriever() - failed to start, exception={}", (Object)excp.toString());
        }
    }

    public void stopRefresher() {
        if (super.isAlive()) {
            super.interrupt();
            boolean setInterrupted = false;
            boolean isJoined = false;
            while (!isJoined) {
                try {
                    super.join();
                    isJoined = true;
                }
                catch (InterruptedException excp) {
                    LOG.warn("RangerUserStoreRefresher(): Error while waiting for thread to exit", (Throwable)excp);
                    LOG.warn("Retrying Thread.join(). Current thread will be marked as 'interrupted' after Thread.join() returns");
                    setInterrupted = true;
                }
            }
            if (setInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToCache(RangerUserStore rangerUserStore) {
        LOG.debug("==> RangerUserStoreRefreher.saveToCache()");
        if (rangerUserStore != null) {
            File cacheFile;
            File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
            if (cacheFile != null) {
                FileWriter writer = null;
                try {
                    writer = new FileWriter(cacheFile);
                    JsonUtils.objectToWriter(writer, rangerUserStore);
                }
                catch (Exception excp) {
                    LOG.error("failed to save userstore information to cache file '{}'", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                }
                finally {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Exception excp) {
                            LOG.error("error while closing opened cache file '{}'", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                        }
                    }
                }
            }
        } else {
            LOG.info("userstore information is null. Nothing to save in cache");
        }
        LOG.debug("<== RangerUserStoreRefreher.saveToCache()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangerUserStore loadFromCache() {
        File cacheFile;
        RangerUserStore rangerUserStore = null;
        LOG.debug("==> RangerUserStoreRefreher.loadFromCache()");
        File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            FileReader reader = null;
            try {
                reader = new FileReader(cacheFile);
                rangerUserStore = JsonUtils.jsonToObject(reader, RangerUserStore.class);
            }
            catch (Exception excp) {
                LOG.error("failed to load userstore information from cache file {}", (Object)cacheFile.getAbsolutePath(), (Object)excp);
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception excp) {
                        LOG.error("error while closing opened cache file {}", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                    }
                }
            }
        } else {
            LOG.warn("cache file does not exist or not readable '{}'", (Object)(cacheFile == null ? null : cacheFile.getAbsolutePath()));
        }
        LOG.debug("<== RangerUserStoreRefreher.loadFromCache()");
        return rangerUserStore;
    }

    private void disableCache() {
        File cacheFile;
        LOG.debug("==> RangerUserStoreRefreher.disableCache()");
        File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            LOG.warn("Cleaning up local userstore cache");
            String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
            if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                LOG.error("Failed to move {} to {}", (Object)cacheFile.getAbsolutePath(), (Object)renamedCacheFile);
            } else {
                LOG.warn("moved {} to {}", (Object)cacheFile.getAbsolutePath(), (Object)renamedCacheFile);
            }
        } else {
            LOG.debug("No local userstore cache found. No need to disable it!");
        }
        LOG.debug("<== RangerUserStoreRefreher.disableCache()");
    }

    private RangerUserStore retrieveUserStoreInfo() throws Exception {
        RangerUserStore rangerUserStore = null;
        try {
            rangerUserStore = this.getUserStoreIfUpdated(this.lastKnownVersion, this.lastActivationTimeInMillis);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            LOG.error("UserStore-retriever for raz thread was interrupted while blocked on I/O");
            throw new InterruptedException();
        }
        catch (Exception e) {
            LOG.error("UserStore-retriever for raz encounterd exception, exception=", (Throwable)e);
            LOG.error("Returning null userstore info");
        }
        return rangerUserStore;
    }

    private RangerUserStore getUserStoreIfUpdated(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore ret;
        ClientResponse response;
        LOG.debug("==> RangerUserStoreRefreher.getUserStoreIfUpdated({}, {})", (Object)lastKnownUserStoreVersion, (Object)lastActivationTimeInMillis);
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownUserStoreVersion", Long.toString(lastKnownUserStoreVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        if (isSecureMode) {
            LOG.debug("Checking UserStore updated as user : {}", (Object)user);
            response = (ClientResponse)MiscUtil.executePrivilegedAction(() -> {
                try {
                    String relativeURL = "/service/xusers/secure/download/";
                    return this.rangerRESTClient.get(relativeURL, queryParams);
                }
                catch (Exception e) {
                    LOG.error("Failed to get response, Error is : {}", (Object)e.getMessage());
                    return null;
                }
            });
        } else {
            LOG.debug("Checking UserStore updated as user : {}", (Object)user);
            String relativeURL = "/service/xusers/secure/download/";
            response = this.rangerRESTClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting UserStore; Received NULL response!!. secureMode={}, user={}", (Object)isSecureMode, (Object)user);
            } else {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.debug("No change in UserStore. secureMode={}, user={}, response={}, lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}", new Object[]{isSecureMode, user, resp, lastKnownUserStoreVersion, lastActivationTimeInMillis});
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = JsonUtilsV2.readResponse(response, RangerUserStore.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting UserStore; service not found. secureMode={}, user={}, response={}, lastKnownUserStoreVersion={}, lastActivationTimeInMillis={}", new Object[]{isSecureMode, user, response.getStatus(), lastKnownUserStoreVersion, lastActivationTimeInMillis});
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            LOG.warn("Received 404 error code with body:[{}], Ignoring", (Object)exceptionMsg);
        } else {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting UserStore. secureMode={}, user={}, response={}", new Object[]{isSecureMode, user, resp});
            ret = null;
        }
        LOG.debug("<== RangerUserStoreRefreher.getUserStoreIfUpdated({}, {}): ", (Object)lastKnownUserStoreVersion, (Object)lastActivationTimeInMillis);
        return ret;
    }
}

