/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRefresher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRetriever;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.DownloaderTask;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerUserStoreEnricher
extends RangerAbstractContextEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerUserStoreEnricher.class);
    private static final Logger PERF_SET_USERSTORE_LOG = RangerPerfTracer.getPerfLogger("userstoreenricher.setuserstore");
    public static final String USERSTORE_REFRESHER_POLLINGINTERVAL_OPTION = "userStoreRefresherPollingInterval";
    public static final String USERSTORE_RETRIEVER_CLASSNAME_OPTION = "userStoreRetrieverClassName";
    private final BlockingQueue<DownloadTrigger> userStoreDownloadQueue = new LinkedBlockingQueue<DownloadTrigger>();
    private RangerUserStoreRefresher userStoreRefresher;
    private RangerUserStoreRetriever userStoreRetriever;
    private RangerUserStore rangerUserStore;
    private boolean disableCacheIfServiceNotFound = true;
    private boolean dedupStrings = true;
    private Timer userStoreDownloadTimer;

    @Override
    public void init() {
        LOG.debug("==> RangerUserStoreEnricher.init()");
        super.init();
        String propertyPrefix = this.getPropertyPrefix();
        String userStoreRetrieverClassName = this.getOption(USERSTORE_RETRIEVER_CLASSNAME_OPTION);
        long pollingIntervalMs = this.getLongOption(USERSTORE_REFRESHER_POLLINGINTERVAL_OPTION, 3600000L);
        this.dedupStrings = this.getBooleanConfig(propertyPrefix + ".dedup.strings", true);
        if (StringUtils.isNotBlank((String)userStoreRetrieverClassName)) {
            try {
                Class<?> userStoreRetriverClass = Class.forName(userStoreRetrieverClassName);
                this.userStoreRetriever = (RangerUserStoreRetriever)userStoreRetriverClass.newInstance();
            }
            catch (ClassNotFoundException exception) {
                LOG.error("Class {} not found, exception={}", (Object)userStoreRetrieverClassName, (Object)exception);
            }
            catch (ClassCastException exception) {
                LOG.error("Class {} is not a type of RangerUserStoreRetriever, exception={}", (Object)userStoreRetrieverClassName, (Object)exception);
            }
            catch (IllegalAccessException exception) {
                LOG.error("Class {} illegally accessed, exception={}", (Object)userStoreRetrieverClassName, (Object)exception);
            }
            catch (InstantiationException exception) {
                LOG.error("Class {} could not be instantiated, exception={}", (Object)userStoreRetrieverClassName, (Object)exception);
            }
            if (this.userStoreRetriever != null) {
                this.disableCacheIfServiceNotFound = this.getBooleanConfig(propertyPrefix + ".disable.cache.if.servicenotfound", true);
                String cacheDir = this.getConfig(propertyPrefix + ".policy.cache.dir", null);
                String cacheFilename = String.format("%s_%s_userstore.json", this.appId, this.serviceName);
                cacheFilename = cacheFilename.replace(File.separatorChar, '_');
                cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
                String cacheFile = cacheDir == null ? null : cacheDir + File.separator + cacheFilename;
                this.userStoreRetriever.setServiceName(this.serviceName);
                this.userStoreRetriever.setServiceDef(this.serviceDef);
                this.userStoreRetriever.setAppId(this.appId);
                this.userStoreRetriever.setPluginConfig(this.getPluginConfig());
                this.userStoreRetriever.setPluginContext(this.getPluginContext());
                this.userStoreRetriever.init(this.enricherDef.getEnricherOptions());
                this.userStoreRefresher = new RangerUserStoreRefresher(this.userStoreRetriever, this, null, -1L, this.userStoreDownloadQueue, cacheFile);
                LOG.info("Created Thread(RangerUserStoreRefresher({})", (Object)this.getName());
                try {
                    this.userStoreRefresher.populateUserStoreInfo();
                }
                catch (Throwable exception) {
                    LOG.error("Exception when retrieving userstore information for this enricher", exception);
                }
                this.userStoreRefresher.setDaemon(true);
                this.userStoreRefresher.startRefresher();
                this.userStoreDownloadTimer = new Timer("userStoreDownloadTimer", true);
                try {
                    this.userStoreDownloadTimer.schedule((TimerTask)new DownloaderTask(this.userStoreDownloadQueue), pollingIntervalMs, pollingIntervalMs);
                    LOG.debug("Scheduled userStoreDownloadRefresher to download userstore every {} milliseconds", (Object)pollingIntervalMs);
                }
                catch (IllegalStateException exception) {
                    LOG.error("Error scheduling userStoreDownloadTimer:", (Throwable)exception);
                    LOG.error("*** UserStore information will NOT be downloaded every {} milliseconds ***", (Object)pollingIntervalMs);
                    this.userStoreDownloadTimer = null;
                }
            }
        } else {
            LOG.error("No value specified for {} in the RangerUserStoreEnricher options", (Object)USERSTORE_RETRIEVER_CLASSNAME_OPTION);
        }
        LOG.debug("<== RangerUserStoreEnricher.init()");
    }

    @Override
    public void enrich(RangerAccessRequest request, Object dataStore) {
        RangerUserStore rangerUserStore;
        LOG.debug("==> RangerUserStoreEnricher.enrich({}) with dataStore:[{}]", (Object)request, dataStore);
        if (dataStore instanceof RangerUserStore) {
            rangerUserStore = (RangerUserStore)dataStore;
        } else {
            rangerUserStore = this.rangerUserStore;
            if (dataStore != null) {
                LOG.warn("Incorrect type of dataStore :[{}], falling back to original enrich", (Object)dataStore.getClass().getName());
            }
        }
        RangerAccessRequestUtil.setRequestUserStoreInContext(request.getContext(), rangerUserStore);
        LOG.debug("<== RangerUserStoreEnricher.enrich({}) with dataStore:[{}]", (Object)request, dataStore);
    }

    @Override
    public boolean preCleanup() {
        LOG.debug("==> RangerUserStoreEnricher.preCleanup()");
        super.preCleanup();
        if (this.userStoreDownloadTimer != null) {
            this.userStoreDownloadTimer.cancel();
            this.userStoreDownloadTimer = null;
        }
        if (this.userStoreRefresher != null) {
            this.userStoreRefresher.cleanup();
            this.userStoreRefresher = null;
        }
        LOG.debug("<== RangerUserStoreEnricher.preCleanup() : result={}", (Object)true);
        return true;
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        LOG.debug("==> RangerUserStoreEnricher.enrich({})", (Object)request);
        this.enrich(request, null);
        LOG.debug("<== RangerUserStoreEnricher.enrich({})", (Object)request);
    }

    public boolean isDisableCacheIfServiceNotFound() {
        return this.disableCacheIfServiceNotFound;
    }

    public RangerUserStore getRangerUserStore() {
        return this.rangerUserStore;
    }

    public void setRangerUserStore(RangerUserStore rangerUserStore) {
        LOG.debug("==> RangerUserStoreEnricher.setRangerUserStore(rangerUserStore={})", (Object)rangerUserStore);
        if (rangerUserStore == null) {
            LOG.info("UserStore information is null for service {}", (Object)this.serviceName);
            this.rangerUserStore = null;
        } else {
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_SET_USERSTORE_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_SET_USERSTORE_LOG, "RangerUserStoreEnricher.setRangerUserStore(newUserStoreVersion=" + rangerUserStore.getUserStoreVersion() + ")");
            }
            if (this.dedupStrings) {
                rangerUserStore.dedupStrings();
            }
            this.rangerUserStore = rangerUserStore;
            RangerPerfTracer.logAlways(perf);
        }
        this.setRangerUserStoreInPlugin();
        LOG.debug("<== RangerUserStoreEnricher.setRangerUserStore(rangerUserStore={})", (Object)rangerUserStore);
    }

    public Long getUserStoreVersion() {
        RangerUserStore localUserStore = this.rangerUserStore;
        return localUserStore != null ? localUserStore.getUserStoreVersion() : null;
    }

    private void setRangerUserStoreInPlugin() {
        LOG.debug("==> setRangerUserStoreInPlugin()");
        RangerAuthContext authContext = this.getAuthContext();
        if (authContext != null) {
            authContext.addOrReplaceRequestContextEnricher(this, this.rangerUserStore);
            this.notifyAuthContextChanged();
        }
        LOG.debug("<== setRangerUserStoreInPlugin()");
    }
}

