/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerGdsInfoRetriever;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.gds.GdsAccessResult;
import org.apache.ranger.plugin.policyengine.gds.GdsPolicyEngine;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.DownloaderTask;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerGdsEnricher
extends RangerAbstractContextEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerGdsEnricher.class);
    public static final String REFRESHER_POLLINGINTERVAL_OPTION = "refresherPollingInterval";
    public static final String RETRIEVER_CLASSNAME_OPTION = "retrieverClassName";
    private RangerGdsInfoRetriever gdsInfoRetriever;
    private RangerGdsInfoRefresher gdsInfoRefresher;
    private RangerServiceDefHelper serviceDefHelper;
    private GdsPolicyEngine gdsPolicyEngine;

    @Override
    public void init() {
        LOG.debug("==> RangerGdsEnricher.init()");
        super.init();
        String propertyPrefix = "ranger.plugin." + this.serviceDef.getName();
        String retrieverClassName = this.getOption(RETRIEVER_CLASSNAME_OPTION);
        long pollingIntervalMs = this.getLongOption(REFRESHER_POLLINGINTERVAL_OPTION, 60000L);
        String cacheFile = null;
        this.serviceDefHelper = new RangerServiceDefHelper(this.serviceDef, false);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)retrieverClassName)) {
            try {
                Class<?> retriverClass = Class.forName(retrieverClassName);
                this.gdsInfoRetriever = (RangerGdsInfoRetriever)retriverClass.newInstance();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException excp) {
                LOG.error("Failed to instantiate retriever (className={})", (Object)retrieverClassName, (Object)excp);
            }
        }
        if (this.gdsInfoRetriever != null) {
            String cacheDir = this.getConfig(propertyPrefix + ".policy.cache.dir", null);
            String cacheFilename = String.format("%s_%s_gds.json", this.appId, this.serviceName);
            cacheFilename = cacheFilename.replace(File.separatorChar, '_');
            cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
            cacheFile = cacheDir == null ? null : cacheDir + File.separator + cacheFilename;
            this.gdsInfoRetriever.setServiceName(this.serviceName);
            this.gdsInfoRetriever.setServiceDef(this.serviceDef);
            this.gdsInfoRetriever.setAppId(this.appId);
            this.gdsInfoRetriever.setPluginConfig(this.getPluginConfig());
            this.gdsInfoRetriever.setPluginContext(this.getPluginContext());
            this.gdsInfoRetriever.init(this.enricherDef.getEnricherOptions());
            this.gdsInfoRefresher = new RangerGdsInfoRefresher(this.gdsInfoRetriever, pollingIntervalMs, cacheFile, -1L);
            try {
                this.gdsInfoRefresher.populateGdsInfo();
            }
            catch (Throwable excp) {
                LOG.error("RangerGdsEnricher.init(): failed to retrieve gdsInfo", excp);
            }
            this.gdsInfoRefresher.setDaemon(true);
            this.gdsInfoRefresher.startRefresher();
        } else {
            LOG.error("No value specified for {} in the RangerGdsEnricher options", (Object)RETRIEVER_CLASSNAME_OPTION);
        }
        LOG.info("RangerGdsEnricher.init(): retrieverClassName={}, pollingIntervalMs={}, cacheFile={}", new Object[]{retrieverClassName, pollingIntervalMs, cacheFile});
        LOG.debug("<== RangerGdsEnricher.init()");
    }

    @Override
    public void enrich(RangerAccessRequest request, Object dataStore) {
        LOG.debug("==> RangerGdsEnricher.enrich({}, {})", (Object)request, dataStore);
        GdsPolicyEngine policyEngine = dataStore instanceof GdsPolicyEngine ? (GdsPolicyEngine)dataStore : this.gdsPolicyEngine;
        LOG.debug("RangerGdsEnricher.enrich(): using policyEngine={}", (Object)policyEngine);
        GdsAccessResult result = policyEngine != null ? policyEngine.evaluate(request) : null;
        RangerAccessRequestUtil.setGdsResultInContext(request, result);
        LOG.debug("<== RangerGdsEnricher.enrich({}, {})", (Object)request, dataStore);
    }

    @Override
    public boolean preCleanup() {
        LOG.debug("==> RangerGdsEnricher.preCleanup()");
        super.preCleanup();
        RangerGdsInfoRefresher gdsInfoRefresher = this.gdsInfoRefresher;
        this.gdsInfoRefresher = null;
        if (gdsInfoRefresher != null) {
            LOG.debug("Trying to clean up RangerGdsInfoRefresher({})", (Object)gdsInfoRefresher.getName());
            gdsInfoRefresher.cleanup();
        }
        LOG.debug("<== RangerGdsEnricher.preCleanup(): result={}", (Object)true);
        return true;
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        LOG.debug("==> RangerGdsEnricher.enrich({})", (Object)request);
        this.enrich(request, null);
        LOG.debug("<== RangerGdsEnricher.enrich({})", (Object)request);
    }

    public void setGdsInfo(ServiceGdsInfo gdsInfo) {
        this.gdsPolicyEngine = new GdsPolicyEngine(gdsInfo, this.serviceDefHelper, this.getPluginContext());
        this.setGdsInfoInPlugin();
    }

    public RangerServiceDefHelper getServiceDefHelper() {
        return this.serviceDefHelper;
    }

    public GdsPolicyEngine getGdsPolicyEngine() {
        return this.gdsPolicyEngine;
    }

    private void setGdsInfoInPlugin() {
        LOG.debug("==> setGdsInfoInPlugin()");
        RangerAuthContext authContext = this.getAuthContext();
        if (authContext != null) {
            authContext.addOrReplaceRequestContextEnricher(this, this.gdsPolicyEngine);
            this.notifyAuthContextChanged();
        }
        LOG.debug("<== setGdsInfoInPlugin()");
    }

    private class RangerGdsInfoRefresher
    extends Thread {
        private final RangerGdsInfoRetriever retriever;
        private final long pollingIntervalMs;
        private final String cacheFile;
        private Long lastKnownVersion;
        private long lastActivationTimeInMillis;
        private Timer downloadTimer;
        private BlockingQueue<DownloadTrigger> downloadQueue;
        private boolean gdsInfoSetInPlugin;

        public RangerGdsInfoRefresher(RangerGdsInfoRetriever retriever, long pollingIntervalMs, String cacheFile, long lastKnownVersion) {
            super("RangerGdsInfoRefresher");
            this.retriever = retriever;
            this.pollingIntervalMs = pollingIntervalMs;
            this.cacheFile = cacheFile;
            this.lastKnownVersion = lastKnownVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                BlockingQueue<DownloadTrigger> downloadQueue = this.downloadQueue;
                DownloadTrigger trigger = null;
                try {
                    if (downloadQueue == null) {
                        LOG.error("RangerGdsInfoRefresher(serviceName={}).run(): downloadQueue is null", (Object)RangerGdsEnricher.this.serviceName);
                        break;
                    }
                    trigger = downloadQueue.take();
                    this.populateGdsInfo();
                    continue;
                }
                catch (InterruptedException excp) {
                    LOG.info("RangerGdsInfoRefresher(serviceName={}).run() interrupted! Exiting thread", (Object)RangerGdsEnricher.this.serviceName, (Object)excp);
                }
                catch (Exception excp) {
                    LOG.error("RangerGdsInfoRefresher(serviceName={}).run() failed to download gdsInfo. Will retry again", (Object)RangerGdsEnricher.this.serviceName, (Object)excp);
                    continue;
                }
                finally {
                    if (trigger == null) continue;
                    trigger.signalCompletion();
                    continue;
                }
                break;
            }
        }

        final void startRefresher() {
            try {
                this.downloadTimer = new Timer("gdsInfoDownloadTimer", true);
                this.downloadQueue = new LinkedBlockingQueue<DownloadTrigger>();
                super.start();
                this.downloadTimer.schedule((TimerTask)new DownloaderTask(this.downloadQueue), this.pollingIntervalMs, this.pollingIntervalMs);
                LOG.debug("Scheduled timer to download gdsInfo every {} milliseconds", (Object)this.pollingIntervalMs);
            }
            catch (IllegalStateException exception) {
                LOG.error("Error scheduling gdsInfo download", (Throwable)exception);
                LOG.error("*** GdsInfo will NOT be downloaded every {} milliseconds ***", (Object)this.pollingIntervalMs);
                this.stopRefresher();
            }
        }

        void cleanup() {
            LOG.debug("==> RangerGdsInfoRefresher.cleanup()");
            this.stopRefresher();
            LOG.debug("<== RangerGdsInfoRefresher.cleanup()");
        }

        ServiceGdsInfo loadFromCache() {
            File cacheFile;
            LOG.debug("==> RangerGdsInfoRefresher(serviceName={}).loadFromCache()", (Object)RangerGdsEnricher.this.getServiceName());
            ServiceGdsInfo ret = null;
            File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
            if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
                try (FileReader reader = new FileReader(cacheFile);){
                    ret = JsonUtilsV2.readValue(reader, ServiceGdsInfo.class);
                }
                catch (Exception excp) {
                    LOG.error("failed to load gdsInfo from cache file {}", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                }
            } else {
                LOG.warn("cache file does not exist or not readable '{}'", (Object)(cacheFile == null ? null : cacheFile.getAbsolutePath()));
            }
            LOG.debug("<== RangerGdsInfoRefresher(serviceName={}).loadFromCache()", (Object)RangerGdsEnricher.this.getServiceName());
            return ret;
        }

        void saveToCache(ServiceGdsInfo gdsInfo) {
            LOG.debug("==> RangerGdsInfoRefresher(serviceName={}).saveToCache()", (Object)RangerGdsEnricher.this.getServiceName());
            if (gdsInfo != null) {
                File cacheFile;
                File file = cacheFile = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.cacheFile) ? null : new File(this.cacheFile);
                if (cacheFile != null) {
                    try (FileWriter writer = new FileWriter(cacheFile);){
                        JsonUtilsV2.writeValue(writer, gdsInfo);
                    }
                    catch (Exception excp) {
                        LOG.error("failed to save gdsInfo to cache file '{}'", (Object)cacheFile.getAbsolutePath(), (Object)excp);
                    }
                }
            } else {
                LOG.info("gdsInfo is null for service={}. Nothing to save in cache", (Object)RangerGdsEnricher.this.getServiceName());
            }
            LOG.debug("<== RangerGdsInfoRefresher(serviceName={}).saveToCache()", (Object)RangerGdsEnricher.this.getServiceName());
        }

        private void stopRefresher() {
            Timer downloadTimer = this.downloadTimer;
            this.downloadTimer = null;
            this.downloadQueue = null;
            if (downloadTimer != null) {
                downloadTimer.cancel();
            }
            if (super.isAlive()) {
                super.interrupt();
                boolean setInterrupted = false;
                boolean isJoined = false;
                while (!isJoined) {
                    try {
                        super.join();
                        isJoined = true;
                        LOG.debug("RangerGdsInfoRefresher({}) is stopped", (Object)this.getName());
                    }
                    catch (InterruptedException excp) {
                        LOG.warn("RangerGdsInfoRefresher({}).stopRefresher(): Error while waiting for thread to exit", (Object)this.getName(), (Object)excp);
                        LOG.warn("Retrying Thread.join(). Current thread will be marked as 'interrupted' after Thread.join() returns");
                        setInterrupted = true;
                    }
                }
                if (setInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void populateGdsInfo() throws Exception {
            ServiceGdsInfo gdsInfo = this.retriever.retrieveGdsInfo(this.lastKnownVersion != null ? this.lastKnownVersion : -1L, this.lastActivationTimeInMillis);
            if (gdsInfo == null && !this.gdsInfoSetInPlugin) {
                gdsInfo = this.loadFromCache();
            }
            if (gdsInfo != null) {
                RangerGdsEnricher.this.setGdsInfo(gdsInfo);
                this.saveToCache(gdsInfo);
                this.gdsInfoSetInPlugin = true;
                this.lastKnownVersion = gdsInfo.getGdsVersion();
                this.lastActivationTimeInMillis = System.currentTimeMillis();
            }
        }
    }
}

