/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.nio.channels.ClosedByInterruptException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.contextenricher.RangerGdsInfoRetriever;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAdminGdsInfoRetriever
extends RangerGdsInfoRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAdminGdsInfoRetriever.class);
    private static final String OPTION_DEDUP_TAGS = "deDupTags";
    private static final Boolean OPTION_DEDUP_TAGS_DEFAULT = true;
    private RangerAdminClient adminClient;
    private boolean deDupTags;

    @Override
    public void init(Map<String, String> options) {
        try {
            if (StringUtils.isNotBlank((String)this.serviceName) && this.serviceDef != null && StringUtils.isNotBlank((String)this.appId)) {
                RangerPluginConfig pluginConfig = this.pluginConfig;
                if (pluginConfig == null) {
                    pluginConfig = new RangerPluginConfig(this.serviceDef.getName(), this.serviceName, this.appId, null, null, null);
                }
                String deDupTagsVal = options != null ? options.get(OPTION_DEDUP_TAGS) : null;
                RangerPluginContext pluginContext = this.getPluginContext();
                RangerAdminClient rangerAdmin = pluginContext.getAdminClient();
                this.deDupTags = StringUtils.isNotBlank((String)deDupTagsVal) ? Boolean.parseBoolean(deDupTagsVal) : OPTION_DEDUP_TAGS_DEFAULT;
                this.adminClient = rangerAdmin != null ? rangerAdmin : pluginContext.createAdminClient(pluginConfig);
            } else {
                LOG.error("FATAL: Cannot find service/serviceDef to use for retrieving tags. Will NOT be able to retrieve GdsInfo.");
            }
        }
        catch (Exception excp) {
            LOG.error("FATAL: Failed to initialize GDS retriever. Will not be able to enforce GDS policies", (Throwable)excp);
        }
    }

    @Override
    public ServiceGdsInfo retrieveGdsInfo(long lastKnownVersion, long lastActivationTimeInMillis) throws InterruptedException {
        ServiceGdsInfo ret = null;
        if (this.adminClient != null) {
            try {
                ret = this.adminClient.getGdsInfoIfUpdated(lastKnownVersion, lastActivationTimeInMillis);
            }
            catch (ClosedByInterruptException excp) {
                LOG.error("gdsInfo retriever thread was interrupted while blocked on I/O", (Throwable)excp);
                throw new InterruptedException();
            }
            catch (Exception e) {
                LOG.error("gdsInfo retriever encountered exception. Returning null gdsInfo", (Throwable)e);
            }
        }
        if (ret != null && this.deDupTags) {
            ret.dedupStrings();
        }
        return ret;
    }
}

