/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerTimeOfDayMatcher
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerTimeOfDayMatcher.class);
    static final Pattern PATTERN = Pattern.compile(" *(\\d{1,2})(:(\\d{1,2}))? *([aApP])\\.?[mM]\\.? *- *(\\d{1,2})(:(\\d{1,2}))? *([aApP])\\.?[mM]\\.? *");
    boolean allowAny;
    final List<int[]> durations = new ArrayList<int[]>();

    @Override
    public void init() {
        LOG.debug("==> RangerTimeOfDayMatcher.init({})", (Object)this.condition);
        super.init();
        if (this.condition == null) {
            LOG.debug("init: null policy condition! Will match always!");
            this.allowAny = true;
        } else if (CollectionUtils.isEmpty(this.condition.getValues())) {
            LOG.debug("init: empty conditions collection on policy condition!  Will match always!");
            this.allowAny = true;
        } else {
            for (String value : this.condition.getValues()) {
                if (StringUtils.isEmpty((String)value)) {
                    LOG.warn("init: Unexpected: one of the value in condition is null or empty!");
                    continue;
                }
                int[] aDuration = this.extractDuration(value);
                if (aDuration == null) continue;
                this.durations.add(aDuration);
            }
        }
        if (this.durations.isEmpty()) {
            LOG.debug("No valid durations found.  Will always match!");
            this.allowAny = true;
        }
        LOG.debug("<== RangerTimeOfDayMatcher.init({}): durations[{}]", (Object)this.condition, (Object)this);
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        LOG.debug("==> RangerTimeOfDayMatcher.isMatched({})", (Object)request);
        boolean matched = true;
        if (this.allowAny) {
            LOG.debug("isMatched: allowAny flag is true.  Matched!");
        } else if (request == null) {
            LOG.warn("isMatched: Unexpected: Request is null!  Implicitly matched!");
        } else if (request.getAccessTime() == null) {
            LOG.warn("isMatched: Unexpected: Accesstime on the request is null!  Implicitly matched!");
        } else {
            Date date = request.getAccessTime();
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(date);
            int hourOfDay = calendar.get(11);
            int minutes = calendar.get(12);
            if (!this.durationMatched(this.durations, hourOfDay, minutes)) {
                matched = false;
                LOG.debug("isMatched: None of the durations contains this hour of day[{}] and minutes[{}]", (Object)hourOfDay, (Object)minutes);
            }
        }
        LOG.debug("<== RangerTimeOfDayMatcher.isMatched({})): {}", (Object)request, (Object)matched);
        return matched;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RangerTimeOfDayMatcher {");
        sb.append("allowAny=").append(this.allowAny).append(" ");
        sb.append("durations=[");
        for (int[] duration : this.durations) {
            sb.append("{start=").append(duration[0]).append("; end=").append(duration[1]).append("} ");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    int[] extractDuration(String value) {
        LOG.debug("==> RangerTimeOfDayMatcher.extractDuration({})", (Object)value);
        int[] result = null;
        if (value == null) {
            LOG.warn("extractDuration: null input value!");
        } else {
            Matcher m = PATTERN.matcher(value);
            if (!m.matches()) {
                LOG.warn("extractDuration: input[{}] did not match pattern!", (Object)value);
            } else {
                int startHour = Integer.parseInt(m.group(1));
                int startMin = 0;
                if (m.group(3) != null) {
                    startMin = Integer.parseInt(m.group(3));
                }
                String startType = m.group(4).toUpperCase();
                int endHour = Integer.parseInt(m.group(5));
                int endMinute = 0;
                if (m.group(7) != null) {
                    endMinute = Integer.parseInt(m.group(7));
                }
                String endType = m.group(8).toUpperCase();
                if (startHour == 12) {
                    if ("A".equals(startType)) {
                        startHour = 0;
                    }
                } else if ("P".equals(startType)) {
                    startHour += 12;
                }
                if (endHour == 12) {
                    if ("A".equals(endType)) {
                        endHour = 0;
                    }
                } else if ("P".equals(endType)) {
                    endHour += 12;
                }
                result = new int[]{startHour * 60 + startMin, endHour * 60 + endMinute};
            }
        }
        LOG.debug("<== RangerTimeOfDayMatcher.extractDuration({}): duration:{}", (Object)value, (Object)Arrays.toString(result));
        return result;
    }

    boolean durationMatched(List<int[]> durations, int hourOfDay, int minutes) {
        for (int[] aDuration : durations) {
            int start = aDuration[0];
            int end = aDuration[1];
            int minutesOfDay = hourOfDay * 60 + minutes;
            if (!(start < end ? start <= minutesOfDay && minutesOfDay <= end : start <= minutesOfDay || minutesOfDay <= end)) continue;
            return true;
        }
        return false;
    }
}

