/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerRequestedResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHiveResourcesNotAccessedTogetherCondition
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHiveResourcesNotAccessedTogetherCondition.class);
    private final List<RangerPolicyResourceMatcher> matchers = new ArrayList<RangerPolicyResourceMatcher>();
    private boolean isInitialized;

    @Override
    public void init() {
        LOG.debug("==> RangerHiveResourcesNotAccessedTogetherCondition.init({})", (Object)this.condition);
        super.init();
        if (this.serviceDef != null) {
            this.doInitialize();
        } else {
            LOG.error("RangerHiveResourcesNotAccessedTogetherCondition.init() - ServiceDef not set ... ERROR ..");
        }
        LOG.debug("<== RangerHiveResourcesNotAccessedTogetherCondition.init({})", (Object)this.condition);
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        boolean ret = true;
        LOG.debug("==> RangerHiveResourcesNotAccessedTogetherCondition.isMatched({})", (Object)request);
        if (this.isInitialized && CollectionUtils.isNotEmpty(this.matchers)) {
            RangerRequestedResources resources = RangerAccessRequestUtil.getRequestedResourcesFromContext(request.getContext());
            ret = resources == null || resources.isMutuallyExcluded(this.matchers, request.getContext());
        } else {
            LOG.error("RangerHiveResourcesNotAccessedTogetherCondition.isMatched() - Enforcer is not initialized correctly, Mutual Exclusion will NOT be enforced");
        }
        LOG.debug("<== RangerHiveResourcesNotAccessedTogetherCondition.isMatched({}), result={}", (Object)request, (Object)ret);
        return ret;
    }

    private void doInitialize() {
        List<String> mutuallyExclusiveResources = this.condition.getValues();
        if (CollectionUtils.isNotEmpty(mutuallyExclusiveResources)) {
            this.initializeMatchers(mutuallyExclusiveResources);
            if (CollectionUtils.isEmpty(this.matchers)) {
                LOG.debug("RangerHiveResourcesNotAccessedTogetherCondition.doInitialize() - Cannot create matchers from values in MutualExclustionEnforcer");
            } else {
                LOG.debug("RangerHiveResourcesNotAccessedTogetherCondition.doInitialize() - Created {} matchers from values in MutualExclustionEnforcer", (Object)this.matchers.size());
            }
        } else {
            LOG.debug("RangerHiveResourcesNotAccessedTogetherCondition.doInitialize() - No values in MutualExclustionEnforcer");
        }
        this.isInitialized = true;
    }

    private void initializeMatchers(List<String> mutuallyExclusiveResources) {
        for (String s : mutuallyExclusiveResources) {
            String policyResourceSpec = s.trim();
            RangerPolicyResourceMatcher matcher = this.buildMatcher(policyResourceSpec);
            if (matcher == null) continue;
            this.matchers.add(matcher);
        }
    }

    private RangerPolicyResourceMatcher buildMatcher(String policyResourceSpec) {
        RangerDefaultPolicyResourceMatcher matcher = null;
        LOG.debug("==> RangerHiveResourcesNotAccessedTogetherCondition.buildMatcher({})", (Object)policyResourceSpec);
        if (this.serviceDef != null && "hive".equals(this.serviceDef.getName())) {
            char separator = '.';
            String any = "*";
            HashMap<String, RangerPolicy.RangerPolicyResource> policyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
            String[] elements = StringUtils.split((String)policyResourceSpec, (char)separator);
            if (elements.length > 0 && elements.length < 4) {
                RangerPolicy.RangerPolicyResource policyResource = elements.length == 3 ? new RangerPolicy.RangerPolicyResource(elements[2]) : new RangerPolicy.RangerPolicyResource(any);
                policyResources.put("column", policyResource);
                policyResource = elements.length >= 2 ? new RangerPolicy.RangerPolicyResource(elements[1]) : new RangerPolicy.RangerPolicyResource(any);
                policyResources.put("table", policyResource);
                policyResource = new RangerPolicy.RangerPolicyResource(elements[0]);
                policyResources.put("database", policyResource);
                matcher = new RangerDefaultPolicyResourceMatcher();
                matcher.setPolicyResources(policyResources);
                matcher.setServiceDef(this.serviceDef);
                matcher.init();
            } else {
                LOG.error("RangerHiveResourcesNotAccessedTogetherCondition.buildMatcher() - Incorrect elements in the hierarchy specified ({})", (Object)elements.length);
            }
        } else {
            LOG.error("RangerHiveResourcesNotAccessedTogetherCondition.buildMatcher() - ServiceDef not set or ServiceDef is not for Hive");
        }
        LOG.debug("<== RangerHiveResourcesNotAccessedTogetherCondition.buildMatcher({}), matcher={}", (Object)policyResourceSpec, matcher);
        return matcher;
    }
}

