/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.HashSet;
import java.util.Set;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAnyOfExpectedTagsPresentConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAnyOfExpectedTagsPresentConditionEvaluator.class);
    private final Set<String> policyConditionTags = new HashSet<String>();

    @Override
    public void init() {
        LOG.debug("==> RangerAnyOfExpectedTagsPresentConditionEvaluator.init({})", (Object)this.condition);
        super.init();
        if (this.condition != null) {
            for (String value : this.condition.getValues()) {
                this.policyConditionTags.add(value.trim());
            }
        }
        LOG.debug("<== RangerAnyOfExpectedTagsPresentConditionEvaluator.init({}): Tags[{}]", (Object)this.condition, this.policyConditionTags);
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        LOG.debug("==> RangerAnyOfExpectedTagsPresentConditionEvaluator.isMatched({})", (Object)request);
        boolean matched = false;
        Set<RangerTagForEval> resourceTags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        if (resourceTags != null) {
            for (RangerTagForEval tag : resourceTags) {
                if (!this.policyConditionTags.contains(tag.getType())) continue;
                matched = true;
                break;
            }
        }
        LOG.debug("<== RangerAnyOfExpectedTagsPresentConditionEvaluator.isMatched({}): {}", (Object)request, (Object)matched);
        return matched;
    }
}

