/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerChainedPluginConfig
extends RangerPluginConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RangerChainedPluginConfig.class);
    private final String[] legacySSLProperties = new String[]{"xasecure.policymgr.clientssl.keystore", "xasecure.policymgr.clientssl.keystore.type", "xasecure.policymgr.clientssl.keystore.credential.file", "xasecure.policymgr.clientssl.truststore", "xasecure.policymgr.clientssl.truststore.credential.file", "hadoop.security.credential.provider.path"};
    private final String[] chainedPluginPropertyPrefixes = new String[]{".chained.services"};

    public RangerChainedPluginConfig(String serviceType, String serviceName, String appId, RangerPluginConfig sourcePluginConfig) {
        super(serviceType, serviceName, appId, sourcePluginConfig);
        this.copyProperties(sourcePluginConfig, sourcePluginConfig.getPropertyPrefix());
        this.copyLegacySSLProperties(sourcePluginConfig);
        this.copyProperties(sourcePluginConfig, this.getPropertyPrefix());
        this.copyChainedProperties(sourcePluginConfig, this.getPropertyPrefix());
        this.set(this.getPropertyPrefix() + ".service.name", serviceName);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " : { " + this.printProperties() + " }";
    }

    private void copyProperties(RangerPluginConfig sourcePluginConfig, String propertyPrefix) {
        LOG.debug("==> copyProperties: propertyPrefix:[{}]", (Object)propertyPrefix);
        for (String propName : sourcePluginConfig.getProperties().stringPropertyNames()) {
            String value = sourcePluginConfig.get(propName);
            if (value == null || !propName.startsWith(propertyPrefix)) continue;
            String suffix = propName.substring(propertyPrefix.length());
            if (!this.isExcludedSuffix(suffix)) {
                this.set(this.getPropertyPrefix() + suffix, value);
                LOG.debug("set property:[{}{}] to value:[{}]", new Object[]{this.getPropertyPrefix(), suffix, value});
                continue;
            }
            LOG.debug("Not copying property :[{}] value from sourcePluginConfig", (Object)propName);
        }
        LOG.debug("<== copyProperties: propertyPrefix:[{}]", (Object)propertyPrefix);
    }

    private void copyLegacySSLProperties(RangerPluginConfig sourcePluginConfig) {
        for (String legacyPropertyName : this.legacySSLProperties) {
            String value = sourcePluginConfig.get(legacyPropertyName);
            if (value == null) continue;
            this.set(legacyPropertyName, value);
        }
    }

    private void copyChainedProperties(RangerPluginConfig sourcePluginConfig, String propertyPrefix) {
        for (String propName : sourcePluginConfig.getProperties().stringPropertyNames()) {
            String value = sourcePluginConfig.get(propName);
            if (value == null || !propName.startsWith(propertyPrefix)) continue;
            String suffix = propName.substring(propertyPrefix.length());
            for (String chainedPropertyPrefix : this.chainedPluginPropertyPrefixes) {
                if (!StringUtils.startsWith((String)suffix, (String)chainedPropertyPrefix)) continue;
                this.set(this.getPropertyPrefix() + suffix, value);
            }
        }
    }

    private boolean isExcludedSuffix(String suffix) {
        for (String excludedSuffix : this.chainedPluginPropertyPrefixes) {
            if (!StringUtils.startsWith((String)suffix, (String)excludedSuffix)) continue;
            return true;
        }
        return false;
    }

    private String printProperties() {
        StringBuilder sb = new StringBuilder();
        boolean seenOneProp = false;
        for (String propName : this.getProperties().stringPropertyNames()) {
            String value = this.get(propName);
            if (!seenOneProp) {
                seenOneProp = true;
            } else {
                sb.append(",\n");
            }
            sb.append("{ propertyName:[").append(propName).append("], propertyValue:[").append(value).append("] }");
        }
        return sb.toString();
    }
}

