/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuditConfig
extends RangerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuditConfig.class);
    private final boolean initSuccess;

    public RangerAuditConfig() {
        this("standalone");
    }

    public RangerAuditConfig(String serviceName) {
        this.initSuccess = this.addAuditResources(serviceName);
    }

    public boolean isInitSuccess() {
        return this.initSuccess;
    }

    private boolean addAuditResources(String serviceName) {
        LOG.debug("==> addAuditResources()");
        String defaultCfg = "ranger-" + serviceName + "-audit.xml";
        boolean ret = true;
        if (!this.addResourceIfReadable(defaultCfg)) {
            LOG.error("Could not add {} to RangerAuditConfig.", (Object)defaultCfg);
            ret = false;
        }
        LOG.debug("<== addAuditResources(), result={}", (Object)ret);
        return ret;
    }
}

