/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServiceGdsInfo;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;

public class LocalFolderPolicySource
extends AbstractRangerAdminClient {
    private ServicePolicies policies;
    private RangerRoles roles;
    private RangerUserStore userStore;
    private ServiceTags tags;
    private ServiceGdsInfo gdsInfo;
    private String policiesPath;
    private String rolesPath;
    private String userStorePath;
    private String tagsPath;
    private String gdsInfoPath;
    private long lastPoliciesFileModifiedTime = -1L;
    private long lastRolesFileModifiedTime = -1L;
    private long lastUserStoreFileModifiedTime = -1L;
    private long lastTagsFileModifiedTime = -1L;
    private long lastGdsInfoFileModifiedTime = -1L;

    @Override
    public void init(String serviceName, String appId, String configPropertyPrefix, Configuration config) {
        super.init(serviceName, appId, configPropertyPrefix, config);
        String directory = config.get(configPropertyPrefix + ".policy.source.local_folder.path");
        String pathPrefix = (directory == null ? "" : directory) + File.separator + appId + "_" + serviceName;
        this.policiesPath = pathPrefix + ".json";
        this.rolesPath = pathPrefix + "_roles.json";
        this.userStorePath = pathPrefix + "_userstore.json";
        this.tagsPath = pathPrefix + "_tag.json";
        this.gdsInfoPath = pathPrefix + "_gds.json";
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadPolicies();
        return lastKnownVersion == -1L || this.policies == null || this.policies.getPolicyVersion() == null || !this.policies.getPolicyVersion().equals(lastKnownVersion) ? this.policies : null;
    }

    @Override
    public RangerRoles getRolesIfUpdated(long lastKnownVersion, long lastActivationTimeInMills) throws Exception {
        this.loadRoles();
        return lastKnownVersion == -1L || this.roles == null || this.roles.getRoleVersion() == null || !this.roles.getRoleVersion().equals(lastKnownVersion) ? this.roles : null;
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadTags();
        return lastKnownVersion == -1L || this.tags == null || this.tags.getTagVersion() == null || !this.tags.getTagVersion().equals(lastKnownVersion) ? this.tags : null;
    }

    @Override
    public RangerUserStore getUserStoreIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadUserStore();
        return lastKnownVersion == -1L || this.userStore == null || this.userStore.getUserStoreVersion() == null || !this.userStore.getUserStoreVersion().equals(lastKnownVersion) ? this.userStore : null;
    }

    @Override
    public ServiceGdsInfo getGdsInfoIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        this.loadGdsInfo();
        return lastKnownVersion == -1L || this.gdsInfo == null || this.gdsInfo.getGdsVersion() == null || !this.gdsInfo.getGdsVersion().equals(lastKnownVersion) ? this.gdsInfo : null;
    }

    private void loadPolicies() throws Exception {
        File srcFile = new File(this.policiesPath);
        if (!srcFile.exists() || !srcFile.canRead()) {
            throw new Exception(this.policiesPath + ": policies file not found or not readable");
        }
        if (this.policies == null || srcFile.lastModified() != this.lastPoliciesFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.policies = (ServicePolicies)this.gson.fromJson((Reader)reader, ServicePolicies.class);
                this.lastPoliciesFileModifiedTime = srcFile.lastModified();
            }
        }
    }

    private void loadRoles() throws Exception {
        File srcFile = new File(this.rolesPath);
        if (!srcFile.exists() || !srcFile.canRead()) {
            throw new Exception(this.rolesPath + ": roles file not found or not readable");
        }
        if (this.roles == null || srcFile.lastModified() != this.lastRolesFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.roles = (RangerRoles)this.gson.fromJson((Reader)reader, RangerRoles.class);
                this.lastRolesFileModifiedTime = srcFile.lastModified();
            }
        }
    }

    private void loadTags() throws Exception {
        File srcFile = new File(this.tagsPath);
        if (!srcFile.exists() || !srcFile.canRead()) {
            throw new Exception(this.tagsPath + ": tags file not found or not readable");
        }
        if (this.tags == null || srcFile.lastModified() != this.lastTagsFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.tags = (ServiceTags)this.gson.fromJson((Reader)reader, ServiceTags.class);
                this.lastTagsFileModifiedTime = srcFile.lastModified();
            }
        }
    }

    private void loadUserStore() throws Exception {
        File srcFile = new File(this.userStorePath);
        if (!srcFile.exists() || !srcFile.canRead()) {
            throw new Exception(this.userStorePath + ": userStore file not found or not readable");
        }
        if (this.userStore == null || srcFile.lastModified() != this.lastUserStoreFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.userStore = (RangerUserStore)this.gson.fromJson((Reader)reader, RangerUserStore.class);
                this.lastUserStoreFileModifiedTime = srcFile.lastModified();
            }
        }
    }

    private void loadGdsInfo() throws Exception {
        File srcFile = new File(this.gdsInfoPath);
        if (!srcFile.exists() || !srcFile.canRead()) {
            throw new Exception(this.gdsInfoPath + ": gdsInfo file not found or not readable");
        }
        if (this.gdsInfo == null || srcFile.lastModified() != this.lastGdsInfoFileModifiedTime) {
            try (FileReader reader = new FileReader(srcFile);){
                this.gdsInfo = JsonUtilsV2.readValue(reader, ServiceGdsInfo.class);
                this.lastGdsInfoFileModifiedTime = srcFile.lastModified();
            }
        }
    }
}

