/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.security.KrbPasswordSaverLoginModule;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.ranger.authorization.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureClientLogin {
    private static final Logger LOG = LoggerFactory.getLogger(SecureClientLogin.class);
    public static final String HOSTNAME_PATTERN = "_HOST";

    private SecureClientLogin() {
    }

    public static synchronized Subject loginUserFromKeytab(String user, String path) throws IOException {
        try {
            Subject subject = new Subject();
            SecureClientLoginConfiguration loginConf = new SecureClientLoginConfiguration(true, user, path);
            LoginContext login = new LoginContext("hadoop-keytab-kerberos", subject, null, loginConf);
            subject.getPrincipals().add((Principal)new User(user, UserGroupInformation.AuthenticationMethod.KERBEROS, login));
            login.login();
            return login.getSubject();
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
    }

    public static synchronized Subject loginUserFromKeytab(String user, String path, String nameRules) throws IOException {
        try {
            Subject subject = new Subject();
            SecureClientLoginConfiguration loginConf = new SecureClientLoginConfiguration(true, user, path);
            LoginContext login = new LoginContext("hadoop-keytab-kerberos", subject, null, loginConf);
            KerberosName.setRules((String)nameRules);
            subject.getPrincipals().add((Principal)new User(user, UserGroupInformation.AuthenticationMethod.KERBEROS, login));
            login.login();
            return login.getSubject();
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
    }

    public static synchronized Subject loginUserWithPassword(String user, String password) throws IOException {
        try {
            Subject subject = new Subject();
            SecureClientLoginConfiguration loginConf = new SecureClientLoginConfiguration(false, user, password);
            LoginContext login = new LoginContext("hadoop-keytab-kerberos", subject, null, loginConf);
            subject.getPrincipals().add((Principal)new User(user, UserGroupInformation.AuthenticationMethod.KERBEROS, login));
            login.login();
            return login.getSubject();
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + user + " using password ****", le);
        }
    }

    public static synchronized Subject login(String user) throws IOException {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new User(user));
        return subject;
    }

    public static Set<Principal> getUserPrincipals(Subject aSubject) {
        if (aSubject != null) {
            Set<User> list = aSubject.getPrincipals(User.class);
            return list != null ? new HashSet<User>(list) : null;
        }
        return null;
    }

    public static Principal createUserPrincipal(String aLoginName) {
        return new User(aLoginName);
    }

    public static boolean isKerberosCredentialExists(String principal, String keytabPath) {
        boolean isValid = false;
        if (keytabPath != null && !keytabPath.isEmpty()) {
            File keytabFile = new File(keytabPath);
            if (!keytabFile.exists()) {
                LOG.warn("{} doesn't exist.", (Object)keytabPath);
            } else if (!keytabFile.canRead()) {
                LOG.warn("Unable to read {}. Please check the file access permissions for user", (Object)keytabPath);
            } else {
                isValid = true;
            }
        } else {
            LOG.warn("Can't find keyTab Path : {}", (Object)keytabPath);
        }
        if (principal == null || principal.isEmpty() || !isValid) {
            isValid = false;
            LOG.warn("Can't find principal : {}", (Object)principal);
        }
        return isValid;
    }

    public static String getPrincipal(String principalConfig, String hostName) throws IOException {
        String[] components = SecureClientLogin.getComponents(principalConfig);
        if (components == null || components.length != 3 || !HOSTNAME_PATTERN.equals(components[1])) {
            return principalConfig;
        }
        if (hostName == null) {
            throw new IOException("Can't replace _HOST pattern since client ranger.service.host is null");
        }
        return SecureClientLogin.replacePattern(components, hostName);
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/@]");
    }

    private static String replacePattern(String[] components, String hostname) throws IOException {
        String fqdn = hostname;
        if (StringUtil.isEmpty(fqdn) || "0.0.0.0".equals(fqdn)) {
            fqdn = InetAddress.getLocalHost().getCanonicalHostName();
        }
        return components[0] + "/" + StringUtils.toLowerCase((String)fqdn) + "@" + components[2];
    }

    static class SecureClientLoginConfiguration
    extends Configuration {
        private final Map<String, String> kerberosOptions = new HashMap<String, String>();
        private boolean usePassword;

        public SecureClientLoginConfiguration(boolean useKeyTab, String principal, String credential) {
            this.kerberosOptions.put("principal", principal);
            this.kerberosOptions.put("debug", "false");
            if (useKeyTab) {
                this.kerberosOptions.put("useKeyTab", "true");
                this.kerberosOptions.put("keyTab", credential);
                this.kerberosOptions.put("doNotPrompt", "true");
            } else {
                this.usePassword = true;
                this.kerberosOptions.put("useKeyTab", "false");
                this.kerberosOptions.put("javax.security.auth.login.name", principal);
                this.kerberosOptions.put("javax.security.auth.login.password", credential);
                this.kerberosOptions.put("doNotPrompt", "false");
                this.kerberosOptions.put("useFirstPass", "true");
                this.kerberosOptions.put("tryFirstPass", "false");
            }
            this.kerberosOptions.put("storeKey", "true");
            this.kerberosOptions.put("refreshKrb5Config", "true");
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            AppConfigurationEntry keytabKerberosLogin = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.kerberosOptions);
            if (this.usePassword) {
                AppConfigurationEntry kerberosPwdSaver = new AppConfigurationEntry(KrbPasswordSaverLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.kerberosOptions);
                return new AppConfigurationEntry[]{kerberosPwdSaver, keytabKerberosLogin};
            }
            return new AppConfigurationEntry[]{keytabKerberosLogin};
        }
    }
}

