/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerAdminConfig;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceTagsDeltaUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceTagsDeltaUtil.class);
    private static final Logger PERF_TAGS_DELTA_LOG = RangerPerfTracer.getPerfLogger("tags.delta");
    private static boolean SUPPORTS_TAGS_DEDUP_INITIALIZED = false;
    private static boolean SUPPORTS_TAGS_DEDUP = false;

    public static ServiceTags applyDelta(ServiceTags serviceTags, ServiceTags delta) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceTagsDeltaUtil.applyDelta()");
        }
        ServiceTags ret = serviceTags;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TAGS_DELTA_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TAGS_DELTA_LOG, "RangerServiceTagsDeltaUtil.applyDelta()");
        }
        if (serviceTags != null && !serviceTags.getIsDelta().booleanValue() && delta != null && delta.getIsDelta().booleanValue()) {
            ret = new ServiceTags(serviceTags);
            ret.setServiceName(delta.getServiceName());
            ret.setTagVersion(delta.getTagVersion());
            int tagDefsAdded = 0;
            int tagDefsUpdated = 0;
            int tagDefsRemoved = 0;
            int tagsAdded = 0;
            int tagsUpdated = 0;
            int tagsRemoved = 0;
            Map<Long, RangerTagDef> tagDefs = ret.getTagDefinitions();
            for (Map.Entry<Long, RangerTagDef> entry : delta.getTagDefinitions().entrySet()) {
                RangerTagDef existing;
                RangerTagDef removedTagDef;
                Long deltaTagDefId = entry.getKey();
                RangerTagDef deltaTagDef = entry.getValue();
                if (StringUtils.isEmpty((String)deltaTagDef.getName()) && (removedTagDef = tagDefs.remove(deltaTagDefId)) != null) {
                    ++tagDefsRemoved;
                }
                if ((existing = tagDefs.put(deltaTagDefId, deltaTagDef)) == null) {
                    ++tagDefsAdded;
                    continue;
                }
                if (existing.equals(deltaTagDef)) continue;
                ++tagDefsUpdated;
            }
            Map<Long, RangerTag> tags = ret.getTags();
            HashMap<Long, Long> replacedTagIds = new HashMap<Long, Long>();
            Iterator<Map.Entry<Long, RangerTag>> deltaTagIter = delta.getTags().entrySet().iterator();
            while (deltaTagIter.hasNext()) {
                Map.Entry<Long, RangerTag> entry = deltaTagIter.next();
                Long deltaTagId = entry.getKey();
                RangerTag deltaTag = entry.getValue();
                if (StringUtils.isEmpty((String)deltaTag.getType())) {
                    RangerTag removedTag = tags.remove(deltaTagId);
                    if (removedTag == null) continue;
                    ++tagsRemoved;
                    if (!RangerServiceTagsDeltaUtil.isSupportsTagsDedup()) continue;
                    ret.cachedTags.remove(removedTag);
                    continue;
                }
                if (RangerServiceTagsDeltaUtil.isSupportsTagsDedup()) {
                    Long cachedTagId = ret.cachedTags.get(deltaTag);
                    if (cachedTagId == null) {
                        ret.cachedTags.put(deltaTag, deltaTagId);
                        tags.put(deltaTagId, deltaTag);
                        continue;
                    }
                    replacedTagIds.put(deltaTagId, cachedTagId);
                    deltaTagIter.remove();
                    continue;
                }
                RangerTag existing = tags.put(deltaTagId, deltaTag);
                if (existing == null) {
                    ++tagsAdded;
                    continue;
                }
                if (existing.equals(deltaTag)) continue;
                ++tagsUpdated;
            }
            List<RangerServiceResource> serviceResources = ret.getServiceResources();
            Map<Long, List<Long>> resourceToTagIds = ret.getResourceToTagIds();
            Map idResourceMap = serviceResources.stream().collect(Collectors.toMap(RangerBaseModelObject::getId, Function.identity()));
            HashMap<Long, RangerServiceResource> resourcesToRemove = new HashMap<Long, RangerServiceResource>();
            HashMap<Long, RangerServiceResource> resourcesToAdd = new HashMap<Long, RangerServiceResource>();
            for (RangerServiceResource rangerServiceResource : delta.getServiceResources()) {
                RangerServiceResource existingResource = (RangerServiceResource)idResourceMap.get(rangerServiceResource.getId());
                if (existingResource != null) {
                    boolean isAddedResource;
                    if (StringUtils.isNotEmpty((String)rangerServiceResource.getResourceSignature())) {
                        if (StringUtils.equals((String)rangerServiceResource.getResourceSignature(), (String)existingResource.getResourceSignature())) continue;
                        existingResource.setResourceSignature(null);
                        boolean bl = isAddedResource = resourcesToAdd.remove(existingResource.getId()) == existingResource;
                        if (!isAddedResource && !resourcesToRemove.containsKey(existingResource.getId())) {
                            resourcesToRemove.put(existingResource.getId(), existingResource);
                        }
                        resourcesToAdd.put(rangerServiceResource.getId(), rangerServiceResource);
                        idResourceMap.put(rangerServiceResource.getId(), rangerServiceResource);
                        continue;
                    }
                    boolean bl = isAddedResource = resourcesToAdd.remove(existingResource.getId()) == existingResource;
                    if (!isAddedResource) {
                        resourcesToRemove.put(existingResource.getId(), existingResource);
                    }
                    idResourceMap.remove(existingResource.getId());
                    resourceToTagIds.remove(existingResource.getId());
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)rangerServiceResource.getResourceSignature())) continue;
                resourcesToAdd.put(rangerServiceResource.getId(), rangerServiceResource);
                idResourceMap.put(rangerServiceResource.getId(), rangerServiceResource);
            }
            if (!resourcesToRemove.isEmpty()) {
                Iterator<Object> iter = serviceResources.listIterator();
                while (iter.hasNext()) {
                    RangerServiceResource rangerServiceResource = iter.next();
                    RangerServiceResource replacedResource = (RangerServiceResource)resourcesToRemove.get(rangerServiceResource.getId());
                    if (replacedResource != rangerServiceResource) continue;
                    iter.remove();
                }
            }
            serviceResources.addAll(resourcesToAdd.values());
            if (!replacedTagIds.isEmpty()) {
                for (Map.Entry entry : delta.getResourceToTagIds().entrySet()) {
                    ListIterator<Long> listIter = ((List)entry.getValue()).listIterator();
                    while (listIter.hasNext()) {
                        Long tagId = (Long)listIter.next();
                        Long replacerTagId = (Long)replacedTagIds.get(tagId);
                        if (replacerTagId == null) continue;
                        listIter.set(replacerTagId);
                    }
                }
            }
            resourceToTagIds.putAll(delta.getResourceToTagIds());
            if (!resourcesToAdd.isEmpty()) {
                ArrayList<RangerServiceResource> deltaServiceResources = new ArrayList<RangerServiceResource>(resourcesToAdd.values());
                deltaServiceResources.addAll(delta.getServiceResources());
                delta.setServiceResources(deltaServiceResources);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerServiceTagsDeltaUtil.applyDelta(): delta(tagDefs={}, tags={}, resources={}), resources(total={}, added={}, removed={}), tags(total={}, added={}, updated={}, removed={}), tagDefs(total={}, added={}, updated={}, removed={})", new Object[]{delta.getTagDefinitions().size(), delta.getTags().size(), delta.getServiceResources().size(), serviceResources.size(), resourcesToAdd.size(), resourcesToRemove.size(), tags.size(), tagsAdded, tagsUpdated, tagsRemoved, tagDefs.size(), tagDefsAdded, tagDefsUpdated, tagDefsRemoved});
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Cannot apply deltas to service-tags as one of preconditions is violated. Returning received serviceTags without applying delta!!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceTagsDeltaUtil.applyDelta()");
        }
        RangerPerfTracer.log(perf);
        return ret;
    }

    public static void pruneUnusedAttributes(ServiceTags serviceTags) {
        if (serviceTags != null) {
            serviceTags.setTagUpdateTime(null);
            for (Map.Entry<Long, RangerTagDef> entry : serviceTags.getTagDefinitions().entrySet()) {
                RangerServiceTagsDeltaUtil.pruneUnusedAttributes(entry.getValue());
            }
            for (Map.Entry<Long, RangerBaseModelObject> entry : serviceTags.getTags().entrySet()) {
                RangerServiceTagsDeltaUtil.pruneUnusedAttributes((RangerTag)entry.getValue());
            }
            for (RangerServiceResource rangerServiceResource : serviceTags.getServiceResources()) {
                RangerServiceTagsDeltaUtil.pruneUnusedAttributes(rangerServiceResource);
            }
        }
    }

    public static void pruneUnusedAttributes(RangerTagDef tagDef) {
        tagDef.setCreatedBy(null);
        tagDef.setCreateTime(null);
        tagDef.setUpdatedBy(null);
        tagDef.setUpdateTime(null);
        tagDef.setGuid(null);
        tagDef.setVersion(null);
        if (tagDef.getAttributeDefs() != null && tagDef.getAttributeDefs().isEmpty()) {
            tagDef.setAttributeDefs(null);
        }
    }

    public static void pruneUnusedAttributes(RangerTag tag) {
        tag.setCreatedBy(null);
        tag.setCreateTime(null);
        tag.setUpdatedBy(null);
        tag.setUpdateTime(null);
        tag.setGuid(null);
        tag.setVersion(null);
        if (tag.getOwner() != null && tag.getOwner() == 0) {
            tag.setOwner(null);
        }
        if (tag.getAttributes() != null && tag.getAttributes().isEmpty()) {
            tag.setAttributes(null);
        }
        if (tag.getOptions() != null && tag.getOptions().isEmpty()) {
            tag.setOptions(null);
        }
        if (tag.getValidityPeriods() != null && tag.getValidityPeriods().isEmpty()) {
            tag.setValidityPeriods(null);
        }
    }

    public static void pruneUnusedAttributes(RangerServiceResource serviceResource) {
        serviceResource.setCreatedBy(null);
        serviceResource.setCreateTime(null);
        serviceResource.setUpdatedBy(null);
        serviceResource.setUpdateTime(null);
        serviceResource.setGuid(null);
        serviceResource.setVersion(null);
        if (serviceResource.getAdditionalInfo() != null && serviceResource.getAdditionalInfo().isEmpty()) {
            serviceResource.setAdditionalInfo(null);
        }
    }

    public static boolean isSupportsTagsDedup() {
        if (!SUPPORTS_TAGS_DEDUP_INITIALIZED) {
            RangerAdminConfig config = RangerAdminConfig.getInstance();
            SUPPORTS_TAGS_DEDUP = config.getBoolean("ranger.admin.supports.tags.dedup", false);
            SUPPORTS_TAGS_DEDUP_INITIALIZED = true;
        }
        return SUPPORTS_TAGS_DEDUP;
    }
}

