/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerRequestedResources {
    private List<RangerAccessResource> requestedResources = new ArrayList<RangerAccessResource>();

    public void addRequestedResource(RangerAccessResource requestedResource) {
        if (requestedResource != null) {
            boolean exists;
            if (CollectionUtils.isEmpty(this.requestedResources)) {
                this.requestedResources = new ArrayList<RangerAccessResource>();
            }
            if (!(exists = this.requestedResources.contains(requestedResource))) {
                this.requestedResources.add(requestedResource);
            }
        }
    }

    public boolean isMutuallyExcluded(List<RangerPolicyResourceMatcher> matchers, Map<String, Object> evalContext) {
        boolean ret = true;
        int matchedCount = 0;
        if (!CollectionUtils.isEmpty(matchers) && !CollectionUtils.isEmpty(this.requestedResources) && this.requestedResources.size() > 1) {
            block0: for (RangerAccessResource resource : this.requestedResources) {
                for (RangerPolicyResourceMatcher matcher : matchers) {
                    if (!matcher.isMatch(resource, evalContext) || matchedCount++ <= 0) continue;
                    ret = false;
                    continue block0;
                }
            }
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    StringBuilder toString(StringBuilder sb) {
        sb.append("AllRequestedHiveResources={");
        for (RangerAccessResource resource : this.requestedResources) {
            if (resource == null) continue;
            sb.append(resource.getAsString());
            sb.append("; ");
        }
        sb.append("} ");
        return sb;
    }
}

