/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfDataRecorder {
    private static final Logger LOG = LoggerFactory.getLogger(PerfDataRecorder.class);
    private static final Logger PERF = RangerPerfTracer.getPerfLogger(PerfDataRecorder.class);
    private static volatile PerfDataRecorder instance;
    private final Map<String, PerfStatistic> perfStatistics = Collections.synchronizedMap(new HashMap());
    private RangerReadWriteLock lock = null;

    public static void initialize(List<String> names) {
        PerfDataRecorder.initialize(true, 0, false, names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(boolean useRecorder, int collectionIntervalInSeconds, boolean usePerfDataLock, List<String> names) {
        if (!useRecorder || instance != null) return;
        Class<PerfDataRecorder> clazz = PerfDataRecorder.class;
        synchronized (PerfDataRecorder.class) {
            if (instance != null) return;
            instance = new PerfDataRecorder(names);
            PerfDataRecorder.instance.lock = new RangerReadWriteLock(usePerfDataLock);
            if (collectionIntervalInSeconds <= 0) return;
            StatisticsDumper statDumper = new StatisticsDumper(collectionIntervalInSeconds);
            statDumper.setName("Perf-Statistics-Dumper");
            statDumper.setDaemon(true);
            statDumper.start();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static boolean collectStatistics() {
        return instance != null;
    }

    public static void printStatistics() {
        if (instance != null) {
            instance.dumpStatistics();
        }
    }

    public static void clearStatistics() {
        if (instance != null) {
            try (RangerReadWriteLock.RangerLock writeLock = PerfDataRecorder.instance.lock.getWriteLock();){
                instance.clear();
            }
        }
    }

    public static void recordStatistic(String tag, long cpuTime, long elapsedTime) {
        if (instance != null) {
            instance.record(tag, cpuTime, elapsedTime);
        }
    }

    private void dumpStatistics() {
        ArrayList<String> tags;
        try (RangerReadWriteLock.RangerLock readLock = this.lock.getReadLock();){
            tags = new ArrayList<String>(this.perfStatistics.keySet());
        }
        Collections.sort(tags);
        for (String tag : tags) {
            PerfStatistic perfStatistic = this.perfStatistics.get(tag);
            long averageTimeSpentCpu = 0L;
            long averageTimeSpent = 0L;
            if (perfStatistic.numberOfInvocations.get() != 0L) {
                averageTimeSpentCpu = perfStatistic.microSecondsSpentCpu.get() / perfStatistic.numberOfInvocations.get();
            }
            if (perfStatistic.numberOfInvocations.get() != 0L) {
                averageTimeSpent = perfStatistic.microSecondsSpent.get() / perfStatistic.numberOfInvocations.get();
            }
            String logMsg = "[" + tag + "] execCount: " + perfStatistic.numberOfInvocations.get() + ", totalTimeTakenCpu: " + perfStatistic.microSecondsSpentCpu.get() + " \u03bcs, maxTimeTakenCpu: " + perfStatistic.maxTimeSpentCpu.get() + " \u03bcs, minTimeTakenCpu: " + perfStatistic.minTimeSpentCpu.get() + " \u03bcs, avgTimeTakenCpu: " + averageTimeSpentCpu + " \u03bcs, totalTimeTaken: " + perfStatistic.microSecondsSpent.get() + " \u03bcs, maxTimeTaken: " + perfStatistic.maxTimeSpent.get() + " \u03bcs, minTimeTaken: " + perfStatistic.minTimeSpent.get() + " \u03bcs, avgTimeTaken: " + averageTimeSpent + " \u03bcs";
            LOG.info(logMsg);
            PERF.debug(logMsg);
        }
    }

    private void clear() {
        this.perfStatistics.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void record(String tag, long cpuTime, long elapsedTime) {
        try (RangerReadWriteLock.RangerLock writeLock = this.lock.getWriteLock();){
            PerfStatistic perfStatistic = this.perfStatistics.get(tag);
            if (perfStatistic == null) {
                Class<PerfDataRecorder> clazz = PerfDataRecorder.class;
                // MONITORENTER : org.apache.ranger.plugin.util.PerfDataRecorder.class
                perfStatistic = this.perfStatistics.get(tag);
                if (perfStatistic == null) {
                    perfStatistic = new PerfStatistic();
                    this.perfStatistics.put(tag, perfStatistic);
                }
                // MONITOREXIT : clazz
            }
            perfStatistic.addPerfDataItem(cpuTime, elapsedTime);
            return;
        }
    }

    private PerfDataRecorder(List<String> names) {
        if (CollectionUtils.isNotEmpty(names)) {
            for (String name : names) {
                this.perfStatistics.put(name, new PerfStatistic());
            }
        }
    }

    public static Map<String, PerfStatistic> exposeStatistics() {
        if (instance != null) {
            return ImmutableMap.copyOf(PerfDataRecorder.instance.perfStatistics);
        }
        return ImmutableMap.of();
    }

    private static class StatisticsDumper
    extends Thread {
        final int collectionIntervalInSeconds;

        StatisticsDumper(int collectionIntervalInSeconds) {
            this.collectionIntervalInSeconds = collectionIntervalInSeconds;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    StatisticsDumper.sleep(this.collectionIntervalInSeconds * 1000);
                    PerfDataRecorder.printStatistics();
                    PerfDataRecorder.clearStatistics();
                }
            }
            catch (InterruptedException exception) {
                PerfDataRecorder.printStatistics();
                LOG.warn("Thread[" + this.getName() + "] was interrupted. Returning from thread. Performance statistics will NOT be dumped periodically!!");
                return;
            }
        }
    }

    public static class PerfStatistic {
        private AtomicLong numberOfInvocations = new AtomicLong(0L);
        private AtomicLong microSecondsSpentCpu = new AtomicLong(0L);
        private AtomicLong minTimeSpentCpu = new AtomicLong(Long.MAX_VALUE);
        private AtomicLong maxTimeSpentCpu = new AtomicLong(Long.MIN_VALUE);
        private AtomicLong microSecondsSpent = new AtomicLong(0L);
        private AtomicLong minTimeSpent = new AtomicLong(Long.MAX_VALUE);
        private AtomicLong maxTimeSpent = new AtomicLong(Long.MIN_VALUE);

        void addPerfDataItem(long cpuTime, long timeTaken) {
            long max;
            this.numberOfInvocations.getAndIncrement();
            this.microSecondsSpentCpu.getAndAdd(cpuTime);
            this.microSecondsSpent.getAndAdd(timeTaken);
            long min = this.minTimeSpentCpu.get();
            if (cpuTime < min) {
                this.minTimeSpentCpu.compareAndSet(min, cpuTime);
            }
            if (timeTaken < (min = this.minTimeSpent.get())) {
                this.minTimeSpent.compareAndSet(min, timeTaken);
            }
            if (cpuTime > (max = this.maxTimeSpentCpu.get())) {
                this.maxTimeSpentCpu.compareAndSet(max, cpuTime);
            }
            if (timeTaken > (max = this.maxTimeSpent.get())) {
                this.maxTimeSpent.compareAndSet(max, timeTaken);
            }
        }

        public long getNumberOfInvocations() {
            return this.numberOfInvocations.get();
        }

        public long getMicroSecondsSpentCpu() {
            return this.microSecondsSpentCpu.get();
        }

        public long getMinTimeSpentCpu() {
            return this.minTimeSpentCpu.get();
        }

        public long getMaxTimeSpentCpu() {
            return this.maxTimeSpentCpu.get();
        }

        public long getMicroSecondsSpent() {
            return this.microSecondsSpent.get();
        }

        public long getMinTimeSpent() {
            return this.minTimeSpent.get();
        }

        public long getMaxTimeSpent() {
            return this.maxTimeSpent.get();
        }
    }
}

