/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.token;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.plugin.token.TokenRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwTokenRetrieverFile
implements TokenRetriever<String> {
    private static final Logger LOG = LoggerFactory.getLogger(JwTokenRetrieverFile.class);
    private static final String RANGER_PROP_JWT_FILENAME = "ranger.auth.jwt.file.name";
    private File jwtFile = null;
    private Optional<String> cachedJWT = Optional.empty();
    private Long lastModified = -1L;

    public JwTokenRetrieverFile(Configuration config) {
        this.init(config);
    }

    private void init(Configuration config) {
        String fileName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> JwTokenRetrieverFile.init()");
        }
        if (StringUtils.isNotBlank((String)(fileName = config.get(RANGER_PROP_JWT_FILENAME, "")))) {
            this.jwtFile = new File(fileName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== JwTokenRetrieverFile.init(): fileName=" + fileName);
        }
    }

    @Override
    public Optional<String> retrieve() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> JwTokenRetrieverFile.retrieve()");
        }
        Optional<String> ret = this.cachedJWT;
        if (this.jwtFile != null && this.jwtFile.lastModified() > this.lastModified) {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.jwtFile));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (!StringUtils.isNotBlank((String)line) || line.startsWith("#")) continue;
                    ret = Optional.of(line);
                    this.lastModified = this.jwtFile.lastModified();
                    break;
                }
            }
            catch (IOException e) {
                LOG.error("JwTokenRetrieverFile.retrieve(): Failed to get JWT token.", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== JwTokenRetrieverFile.retrieve(): isJwTokenPresent=" + ret.isPresent());
        }
        return ret;
    }
}

