/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerAuditMetrics;
import org.apache.ranger.plugin.model.RangerAuditMetricsByDays;
import org.apache.ranger.plugin.model.RangerAuditMetricsByHours;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.util.SearchFilter;

public class AuditMetricsPredicateUtil
extends AbstractPredicateUtil {
    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        this.addPredicateForServiceType(filter.getParam("serviceType"), predicates);
        this.addPredicateForServiceName(filter.getParam("serviceName"), predicates);
        this.addPredicateForAppId(filter.getParam("appId"), predicates);
        this.addPredicateForClusterName(filter.getParam("clusterName"), predicates);
        this.addPredicateForClientIP(filter.getParam("clientIP"), predicates);
    }

    private Predicate addPredicateForServiceType(final String serviceType, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceType)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerAuditMetrics) {
                    RangerAuditMetrics rangerAuditMetrics = (RangerAuditMetrics)object;
                    ret = StringUtils.equals((String)rangerAuditMetrics.getServiceType().toString(), (String)serviceType);
                } else if (object instanceof RangerAuditMetricsByHours) {
                    RangerAuditMetricsByHours rangerAuditMetricsByHours = (RangerAuditMetricsByHours)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByHours.getServiceType().toString(), (String)serviceType);
                } else if (object instanceof RangerAuditMetricsByDays) {
                    RangerAuditMetricsByDays rangerAuditMetricsByDays = (RangerAuditMetricsByDays)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByDays.getServiceType().toString(), (String)serviceType);
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceName(final String serviceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerAuditMetrics) {
                    RangerAuditMetrics rangerAuditMetrics = (RangerAuditMetrics)object;
                    ret = StringUtils.equals((String)rangerAuditMetrics.getServiceName(), (String)serviceName);
                } else if (object instanceof RangerAuditMetricsByHours) {
                    RangerAuditMetricsByHours rangerAuditMetricsByHours = (RangerAuditMetricsByHours)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByHours.getServiceName(), (String)serviceName);
                } else if (object instanceof RangerAuditMetricsByDays) {
                    RangerAuditMetricsByDays rangerAuditMetricsByDays = (RangerAuditMetricsByDays)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByDays.getServiceName(), (String)serviceName);
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForAppId(final String appId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerAuditMetrics) {
                    RangerAuditMetrics rangerAuditMetrics = (RangerAuditMetrics)object;
                    ret = StringUtils.equals((String)rangerAuditMetrics.getAppId(), (String)appId);
                } else if (object instanceof RangerAuditMetricsByHours) {
                    RangerAuditMetricsByHours rangerAuditMetricsByHours = (RangerAuditMetricsByHours)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByHours.getAppId(), (String)appId);
                } else if (object instanceof RangerAuditMetricsByDays) {
                    RangerAuditMetricsByDays rangerAuditMetricsByDays = (RangerAuditMetricsByDays)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByDays.getAppId(), (String)appId);
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForClusterName(final String clusterName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)clusterName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerAuditMetrics) {
                    RangerAuditMetrics rangerAuditMetrics = (RangerAuditMetrics)object;
                    ret = StringUtils.equals((String)rangerAuditMetrics.getClusterName(), (String)clusterName);
                } else if (object instanceof RangerAuditMetricsByHours) {
                    RangerAuditMetricsByHours rangerAuditMetricsByHours = (RangerAuditMetricsByHours)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByHours.getClusterName(), (String)clusterName);
                } else if (object instanceof RangerAuditMetricsByDays) {
                    RangerAuditMetricsByDays rangerAuditMetricsByDays = (RangerAuditMetricsByDays)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByDays.getClusterName(), (String)clusterName);
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForClientIP(final String clientIP, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)clientIP)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerAuditMetrics) {
                    RangerAuditMetrics rangerAuditMetrics = (RangerAuditMetrics)object;
                    ret = StringUtils.equals((String)rangerAuditMetrics.getclientIP(), (String)clientIP);
                } else if (object instanceof RangerAuditMetricsByHours) {
                    RangerAuditMetricsByHours rangerAuditMetricsByHours = (RangerAuditMetricsByHours)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByHours.getClientIP(), (String)clientIP);
                } else if (object instanceof RangerAuditMetricsByDays) {
                    RangerAuditMetricsByDays rangerAuditMetricsByDays = (RangerAuditMetricsByDays)object;
                    ret = StringUtils.equals((String)rangerAuditMetricsByDays.getClientIP(), (String)clientIP);
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

