/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDefaultResourceMatcher
extends RangerAbstractResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultResourceMatcher.class);

    @Override
    public boolean isMatch(Object resource, RangerAccessRequest.ResourceElementMatchingScope matchingScope, Map<String, Object> evalContext) {
        boolean isPrefixMatch;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultResourceMatcher.isMatch(" + resource + ", " + evalContext + ")");
        }
        boolean ret = false;
        boolean allValuesRequested = this.isAllValuesRequested(resource);
        boolean bl = isPrefixMatch = matchingScope == RangerAccessRequest.ResourceElementMatchingScope.SELF_OR_PREFIX;
        if (this.isMatchAny || allValuesRequested && !isPrefixMatch) {
            ret = this.isMatchAny;
        } else if (resource instanceof String) {
            ResourceMatcher resourceMatcher;
            String strValue = (String)resource;
            Iterator<ResourceMatcher> iterator = this.resourceMatchers.getResourceMatchers().iterator();
            while (iterator.hasNext() && !(ret = (resourceMatcher = iterator.next()).isMatch(strValue, matchingScope, evalContext))) {
            }
        } else if (resource instanceof Collection) {
            Collection resourceValues = (Collection)resource;
            for (ResourceMatcher resourceMatcher : this.resourceMatchers.getResourceMatchers()) {
                String resourceValue;
                Iterator iterator = resourceValues.iterator();
                while (iterator.hasNext() && !(ret = resourceMatcher.isMatch(resourceValue = (String)iterator.next(), matchingScope, evalContext))) {
                }
                if (!ret) continue;
                break;
            }
        }
        ret = this.applyExcludes(allValuesRequested, ret);
        if (!ret && LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String policyValue : this.policyValues) {
                sb.append(policyValue);
                sb.append(" ");
            }
            sb.append("]");
            LOG.debug("RangerDefaultResourceMatcher.isMatch returns FALSE, (resource=" + resource + ", policyValues=" + sb.toString() + ")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultResourceMatcher.isMatch(" + resource + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultResourceMatcher={");
        super.toString(sb);
        sb.append("}");
        return sb;
    }
}

