/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.conditionevaluator.RangerConditionEvaluator;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestWrapper;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerAbstractPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerCustomConditionEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDataMaskPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultDataMaskPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultRowFilterPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerRowFilterPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerValidityScheduleEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDefaultPolicyEvaluator
extends RangerAbstractPolicyEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultPolicyEvaluator.class);
    private static final Logger PERF_POLICY_INIT_LOG = RangerPerfTracer.getPerfLogger("policy.init");
    private static final Logger PERF_POLICY_INIT_ACLSUMMARY_LOG = RangerPerfTracer.getPerfLogger("policy.init.ACLSummary");
    private static final Logger PERF_POLICY_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policy.request");
    private static final Logger PERF_POLICYCONDITION_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policycondition.request");
    private RangerPolicyResourceMatcher resourceMatcher;
    private List<RangerValidityScheduleEvaluator> validityScheduleEvaluators;
    private List<RangerPolicyItemEvaluator> allowEvaluators;
    private List<RangerPolicyItemEvaluator> denyEvaluators;
    private List<RangerPolicyItemEvaluator> allowExceptionEvaluators;
    private List<RangerPolicyItemEvaluator> denyExceptionEvaluators;
    private int customConditionsCount;
    private List<RangerDataMaskPolicyItemEvaluator> dataMaskEvaluators;
    private List<RangerRowFilterPolicyItemEvaluator> rowFilterEvaluators;
    private List<RangerConditionEvaluator> conditionEvaluators;
    private String perfTag;
    private RangerPolicyEvaluator.PolicyACLSummary aclSummary = null;
    private boolean useAclSummaryForEvaluation = false;
    private boolean disableRoleResolution = true;

    protected boolean needsDynamicEval() {
        return this.resourceMatcher != null && this.resourceMatcher.getNeedsDynamicEval();
    }

    @Override
    public int getCustomConditionsCount() {
        return this.customConditionsCount;
    }

    @Override
    public int getValidityScheduleEvaluatorsCount() {
        return this.validityScheduleEvaluators.size();
    }

    @Override
    public RangerPolicyResourceMatcher getPolicyResourceMatcher() {
        return this.resourceMatcher;
    }

    @Override
    public RangerResourceMatcher getResourceMatcher(String resourceName) {
        return this.resourceMatcher != null ? this.resourceMatcher.getResourceMatcher(resourceName) : null;
    }

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.init()");
        }
        StringBuilder perfTagBuffer = new StringBuilder();
        if (policy != null) {
            perfTagBuffer.append("policyId=").append(policy.getId()).append(", policyName=").append(policy.getName());
        }
        this.perfTag = perfTagBuffer.toString();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_INIT_LOG, "RangerPolicyEvaluator.init(" + this.perfTag + ")");
        }
        super.init(policy, serviceDef, options);
        policy = this.getPolicy();
        this.preprocessPolicy(policy, serviceDef);
        this.resourceMatcher = new RangerDefaultPolicyResourceMatcher();
        this.resourceMatcher.setServiceDef(serviceDef);
        this.resourceMatcher.setPolicy(policy);
        this.resourceMatcher.setServiceDefHelper(options.getServiceDefHelper());
        this.resourceMatcher.init();
        if (policy != null) {
            this.validityScheduleEvaluators = this.createValidityScheduleEvaluators(policy);
            this.disableRoleResolution = options.disableRoleResolution;
            if (!options.disableAccessEvaluationWithPolicyACLSummary) {
                this.aclSummary = this.createPolicyACLSummary();
            }
            boolean bl = this.useAclSummaryForEvaluation = this.aclSummary != null;
            if (this.useAclSummaryForEvaluation) {
                this.allowEvaluators = Collections.emptyList();
                this.denyEvaluators = Collections.emptyList();
                this.allowExceptionEvaluators = Collections.emptyList();
                this.denyExceptionEvaluators = Collections.emptyList();
            } else {
                this.allowEvaluators = this.createPolicyItemEvaluators(policy, serviceDef, options, 0);
                if (ServiceDefUtil.getOption_enableDenyAndExceptionsInPolicies(serviceDef, this.getPluginContext())) {
                    this.denyEvaluators = this.createPolicyItemEvaluators(policy, serviceDef, options, 1);
                    this.allowExceptionEvaluators = this.createPolicyItemEvaluators(policy, serviceDef, options, 2);
                    this.denyExceptionEvaluators = this.createPolicyItemEvaluators(policy, serviceDef, options, 3);
                } else {
                    this.denyEvaluators = Collections.emptyList();
                    this.allowExceptionEvaluators = Collections.emptyList();
                    this.denyExceptionEvaluators = Collections.emptyList();
                }
            }
            this.dataMaskEvaluators = this.createDataMaskPolicyItemEvaluators(policy, serviceDef, options, policy.getDataMaskPolicyItems());
            this.rowFilterEvaluators = this.createRowFilterPolicyItemEvaluators(policy, serviceDef, options, policy.getRowFilterPolicyItems());
            this.conditionEvaluators = this.createRangerPolicyConditionEvaluator(policy, serviceDef, options);
        } else {
            this.validityScheduleEvaluators = Collections.emptyList();
            this.allowEvaluators = Collections.emptyList();
            this.denyEvaluators = Collections.emptyList();
            this.allowExceptionEvaluators = Collections.emptyList();
            this.denyExceptionEvaluators = Collections.emptyList();
            this.dataMaskEvaluators = Collections.emptyList();
            this.rowFilterEvaluators = Collections.emptyList();
            this.conditionEvaluators = Collections.emptyList();
        }
        RangerPolicyItemEvaluator.EvalOrderComparator comparator = new RangerPolicyItemEvaluator.EvalOrderComparator();
        Collections.sort(this.allowEvaluators, comparator);
        Collections.sort(this.denyEvaluators, comparator);
        Collections.sort(this.allowExceptionEvaluators, comparator);
        Collections.sort(this.denyExceptionEvaluators, comparator);
        RangerPerfTracer.log(perf);
        if (this.useAclSummaryForEvaluation && (policy.getPolicyType() == null || policy.getPolicyType() == 0)) {
            LOG.info("PolicyEvaluator for policy:[" + policy.getId() + "] is set up to use ACL Summary to evaluate access");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.init()");
        }
    }

    @Override
    public boolean isApplicable(Date accessTime) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isApplicable(" + accessTime + ")");
        }
        boolean ret = false;
        if (accessTime != null && CollectionUtils.isNotEmpty(this.validityScheduleEvaluators)) {
            for (RangerValidityScheduleEvaluator evaluator : this.validityScheduleEvaluators) {
                if (!evaluator.isApplicable(accessTime.getTime())) continue;
                ret = true;
                break;
            }
        } else {
            ret = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isApplicable(" + accessTime + ") : " + ret);
        }
        return ret;
    }

    @Override
    public void evaluate(RangerAccessRequest request, RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.evaluate(policyId=" + this.getPolicyId() + ", " + request + ", " + result + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_REQUEST_LOG, "RangerPolicyEvaluator.evaluate(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + "," + this.perfTag + ")");
        }
        if (!(request == null || result == null || result.getIsAccessDetermined() && result.getIsAuditedDetermined())) {
            boolean isMatched;
            RangerPolicyResourceMatcher.MatchType matchType;
            if (RangerTagAccessRequest.class.isInstance(request)) {
                matchType = ((RangerTagAccessRequest)request).getMatchType();
                if (matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR) {
                    matchType = RangerPolicyResourceMatcher.MatchType.SELF;
                }
            } else {
                RangerPolicyResourceMatcher.MatchType matchType2 = matchType = this.resourceMatcher != null ? this.resourceMatcher.getMatchType(request.getResource(), request.getResourceElementMatchingScopes(), request.getContext()) : RangerPolicyResourceMatcher.MatchType.NONE;
            }
            if (request.isAccessTypeAny()) {
                isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
            } else if (request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
            } else {
                boolean bl = isMatched = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS;
            }
            if (isMatched && this.matchPolicyCustomConditions(request)) {
                if (!result.getIsAuditedDetermined() && this.isAuditEnabled()) {
                    result.setIsAudited(true);
                    result.setAuditPolicyId(this.getPolicyId());
                }
                if (!result.getIsAccessDetermined() && this.hasMatchablePolicyItem(request)) {
                    this.evaluatePolicyItems(request, matchType, result);
                }
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.evaluate(policyId=" + this.getPolicyId() + ", " + request + ", " + result + ")");
        }
    }

    @Override
    public boolean isMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isMatch(policy-id=" + this.getPolicyId() + ", " + resource + ", " + evalContext + ")");
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_REQUEST_LOG, "RangerPolicyEvaluator.isMatch(resource=" + resource.getAsString() + "," + evalContext + "," + this.perfTag + ")");
        }
        if (this.resourceMatcher != null) {
            ret = this.resourceMatcher.isMatch(resource, evalContext);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isMatch(policy-id=" + this.getPolicyId() + ", " + resource + ", " + evalContext + ") : " + ret);
        }
        return ret;
    }

    @Override
    public boolean isCompleteMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isCompleteMatch(" + resource + ", " + evalContext + ")");
        }
        boolean bl = ret = this.resourceMatcher != null && this.resourceMatcher.isCompleteMatch(resource, evalContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isCompleteMatch(" + resource + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean isCompleteMatch(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isCompleteMatch(" + resources + ", " + evalContext + ")");
        }
        boolean bl = ret = this.resourceMatcher != null && this.resourceMatcher.isCompleteMatch(resources, evalContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isCompleteMatch(" + resources + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean isSubsetMatch(RangerAccessResource resource, Map<String, Object> evalContext) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isSubsetMatch(" + resource + ", " + evalContext + ")");
        }
        boolean bl = ret = this.resourceMatcher != null && this.resourceMatcher.isSubsetMatch(resource, evalContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isSubsetMatch(" + resource + "): " + ret);
        }
        return ret;
    }

    @Override
    public Set<String> getAllowedAccesses(RangerAccessResource resource, String user, Set<String> userGroups, Set<String> roles, Set<String> accessTypes) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.getAllowedAccesses(policy-id=" + this.getPolicyId() + ", " + resource + ", " + user + ", " + userGroups + ", " + roles + ", " + accessTypes + ")");
        }
        HashSet<String> ret = null;
        HashMap<String, Object> evalContext = new HashMap<String, Object>();
        RangerAccessRequestUtil.setCurrentUserInContext(evalContext, user);
        if (this.isMatch(resource, evalContext)) {
            ret = new HashSet<String>();
            for (String accessType : accessTypes) {
                if (!this.isAccessAllowed(user, userGroups, roles, resource.getOwnerUser(), accessType)) continue;
                ret.add(accessType);
            }
        } else {
            LOG.debug("RangerDefaultPolicyEvaluator.getAllowedAccesses - Not Matched -- (policy-id=" + this.getPolicyId() + ", " + resource + ", " + user + ", " + userGroups + ", " + roles + ", " + accessTypes + ")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.getAllowedAccesses(policy-id=" + this.getPolicyId() + ", " + resource + ", " + user + ", " + userGroups + ", " + roles + ", " + accessTypes + "): " + ret);
        }
        return ret;
    }

    @Override
    public Set<String> getAllowedAccesses(Map<String, RangerPolicy.RangerPolicyResource> resources, String user, Set<String> userGroups, Set<String> roles, Set<String> accessTypes, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.getAllowedAccesses(" + this.getPolicyId() + ", " + user + ", " + userGroups + ", " + roles + ", " + accessTypes + ", " + evalContext + ")");
        }
        HashSet<String> ret = null;
        if (this.isMatch(resources, evalContext)) {
            if (CollectionUtils.isNotEmpty(accessTypes)) {
                ret = new HashSet<String>();
                for (String accessType : accessTypes) {
                    if (!this.isAccessAllowed(user, userGroups, roles, null, accessType)) continue;
                    ret.add(accessType);
                }
            } else if (this.isAccessAllowed(user, userGroups, roles, null, null)) {
                ret = new HashSet();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.getAllowedAccesses(" + this.getPolicyId() + ", " + user + ", " + userGroups + ", " + roles + ", " + accessTypes + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> resources, String user, Set<String> userGroups, String accessType) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + ")");
        }
        boolean bl = ret = this.isAccessAllowed(user, userGroups, null, null, accessType) && this.isMatch(resources, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret);
        }
        return ret;
    }

    @Override
    public void getResourceAccessInfo(RangerAccessRequest request, RangerResourceAccessInfo result) {
        boolean isMatched;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.getResourceAccessInfo(" + request + ", " + result + ")");
        }
        RangerPolicyResourceMatcher.MatchType matchType = RangerTagAccessRequest.class.isInstance(request) ? ((RangerTagAccessRequest)request).getMatchType() : (this.resourceMatcher != null ? this.resourceMatcher.getMatchType(request.getResource(), request.getResourceElementMatchingScopes(), request.getContext()) : RangerPolicyResourceMatcher.MatchType.NONE);
        boolean bl = isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
        if (isMatched) {
            HashSet<String> exceptionGroups;
            HashSet<String> exceptionUsers;
            HashSet<String> groups;
            HashSet<String> users;
            if (CollectionUtils.isNotEmpty(this.allowEvaluators)) {
                users = new HashSet<String>();
                groups = new HashSet<String>();
                this.getResourceAccessInfo(request, this.allowEvaluators, users, groups);
                if (CollectionUtils.isNotEmpty(this.allowExceptionEvaluators)) {
                    exceptionUsers = new HashSet<String>();
                    exceptionGroups = new HashSet<String>();
                    this.getResourceAccessInfo(request, this.allowExceptionEvaluators, exceptionUsers, exceptionGroups);
                    users.removeAll(exceptionUsers);
                    groups.removeAll(exceptionGroups);
                }
                result.getAllowedUsers().addAll(users);
                result.getAllowedGroups().addAll(groups);
            }
            if (matchType != RangerPolicyResourceMatcher.MatchType.DESCENDANT && CollectionUtils.isNotEmpty(this.denyEvaluators)) {
                users = new HashSet();
                groups = new HashSet();
                this.getResourceAccessInfo(request, this.denyEvaluators, users, groups);
                if (CollectionUtils.isNotEmpty(this.denyExceptionEvaluators)) {
                    exceptionUsers = new HashSet();
                    exceptionGroups = new HashSet();
                    this.getResourceAccessInfo(request, this.denyExceptionEvaluators, exceptionUsers, exceptionGroups);
                    users.removeAll(exceptionUsers);
                    groups.removeAll(exceptionGroups);
                }
                result.getDeniedUsers().addAll(users);
                result.getDeniedGroups().addAll(groups);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.getResourceAccessInfo(" + request + ", " + result + ")");
        }
    }

    @Override
    public RangerPolicyEvaluator.PolicyACLSummary getPolicyACLSummary() {
        if (this.aclSummary == null) {
            boolean forceCreation = true;
            this.aclSummary = this.createPolicyACLSummary(forceCreation);
        }
        return this.aclSummary;
    }

    @Override
    public void updateAccessResult(RangerAccessResult result, RangerPolicyResourceMatcher.MatchType matchType, boolean isAllowed, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.updateAccessResult(" + result + ", " + (Object)((Object)matchType) + ", " + isAllowed + ", " + reason + ", " + this.getId() + ")");
        }
        if (!isAllowed) {
            if (matchType != RangerPolicyResourceMatcher.MatchType.DESCENDANT || !result.getAccessRequest().ignoreDescendantDeny()) {
                result.setIsAllowed(false);
                result.setPolicyPriority(this.getPolicyPriority());
                result.setPolicyId(this.getId());
                result.setReason(reason);
                result.setPolicyVersion(this.getPolicy().getVersion());
            }
        } else if (!result.getIsAllowed() && matchType != RangerPolicyResourceMatcher.MatchType.ANCESTOR) {
            result.setIsAllowed(true);
            result.setPolicyPriority(this.getPolicyPriority());
            result.setPolicyId(this.getId());
            result.setReason(reason);
            result.setPolicyVersion(this.getPolicy().getVersion());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.updateAccessResult(" + result + ", " + (Object)((Object)matchType) + ", " + isAllowed + ", " + reason + ", " + this.getId() + ")");
        }
    }

    private RangerPolicyEvaluator.PolicyACLSummary createPolicyACLSummary() {
        boolean forceCreation = false;
        return this.createPolicyACLSummary(forceCreation);
    }

    /*
     * WARNING - void declaration
     */
    private RangerPolicyEvaluator.PolicyACLSummary createPolicyACLSummary(boolean isCreationForced) {
        boolean isUsableForEvaluation;
        RangerPolicyEvaluator.PolicyACLSummary ret = null;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_INIT_ACLSUMMARY_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_INIT_ACLSUMMARY_LOG, "RangerPolicyEvaluator.init.ACLSummary(" + this.perfTag + ")");
        }
        RangerPolicy policy = !this.disableRoleResolution && this.hasRoles(this.getPolicy()) ? this.getPolicyWithRolesResolved(this.getPolicy()) : this.getPolicy();
        boolean hasNonPublicGroupOrConditionsInAllowExceptions = RangerDefaultPolicyEvaluator.hasNonPublicGroupOrConditions(policy.getAllowExceptions());
        boolean hasNonPublicGroupOrConditionsInDenyExceptions = RangerDefaultPolicyEvaluator.hasNonPublicGroupOrConditions(policy.getDenyExceptions());
        boolean hasPublicGroupInAllowAndUsersInAllowExceptions = this.hasPublicGroupAndUserInException(policy.getPolicyItems(), policy.getAllowExceptions());
        boolean hasPublicGroupInDenyAndUsersInDenyExceptions = this.hasPublicGroupAndUserInException(policy.getDenyPolicyItems(), policy.getDenyExceptions());
        boolean hasContextSensitiveSpecification = this.hasContextSensitiveSpecification();
        boolean hasRoles = this.hasRoles(policy);
        boolean bl = isUsableForEvaluation = !hasNonPublicGroupOrConditionsInAllowExceptions && !hasNonPublicGroupOrConditionsInDenyExceptions && !hasPublicGroupInAllowAndUsersInAllowExceptions && !hasPublicGroupInDenyAndUsersInDenyExceptions && !hasContextSensitiveSpecification && !hasRoles;
        if (isUsableForEvaluation || isCreationForced) {
            void var13_27;
            ret = new RangerPolicyEvaluator.PolicyACLSummary();
            for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getDenyPolicyItems()) {
                ret.processPolicyItem(rangerPolicyItem, 1, hasNonPublicGroupOrConditionsInDenyExceptions || hasPublicGroupInDenyAndUsersInDenyExceptions);
            }
            if (!hasNonPublicGroupOrConditionsInDenyExceptions && !hasPublicGroupInDenyAndUsersInDenyExceptions) {
                for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getDenyExceptions()) {
                    ret.processPolicyItem(rangerPolicyItem, 3, false);
                }
            }
            for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getPolicyItems()) {
                ret.processPolicyItem(rangerPolicyItem, 0, hasNonPublicGroupOrConditionsInAllowExceptions || hasPublicGroupInAllowAndUsersInAllowExceptions);
            }
            if (!hasNonPublicGroupOrConditionsInAllowExceptions && !hasPublicGroupInAllowAndUsersInAllowExceptions) {
                for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getAllowExceptions()) {
                    ret.processPolicyItem(rangerPolicyItem, 2, false);
                }
            }
            for (RangerPolicy.RangerRowFilterPolicyItem rangerRowFilterPolicyItem : policy.getRowFilterPolicyItems()) {
                ret.processRowFilterPolicyItem(rangerRowFilterPolicyItem);
            }
            for (RangerPolicy.RangerDataMaskPolicyItem rangerDataMaskPolicyItem : policy.getDataMaskPolicyItems()) {
                ret.processDataMaskPolicyItem(rangerDataMaskPolicyItem);
            }
            boolean isDenyAllElse = Boolean.TRUE.equals(policy.getIsDenyAllElse());
            if (isDenyAllElse) {
                HashSet<String> hashSet = new HashSet<String>();
                RangerServiceDef serviceDef = this.getServiceDef();
                for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : serviceDef.getAccessTypes()) {
                    if (StringUtils.equalsIgnoreCase((String)accessTypeDef.getName(), (String)"all")) continue;
                    hashSet.add(accessTypeDef.getName());
                }
            } else {
                Set set = Collections.EMPTY_SET;
            }
            ret.finalizeAcls(isDenyAllElse, (Set<String>)var13_27);
        }
        RangerPerfTracer.logAlways(perf);
        return ret;
    }

    private RangerPolicy getPolicyWithRolesResolved(RangerPolicy policy) {
        RangerPolicy.RangerPolicyItem newPolicyItem;
        RangerPolicy ret = new RangerPolicy();
        ret.updateFrom(policy);
        ret.setId(policy.getId());
        ret.setGuid(policy.getGuid());
        ret.setVersion(policy.getVersion());
        ArrayList<RangerPolicy.RangerPolicyItem> policyItems = new ArrayList<RangerPolicy.RangerPolicyItem>();
        ArrayList<RangerPolicy.RangerPolicyItem> denyPolicyItems = new ArrayList<RangerPolicy.RangerPolicyItem>();
        ArrayList<RangerPolicy.RangerPolicyItem> allowExceptions = new ArrayList<RangerPolicy.RangerPolicyItem>();
        ArrayList<RangerPolicy.RangerPolicyItem> denyExceptions = new ArrayList<RangerPolicy.RangerPolicyItem>();
        ArrayList<RangerPolicy.RangerDataMaskPolicyItem> dataMaskPolicyItems = new ArrayList<RangerPolicy.RangerDataMaskPolicyItem>();
        ArrayList<RangerPolicy.RangerRowFilterPolicyItem> rowFilterPolicyItems = new ArrayList<RangerPolicy.RangerRowFilterPolicyItem>();
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getPolicyItems()) {
            newPolicyItem = new RangerPolicy.RangerPolicyItem(rangerPolicyItem.getAccesses(), rangerPolicyItem.getUsers(), rangerPolicyItem.getGroups(), rangerPolicyItem.getRoles(), rangerPolicyItem.getConditions(), rangerPolicyItem.getDelegateAdmin());
            this.getPolicyItemWithRolesResolved(newPolicyItem, rangerPolicyItem);
            policyItems.add(newPolicyItem);
        }
        ret.setPolicyItems(policyItems);
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getDenyPolicyItems()) {
            newPolicyItem = new RangerPolicy.RangerPolicyItem(rangerPolicyItem.getAccesses(), rangerPolicyItem.getUsers(), rangerPolicyItem.getGroups(), rangerPolicyItem.getRoles(), rangerPolicyItem.getConditions(), rangerPolicyItem.getDelegateAdmin());
            this.getPolicyItemWithRolesResolved(newPolicyItem, rangerPolicyItem);
            denyPolicyItems.add(newPolicyItem);
        }
        ret.setDenyPolicyItems(denyPolicyItems);
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getAllowExceptions()) {
            newPolicyItem = new RangerPolicy.RangerPolicyItem(rangerPolicyItem.getAccesses(), rangerPolicyItem.getUsers(), rangerPolicyItem.getGroups(), rangerPolicyItem.getRoles(), rangerPolicyItem.getConditions(), rangerPolicyItem.getDelegateAdmin());
            this.getPolicyItemWithRolesResolved(newPolicyItem, rangerPolicyItem);
            allowExceptions.add(newPolicyItem);
        }
        ret.setAllowExceptions(allowExceptions);
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policy.getDenyExceptions()) {
            newPolicyItem = new RangerPolicy.RangerPolicyItem(rangerPolicyItem.getAccesses(), rangerPolicyItem.getUsers(), rangerPolicyItem.getGroups(), rangerPolicyItem.getRoles(), rangerPolicyItem.getConditions(), rangerPolicyItem.getDelegateAdmin());
            this.getPolicyItemWithRolesResolved(newPolicyItem, rangerPolicyItem);
            denyExceptions.add(newPolicyItem);
        }
        ret.setDenyExceptions(denyExceptions);
        for (RangerPolicy.RangerDataMaskPolicyItem rangerDataMaskPolicyItem : policy.getDataMaskPolicyItems()) {
            newPolicyItem = new RangerPolicy.RangerDataMaskPolicyItem(rangerDataMaskPolicyItem.getAccesses(), rangerDataMaskPolicyItem.getDataMaskInfo(), rangerDataMaskPolicyItem.getUsers(), rangerDataMaskPolicyItem.getGroups(), rangerDataMaskPolicyItem.getRoles(), rangerDataMaskPolicyItem.getConditions(), rangerDataMaskPolicyItem.getDelegateAdmin());
            this.getPolicyItemWithRolesResolved(newPolicyItem, rangerDataMaskPolicyItem);
            dataMaskPolicyItems.add((RangerPolicy.RangerDataMaskPolicyItem)newPolicyItem);
        }
        ret.setDataMaskPolicyItems(dataMaskPolicyItems);
        for (RangerPolicy.RangerRowFilterPolicyItem rangerRowFilterPolicyItem : policy.getRowFilterPolicyItems()) {
            newPolicyItem = new RangerPolicy.RangerRowFilterPolicyItem(rangerRowFilterPolicyItem.getRowFilterInfo(), rangerRowFilterPolicyItem.getAccesses(), rangerRowFilterPolicyItem.getUsers(), rangerRowFilterPolicyItem.getGroups(), rangerRowFilterPolicyItem.getRoles(), rangerRowFilterPolicyItem.getConditions(), rangerRowFilterPolicyItem.getDelegateAdmin());
            this.getPolicyItemWithRolesResolved(newPolicyItem, rangerRowFilterPolicyItem);
            rowFilterPolicyItems.add((RangerPolicy.RangerRowFilterPolicyItem)newPolicyItem);
        }
        ret.setRowFilterPolicyItems(rowFilterPolicyItems);
        return ret;
    }

    private void getPolicyItemWithRolesResolved(RangerPolicy.RangerPolicyItem newPolicyItem, RangerPolicy.RangerPolicyItem policyItem) {
        HashSet<String> usersFromRoles = new HashSet<String>();
        HashSet<String> groupsFromRoles = new HashSet<String>();
        List<String> roles = policyItem.getRoles();
        for (String role : roles) {
            Set<String> users = this.getPluginContext().getAuthContext().getRangerRolesUtil().getRoleToUserMapping().get(role);
            Set<String> groups = this.getPluginContext().getAuthContext().getRangerRolesUtil().getRoleToGroupMapping().get(role);
            if (CollectionUtils.isNotEmpty(users)) {
                usersFromRoles.addAll(users);
            }
            if (CollectionUtils.isNotEmpty(groups)) {
                groupsFromRoles.addAll(groups);
            }
            if (!CollectionUtils.isNotEmpty(usersFromRoles) && !CollectionUtils.isNotEmpty(groupsFromRoles)) continue;
            usersFromRoles.addAll(policyItem.getUsers());
            groupsFromRoles.addAll(policyItem.getGroups());
            newPolicyItem.setUsers(new ArrayList<String>(usersFromRoles));
            newPolicyItem.setGroups(new ArrayList<String>(groupsFromRoles));
            newPolicyItem.setRoles(null);
        }
    }

    private boolean hasPublicGroupAndUserInException(List<RangerPolicy.RangerPolicyItem> grants, List<RangerPolicy.RangerPolicyItem> exceptionItems) {
        boolean ret = false;
        if (CollectionUtils.isNotEmpty(exceptionItems)) {
            boolean hasPublicGroupInGrant = false;
            for (RangerPolicy.RangerPolicyItem policyItem : grants) {
                if (!policyItem.getGroups().contains("public") && !policyItem.getUsers().contains("{USER}")) continue;
                hasPublicGroupInGrant = true;
                break;
            }
            if (hasPublicGroupInGrant) {
                boolean hasPublicGroupInException = false;
                for (RangerPolicy.RangerPolicyItem policyItem : exceptionItems) {
                    if (!policyItem.getGroups().contains("public") && !policyItem.getUsers().contains("{USER}")) continue;
                    hasPublicGroupInException = true;
                    break;
                }
                if (!hasPublicGroupInException) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    private Integer getAccessACLForOneGroup(RangerAccessRequest request, Set<String> accessesInGroup) {
        Integer ret = null;
        Map<String, Integer> accessTypeResults = RangerAccessRequestUtil.getAccessTypeACLResults(request);
        boolean isAccessDetermined = true;
        boolean isAccessDenied = false;
        Integer deniedAccessResult = null;
        for (String accessType : accessesInGroup) {
            Integer accessResult = accessTypeResults.get(accessType);
            if (accessResult != null) {
                if (accessResult.equals(ACCESS_ALLOWED)) {
                    isAccessDenied = false;
                    ret = accessResult;
                    break;
                }
                isAccessDenied = true;
                if (deniedAccessResult != null) continue;
                deniedAccessResult = accessResult;
                continue;
            }
            isAccessDetermined = false;
        }
        if (isAccessDetermined && isAccessDenied) {
            ret = deniedAccessResult;
        }
        return ret;
    }

    private Integer getCompositeACLResult(RangerAccessRequest request) {
        Integer ret = null;
        Set<Set<String>> allAccessTypeGroups = RangerAccessRequestUtil.getAllRequestedAccessTypeGroups(request);
        if (CollectionUtils.isEmpty(allAccessTypeGroups)) {
            Set<String> allAccessTypes = RangerAccessRequestUtil.getAllRequestedAccessTypes(request);
            ret = this.getAccessACLForOneGroup(request, allAccessTypes);
        } else {
            boolean isAccessDetermined = true;
            boolean isAccessAllowed = false;
            Integer allowResult = null;
            for (Set<String> accessesInGroup : allAccessTypeGroups) {
                Integer groupResult = this.getAccessACLForOneGroup(request, accessesInGroup);
                if (groupResult != null) {
                    if (!groupResult.equals(ACCESS_ALLOWED)) {
                        isAccessAllowed = false;
                        ret = groupResult;
                        break;
                    }
                    isAccessAllowed = true;
                    if (allowResult != null) continue;
                    allowResult = groupResult;
                    continue;
                }
                isAccessDetermined = false;
            }
            if (isAccessDetermined && isAccessAllowed) {
                ret = allowResult;
            }
        }
        return ret;
    }

    protected void evaluatePolicyItems(RangerAccessRequest request, RangerPolicyResourceMatcher.MatchType matchType, RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.evaluatePolicyItems(" + request + ", " + result + ", " + (Object)((Object)matchType) + ")");
        }
        if (this.useAclSummaryForEvaluation && (this.getPolicy().getPolicyType() == null || this.getPolicy().getPolicyType() == 0)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using ACL Summary for access evaluation. PolicyId=[" + this.getId() + "]");
            }
            Integer accessResult = null;
            if (request.isAccessTypeAny() || RangerAccessRequestUtil.getIsAnyAccessInContext(request.getContext())) {
                accessResult = this.lookupPolicyACLSummary(request.getUser(), request.getUserGroups(), request.getUserRoles(), "_any");
            } else {
                Map<String, Integer> accessTypeACLResults = RangerAccessRequestUtil.getAccessTypeACLResults(request);
                Set<String> allRequestedAccesses = RangerAccessRequestUtil.getAllRequestedAccessTypes(request);
                if (allRequestedAccesses.size() > 1) {
                    for (String accessType : allRequestedAccesses) {
                        Integer oldResult;
                        Integer denyResult = null;
                        Integer allowResult = null;
                        Integer oneAccessResult = this.lookupPolicyACLSummary(request.getUser(), request.getUserGroups(), request.getUserRoles(), accessType);
                        if (oneAccessResult == null) continue;
                        if (oneAccessResult.equals(ACCESS_DENIED)) {
                            denyResult = oneAccessResult;
                        }
                        if (oneAccessResult.equals(ACCESS_ALLOWED)) {
                            allowResult = oneAccessResult;
                        }
                        if ((oldResult = accessTypeACLResults.get(accessType)) == null) {
                            accessTypeACLResults.put(accessType, allowResult != null ? allowResult : denyResult);
                            continue;
                        }
                        if (oldResult.equals(ACCESS_ALLOWED)) {
                            if (denyResult != null) {
                                accessTypeACLResults.put(accessType, denyResult);
                                continue;
                            }
                            accessTypeACLResults.put(accessType, allowResult);
                            continue;
                        }
                        accessTypeACLResults.put(accessType, denyResult);
                    }
                    Integer compositeACLResult = this.getCompositeACLResult(request);
                    if (compositeACLResult != null) {
                        accessResult = compositeACLResult;
                    }
                } else {
                    accessResult = this.lookupPolicyACLSummary(request.getUser(), request.getUserGroups(), request.getUserRoles(), request.getAccessType());
                }
            }
            if (accessResult != null) {
                this.updateAccessResult(result, matchType, accessResult.equals(RangerPolicyEvaluator.ACCESS_ALLOWED), null);
            } else if (this.getPolicy().getIsDenyAllElse().booleanValue()) {
                this.updateAccessResult(result, matchType, false, "matched deny-all-else policy");
            }
        } else {
            Set<String> allRequestedAccesses;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using policyItemEvaluators for access evaluation. PolicyId=[" + this.getId() + "]");
            }
            if (CollectionUtils.isNotEmpty(allRequestedAccesses = RangerAccessRequestUtil.getAllRequestedAccessTypes(request))) {
                RangerAccessResult compositeAccessResult;
                Map<String, RangerAccessResult> accessTypeResults = RangerAccessRequestUtil.getAccessTypeResults(request);
                for (String accessType : allRequestedAccesses) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Checking for accessType:[" + accessType + "]");
                    }
                    RangerAccessResult denyResult = null;
                    RangerAccessResult allowResult = null;
                    boolean noResult = false;
                    RangerAccessRequestWrapper oneRequest = new RangerAccessRequestWrapper(request, accessType);
                    RangerAccessResult oneResult = new RangerAccessResult(result.getPolicyType(), result.getServiceName(), result.getServiceDef(), oneRequest);
                    oneResult.setAuditResultFrom(result);
                    RangerPolicyItemEvaluator matchedPolicyItem = this.getMatchingPolicyItem((RangerAccessRequest)oneRequest, oneResult);
                    if (matchedPolicyItem != null) {
                        matchedPolicyItem.updateAccessResult(this, oneResult, matchType);
                    } else if (this.getPolicy().getIsDenyAllElse().booleanValue() && (this.getPolicy().getPolicyType() == null || this.getPolicy().getPolicyType() == 0)) {
                        this.updateAccessResult(oneResult, matchType, false, "matched deny-all-else policy");
                    }
                    if (oneResult.getIsAllowed()) {
                        allowResult = oneResult;
                    } else if (oneResult.getIsAccessDetermined()) {
                        denyResult = oneResult;
                    } else {
                        noResult = true;
                    }
                    if (noResult) continue;
                    RangerAccessResult oldResult = accessTypeResults.get(accessType);
                    if (oldResult == null) {
                        accessTypeResults.put(accessType, allowResult != null ? allowResult : denyResult);
                    } else {
                        int oldPriority = oldResult.getPolicyPriority();
                        if (oldResult.getIsAllowed()) {
                            if (denyResult != null) {
                                if (this.getPolicyPriority() >= oldPriority) {
                                    accessTypeResults.put(accessType, denyResult);
                                }
                            } else if (this.getPolicy().getPolicyType() == null || this.getPolicy().getPolicyType() == 0) {
                                if (this.getPolicyPriority() > oldPriority) {
                                    accessTypeResults.put(accessType, allowResult);
                                }
                            } else if (this.getPolicyPriority() >= oldPriority) {
                                accessTypeResults.put(accessType, allowResult);
                            }
                        } else if (this.getPolicyPriority() >= oldPriority && allowResult != null && (oneRequest.isAccessTypeAny() || RangerAccessRequestUtil.getIsAnyAccessInContext(oneRequest.getContext()))) {
                            accessTypeResults.put(accessType, allowResult);
                        } else if (this.getPolicyPriority() > oldPriority && denyResult != null) {
                            accessTypeResults.put(accessType, denyResult);
                        }
                    }
                    if (!oneRequest.isAccessTypeAny() && !RangerAccessRequestUtil.getIsAnyAccessInContext(oneRequest.getContext()) || allowResult == null) continue;
                    break;
                }
                if ((compositeAccessResult = this.getCompositeAccessResult(request, result)) != null) {
                    result.setAccessResultFrom(compositeAccessResult);
                }
            } else {
                RangerPolicyItemEvaluator matchedPolicyItem = this.getMatchingPolicyItem(request, result);
                if (matchedPolicyItem != null) {
                    matchedPolicyItem.updateAccessResult(this, result, matchType);
                } else if (this.getPolicy().getIsDenyAllElse().booleanValue() && (this.getPolicy().getPolicyType() == null || this.getPolicy().getPolicyType() == 0)) {
                    this.updateAccessResult(result, matchType, false, "matched deny-all-else policy");
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.evaluatePolicyItems(" + request + ", " + result + ", " + (Object)((Object)matchType) + ")");
        }
    }

    private RangerAccessResult deriveAccessResultFromGroup(RangerAccessRequest request, Set<String> accessesInGroup) {
        RangerAccessResult ret = null;
        Map<String, RangerAccessResult> accessTypeResults = RangerAccessRequestUtil.getAccessTypeResults(request);
        boolean isAccessDetermined = true;
        boolean isAccessDenied = false;
        RangerAccessResult deniedAccessResult = null;
        for (String accessType : accessesInGroup) {
            RangerAccessResult accessResult = accessTypeResults.get(accessType);
            if (accessResult != null) {
                if (accessResult.getIsAllowed()) {
                    isAccessDenied = false;
                    ret = accessResult;
                    break;
                }
                isAccessDenied = true;
                if (deniedAccessResult != null) continue;
                deniedAccessResult = accessResult;
                continue;
            }
            isAccessDetermined = false;
        }
        if (isAccessDetermined && isAccessDenied) {
            ret = deniedAccessResult;
        }
        return ret;
    }

    private RangerAccessResult getCompositeAccessResult(RangerAccessRequest request, RangerAccessResult result) {
        RangerAccessResult ret = null;
        Set<Set<String>> allAccessTypeGroups = RangerAccessRequestUtil.getAllRequestedAccessTypeGroups(request);
        Set<String> allAccessTypes = RangerAccessRequestUtil.getAllRequestedAccessTypes(request);
        Set<String> notDeniedAccessTypes = RangerAccessRequestUtil.getDenyOnExplicitDenyAccessTypes(request);
        if (CollectionUtils.isEmpty(allAccessTypeGroups)) {
            ret = this.deriveAccessResultFromGroup(request, allAccessTypes);
            if (ret == null && CollectionUtils.isNotEmpty(notDeniedAccessTypes) && notDeniedAccessTypes.containsAll(allAccessTypes)) {
                ret = new RangerAccessResult(result.getPolicyType(), result.getServiceName(), result.getServiceDef(), request);
                ret.setAuditResultFrom(result);
                ret.setIsAllowed(true);
            }
        } else {
            boolean isAccessDetermined = true;
            boolean isAccessAllowed = false;
            RangerAccessResult allowResult = null;
            for (Set<String> accessesInGroup : allAccessTypeGroups) {
                RangerAccessResult groupResult = this.deriveAccessResultFromGroup(request, accessesInGroup);
                if (groupResult != null) {
                    if (!groupResult.getIsAllowed()) {
                        isAccessAllowed = false;
                        ret = groupResult;
                        break;
                    }
                    isAccessAllowed = true;
                    if (allowResult != null) continue;
                    allowResult = groupResult;
                    continue;
                }
                if (CollectionUtils.isNotEmpty(notDeniedAccessTypes) && notDeniedAccessTypes.containsAll(accessesInGroup)) continue;
                isAccessDetermined = false;
            }
            if (isAccessDetermined && isAccessAllowed) {
                ret = allowResult;
            } else if (isAccessDetermined && ret == null) {
                ret = new RangerAccessResult(result.getPolicyType(), result.getServiceName(), result.getServiceDef(), request);
                ret.setAuditResultFrom(result);
                ret.setIsAllowed(true);
            }
        }
        return ret;
    }

    private Integer lookupPolicyACLSummary(String user, Set<String> userGroups, Set<String> userRoles, String accessType) {
        Integer accessResult;
        block3: {
            String userGroup;
            accessResult = null;
            Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accesses = this.aclSummary.getUsersAccessInfo().get(user);
            accessResult = this.lookupAccess(user, accessType, accesses);
            if (accessResult != null) break block3;
            HashSet<String> groups = new HashSet<String>();
            groups.add("public");
            groups.addAll(userGroups);
            Iterator<Object> iterator = groups.iterator();
            while (iterator.hasNext() && (accessResult = this.lookupAccess(userGroup = (String)iterator.next(), accessType, accesses = this.aclSummary.getGroupsAccessInfo().get(userGroup))) == null) {
            }
            if (accessResult == null && userRoles != null) {
                String userRole;
                iterator = userRoles.iterator();
                while (iterator.hasNext() && (accessResult = this.lookupAccess(userRole = (String)iterator.next(), accessType, accesses = this.aclSummary.getRolesAccessInfo().get(userRole))) == null) {
                }
            }
        }
        return accessResult;
    }

    private Integer lookupAccess(String userOrGroup, String accessType, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accesses) {
        Integer ret = null;
        if (accesses != null) {
            if (accessType.equals("_any")) {
                ret = this.getAccessResultForAnyAccess(accesses);
            } else {
                RangerPolicyEvaluator.PolicyACLSummary.AccessResult accessResult = accesses.get(accessType);
                if (accessResult != null) {
                    if (accessResult.getResult() == RangerPolicyEvaluator.ACCESS_CONDITIONAL.intValue()) {
                        LOG.error("Access should not be conditional at this point! user=[" + userOrGroup + "], accessType=[" + accessType + "]");
                    } else {
                        ret = accessResult.getResult();
                    }
                }
            }
        }
        return ret;
    }

    private Integer getAccessResultForAnyAccess(Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accesses) {
        int allowedAccessCount = 0;
        int deniedAccessCount = 0;
        for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> entry : accesses.entrySet()) {
            if (StringUtils.equals((String)entry.getKey(), (String)"_admin")) continue;
            RangerPolicyEvaluator.PolicyACLSummary.AccessResult accessResult = entry.getValue();
            if (accessResult.getResult() == RangerPolicyEvaluator.ACCESS_ALLOWED.intValue()) {
                ++allowedAccessCount;
                break;
            }
            if (accessResult.getResult() != RangerPolicyEvaluator.ACCESS_DENIED.intValue()) continue;
            ++deniedAccessCount;
        }
        Integer ret = allowedAccessCount > 0 ? RangerPolicyEvaluator.ACCESS_ALLOWED : (deniedAccessCount == this.getServiceDef().getAccessTypes().size() ? RangerPolicyEvaluator.ACCESS_DENIED : null);
        return ret;
    }

    protected RangerPolicyItemEvaluator getDeterminingPolicyItem(String user, Set<String> userGroups, Set<String> roles, String owner, String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.getDeterminingPolicyItem(" + user + ", " + userGroups + ", " + roles + ", " + owner + ", " + accessType + ")");
        }
        RangerPolicyItemEvaluator ret = null;
        ret = this.getMatchingPolicyItem(user, userGroups, roles, owner, accessType, this.denyEvaluators, this.denyExceptionEvaluators);
        if (ret == null) {
            ret = this.getMatchingPolicyItem(user, userGroups, roles, owner, accessType, this.allowEvaluators, this.allowExceptionEvaluators);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.getDeterminingPolicyItem(" + user + ", " + userGroups + ", " + roles + ", " + owner + ", " + accessType + "): " + ret);
        }
        return ret;
    }

    private void getResourceAccessInfo(RangerAccessRequest request, List<? extends RangerPolicyItemEvaluator> policyItems, Set<String> users, Set<String> groups) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.getResourceAccessInfo(" + request + ", " + policyItems + ", " + users + ", " + groups + ")");
        }
        if (CollectionUtils.isNotEmpty(policyItems)) {
            for (RangerPolicyItemEvaluator rangerPolicyItemEvaluator : policyItems) {
                if (!rangerPolicyItemEvaluator.matchAccessType(request.getAccessType()) || !rangerPolicyItemEvaluator.matchCustomConditions(request)) continue;
                if (CollectionUtils.isNotEmpty(rangerPolicyItemEvaluator.getPolicyItem().getUsers())) {
                    users.addAll(rangerPolicyItemEvaluator.getPolicyItem().getUsers());
                }
                if (!CollectionUtils.isNotEmpty(rangerPolicyItemEvaluator.getPolicyItem().getGroups())) continue;
                groups.addAll(rangerPolicyItemEvaluator.getPolicyItem().getGroups());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.getResourceAccessInfo(" + request + ", " + policyItems + ", " + users + ", " + groups + ")");
        }
    }

    protected boolean isMatch(RangerPolicy policy, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isMatch(" + policy.getId() + ", " + evalContext + ")");
        }
        boolean ret = this.isMatch(policy.getResources(), evalContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isMatch(" + policy.getId() + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    protected boolean isMatch(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isMatch(" + resources + ", " + evalContext + ")");
        }
        boolean bl = ret = this.resourceMatcher != null && this.resourceMatcher.isMatch(resources, evalContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isMatch(" + resources + ", " + evalContext + "): " + ret);
        }
        return ret;
    }

    protected boolean isAccessAllowed(String user, Set<String> userGroups, Set<String> roles, String owner, String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.isAccessAllowed(policy-id=" + this.getPolicyId() + ", " + user + ", " + userGroups + ", " + roles + ", " + owner + ", " + accessType + ")");
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_REQUEST_LOG, "RangerPolicyEvaluator.isAccessAllowed(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + "," + this.perfTag + ")");
        }
        if (this.useAclSummaryForEvaluation && (this.getPolicy().getPolicyType() == null || this.getPolicy().getPolicyType() == 0)) {
            Integer accessResult;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using ACL Summary for checking if access is allowed. PolicyId=[" + this.getId() + "]");
            }
            Integer n = accessResult = StringUtils.isEmpty((String)accessType) ? null : this.lookupPolicyACLSummary(user, userGroups, roles, accessType);
            if (accessResult != null && accessResult.equals(RangerPolicyEvaluator.ACCESS_ALLOWED)) {
                ret = true;
            }
        } else {
            RangerPolicyItemEvaluator item;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using policyItemEvaluators for checking if access is allowed. PolicyId=[" + this.getId() + "]");
            }
            if ((item = this.getDeterminingPolicyItem(user, userGroups, roles, owner, accessType)) != null && item.getPolicyItemType() == 0) {
                ret = true;
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.isAccessAllowed(policy-id=" + this.getPolicyId() + ", " + user + ", " + userGroups + ", " + roles + ", " + owner + ", " + accessType + "): " + ret);
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultPolicyEvaluator={");
        super.toString(sb);
        sb.append("resourceMatcher={");
        if (this.resourceMatcher != null) {
            this.resourceMatcher.toString(sb);
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    protected void preprocessPolicy(RangerPolicy policy, RangerServiceDef serviceDef) {
        if (policy == null || !this.hasAllow() && !this.hasDeny() || serviceDef == null) {
            return;
        }
        Map<String, Collection<String>> impliedAccessGrants = this.getImpliedAccessGrants(serviceDef);
        if (impliedAccessGrants == null || impliedAccessGrants.isEmpty()) {
            return;
        }
        this.preprocessPolicyItems(policy.getPolicyItems(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getDenyPolicyItems(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getAllowExceptions(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getDenyExceptions(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getDataMaskPolicyItems(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getRowFilterPolicyItems(), impliedAccessGrants);
    }

    protected void preprocessPolicyItems(List<? extends RangerPolicy.RangerPolicyItem> policyItems, Map<String, Collection<String>> impliedAccessGrants) {
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
            if (CollectionUtils.isEmpty(rangerPolicyItem.getAccesses())) continue;
            for (Map.Entry<String, Collection<String>> e : impliedAccessGrants.entrySet()) {
                String accessType = e.getKey();
                Collection<String> impliedGrants = e.getValue();
                RangerPolicy.RangerPolicyItemAccess access = this.getAccess(rangerPolicyItem, accessType);
                if (access == null) continue;
                for (String impliedGrant : impliedGrants) {
                    RangerPolicy.RangerPolicyItemAccess impliedAccess = this.getAccess(rangerPolicyItem, impliedGrant);
                    if (impliedAccess == null) {
                        impliedAccess = new RangerPolicy.RangerPolicyItemAccess(impliedGrant, access.getIsAllowed());
                        rangerPolicyItem.getAccesses().add(impliedAccess);
                        continue;
                    }
                    if (impliedAccess.getIsAllowed().booleanValue()) continue;
                    impliedAccess.setIsAllowed(access.getIsAllowed());
                }
            }
        }
    }

    protected Map<String, Collection<String>> getImpliedAccessGrants(RangerServiceDef serviceDef) {
        HashMap<String, HashSet<String>> ret = null;
        if (serviceDef != null && !CollectionUtils.isEmpty(serviceDef.getAccessTypes())) {
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : serviceDef.getAccessTypes()) {
                HashSet<String> impliedAccessGrants;
                if (CollectionUtils.isEmpty(accessTypeDef.getImpliedGrants())) continue;
                if (ret == null) {
                    ret = new HashMap<String, HashSet<String>>();
                }
                if ((impliedAccessGrants = (HashSet<String>)ret.get(accessTypeDef.getName())) == null) {
                    impliedAccessGrants = new HashSet<String>();
                    ret.put(accessTypeDef.getName(), impliedAccessGrants);
                }
                impliedAccessGrants.addAll(accessTypeDef.getImpliedGrants());
            }
        }
        return ret;
    }

    private RangerPolicy.RangerPolicyItemAccess getAccess(RangerPolicy.RangerPolicyItem policyItem, String accessType) {
        RangerPolicy.RangerPolicyItemAccess ret = null;
        if (policyItem != null && CollectionUtils.isNotEmpty(policyItem.getAccesses())) {
            for (RangerPolicy.RangerPolicyItemAccess itemAccess : policyItem.getAccesses()) {
                if (itemAccess == null || !StringUtils.equalsIgnoreCase((String)itemAccess.getType(), (String)accessType)) continue;
                ret = itemAccess;
                break;
            }
        }
        return ret;
    }

    private List<RangerValidityScheduleEvaluator> createValidityScheduleEvaluators(RangerPolicy policy) {
        List<RangerValidityScheduleEvaluator> ret = null;
        if (CollectionUtils.isNotEmpty(policy.getValiditySchedules())) {
            ret = new ArrayList();
            for (RangerValiditySchedule schedule : policy.getValiditySchedules()) {
                ret.add(new RangerValidityScheduleEvaluator(schedule));
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    private List<RangerPolicyItemEvaluator> createPolicyItemEvaluators(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options, int policyItemType) {
        List<RangerPolicyItemEvaluator> ret = null;
        List<RangerPolicy.RangerPolicyItem> policyItems = null;
        if (this.isPolicyItemTypeEnabled(serviceDef, policyItemType)) {
            if (policyItemType == 0) {
                policyItems = policy.getPolicyItems();
            } else if (policyItemType == 1) {
                policyItems = policy.getDenyPolicyItems();
            } else if (policyItemType == 2) {
                policyItems = policy.getAllowExceptions();
            } else if (policyItemType == 3) {
                policyItems = policy.getDenyExceptions();
            }
        }
        if (CollectionUtils.isNotEmpty(policyItems)) {
            ret = new ArrayList();
            int policyItemCounter = 1;
            for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                RangerDefaultPolicyItemEvaluator itemEvaluator = new RangerDefaultPolicyItemEvaluator(serviceDef, policy, policyItem, policyItemType, policyItemCounter++, options);
                itemEvaluator.init();
                ret.add(itemEvaluator);
                if (!CollectionUtils.isNotEmpty(itemEvaluator.getConditionEvaluators())) continue;
                this.customConditionsCount += itemEvaluator.getConditionEvaluators().size();
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    private List<RangerDataMaskPolicyItemEvaluator> createDataMaskPolicyItemEvaluators(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options, List<RangerPolicy.RangerDataMaskPolicyItem> policyItems) {
        List<RangerDataMaskPolicyItemEvaluator> ret = null;
        if (CollectionUtils.isNotEmpty(policyItems)) {
            ret = new ArrayList();
            int policyItemCounter = 1;
            for (RangerPolicy.RangerDataMaskPolicyItem policyItem : policyItems) {
                RangerDefaultDataMaskPolicyItemEvaluator itemEvaluator = new RangerDefaultDataMaskPolicyItemEvaluator(serviceDef, policy, policyItem, policyItemCounter++, options);
                itemEvaluator.init();
                ret.add(itemEvaluator);
                if (!CollectionUtils.isNotEmpty(itemEvaluator.getConditionEvaluators())) continue;
                this.customConditionsCount += itemEvaluator.getConditionEvaluators().size();
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    private List<RangerRowFilterPolicyItemEvaluator> createRowFilterPolicyItemEvaluators(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options, List<RangerPolicy.RangerRowFilterPolicyItem> policyItems) {
        List<RangerRowFilterPolicyItemEvaluator> ret = null;
        if (CollectionUtils.isNotEmpty(policyItems)) {
            ret = new ArrayList();
            int policyItemCounter = 1;
            for (RangerPolicy.RangerRowFilterPolicyItem policyItem : policyItems) {
                RangerDefaultRowFilterPolicyItemEvaluator itemEvaluator = new RangerDefaultRowFilterPolicyItemEvaluator(serviceDef, policy, policyItem, policyItemCounter++, options);
                itemEvaluator.init();
                ret.add(itemEvaluator);
                if (!CollectionUtils.isNotEmpty(itemEvaluator.getConditionEvaluators())) continue;
                this.customConditionsCount += itemEvaluator.getConditionEvaluators().size();
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    private boolean isPolicyItemTypeEnabled(RangerServiceDef serviceDef, int policyItemType) {
        boolean ret = true;
        if (policyItemType == 1 || policyItemType == 2 || policyItemType == 3) {
            ret = ServiceDefUtil.getOption_enableDenyAndExceptionsInPolicies(serviceDef, this.pluginContext);
        }
        return ret;
    }

    private static boolean hasNonPublicGroupOrConditions(List<RangerPolicy.RangerPolicyItem> policyItems) {
        boolean ret = false;
        for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
            if (CollectionUtils.isNotEmpty(policyItem.getConditions())) {
                ret = true;
                break;
            }
            List<String> allGroups = policyItem.getGroups();
            if (!CollectionUtils.isNotEmpty(allGroups) || allGroups.contains("public")) continue;
            ret = true;
            break;
        }
        return ret;
    }

    protected RangerPolicyItemEvaluator getMatchingPolicyItem(RangerAccessRequest request, RangerAccessResult result) {
        RangerPolicyItemEvaluator ret = null;
        Integer policyType = this.getPolicy().getPolicyType();
        if (policyType == null) {
            policyType = 0;
        }
        switch (policyType) {
            case 0: {
                ret = this.getMatchingPolicyItemForAccessPolicyForSpecificAccess(request, result);
                break;
            }
            case 1: {
                ret = this.getMatchingPolicyItem(request, this.dataMaskEvaluators);
                break;
            }
            case 2: {
                ret = this.getMatchingPolicyItem(request, this.rowFilterEvaluators);
                break;
            }
        }
        return ret;
    }

    protected RangerPolicyItemEvaluator getMatchingPolicyItemForAccessPolicyForSpecificAccess(RangerAccessRequest request, RangerAccessResult result) {
        RangerPolicyItemEvaluator ret = this.getMatchingPolicyItem(request, this.denyEvaluators, this.denyExceptionEvaluators);
        if (ret == null && !result.getIsAccessDetermined()) {
            ret = this.getMatchingPolicyItem(request, this.allowEvaluators, this.allowExceptionEvaluators);
        }
        return ret;
    }

    protected <T extends RangerPolicyItemEvaluator> T getMatchingPolicyItem(RangerAccessRequest request, List<T> evaluators) {
        T ret = this.getMatchingPolicyItem(request, evaluators, null);
        return ret;
    }

    private <T extends RangerPolicyItemEvaluator> T getMatchingPolicyItem(RangerAccessRequest request, List<T> evaluators, List<T> exceptionEvaluators) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + request + ")");
        }
        RangerPolicyItemEvaluator ret = null;
        if (CollectionUtils.isNotEmpty(evaluators)) {
            for (RangerPolicyItemEvaluator evaluator : evaluators) {
                if (!evaluator.isMatch(request)) continue;
                ret = evaluator;
                break;
            }
        }
        if (ret != null && CollectionUtils.isNotEmpty(exceptionEvaluators)) {
            for (RangerPolicyItemEvaluator exceptionEvaluator : exceptionEvaluators) {
                if (!exceptionEvaluator.isMatch(request)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + request + "): found exception policyItem(" + exceptionEvaluator.getPolicyItem() + "); ignoring the matchedPolicyItem(" + ret.getPolicyItem() + ")");
                }
                ret = null;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + request + "): " + ret);
        }
        return (T)ret;
    }

    private <T extends RangerPolicyItemEvaluator> T getMatchingPolicyItem(String user, Set<String> userGroups, Set<String> roles, String owner, String accessType, List<T> evaluators, List<T> exceptionEvaluators) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + user + ", " + userGroups + ", " + roles + ", " + owner + ", " + accessType + ")");
        }
        RangerPolicyItemEvaluator ret = null;
        if (CollectionUtils.isNotEmpty(evaluators)) {
            for (RangerPolicyItemEvaluator evaluator : evaluators) {
                if (!evaluator.matchUserGroupAndOwner(user, userGroups, roles, owner) || !evaluator.matchAccessType(accessType)) continue;
                ret = evaluator;
                break;
            }
        }
        if (ret != null && CollectionUtils.isNotEmpty(exceptionEvaluators)) {
            for (RangerPolicyItemEvaluator exceptionEvaluator : exceptionEvaluators) {
                if (!exceptionEvaluator.matchUserGroupAndOwner(user, userGroups, roles, owner) || !exceptionEvaluator.matchAccessType(accessType)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + user + ", " + userGroups + ", " + accessType + "): found exception policyItem(" + exceptionEvaluator.getPolicyItem() + "); ignoring the matchedPolicyItem(" + ret.getPolicyItem() + ")");
                }
                ret = null;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + user + ", " + userGroups + ", " + roles + ", " + owner + ", " + accessType + "): " + ret);
        }
        return (T)ret;
    }

    private boolean matchPolicyCustomConditions(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyEvaluator.matchPolicyCustomConditions(" + request + ")");
        }
        boolean ret = true;
        if (CollectionUtils.isNotEmpty(this.conditionEvaluators)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerDefaultPolicyEvaluator.matchPolicyCustomConditions(): conditionCount=" + this.conditionEvaluators.size());
            }
            for (RangerConditionEvaluator conditionEvaluator : this.conditionEvaluators) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("evaluating condition: " + conditionEvaluator);
                }
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYCONDITION_REQUEST_LOG)) {
                    String conditionType = null;
                    if (conditionEvaluator instanceof RangerAbstractConditionEvaluator) {
                        conditionType = ((RangerAbstractConditionEvaluator)conditionEvaluator).getPolicyItemCondition().getType();
                    }
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYCONDITION_REQUEST_LOG, "RangerConditionEvaluator.matchPolicyCustomConditions(policyId=" + this.getId() + ",policyConditionType=" + conditionType + ")");
                }
                boolean conditionEvalResult = conditionEvaluator.isMatched(request);
                RangerPerfTracer.log(perf);
                if (conditionEvalResult) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(conditionEvaluator + " returned false");
                }
                ret = false;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyEvaluator.matchCustomConditions(" + request + "): " + ret);
        }
        return ret;
    }

    private List<RangerConditionEvaluator> createRangerPolicyConditionEvaluator(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        List<RangerConditionEvaluator> rangerConditionEvaluators = null;
        RangerCustomConditionEvaluator rangerConditionEvaluator = new RangerCustomConditionEvaluator();
        rangerConditionEvaluators = rangerConditionEvaluator.getRangerPolicyConditionEvaluator(policy, serviceDef, options);
        if (rangerConditionEvaluators != null) {
            this.customConditionsCount += rangerConditionEvaluators.size();
        }
        return rangerConditionEvaluators;
    }
}

