/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.resourcematcher.RangerPathResourceMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceDefHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceDefHelper.class);
    static final Map<String, Delegate> _Cache = new ConcurrentHashMap<String, Delegate>();
    final Delegate _delegate;

    public static RangerServiceDef getServiceDefForPolicyFiltering(RangerServiceDef serviceDef) {
        ArrayList<RangerServiceDef.RangerResourceDef> modifiedResourceDefs = new ArrayList<RangerServiceDef.RangerResourceDef>();
        for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
            RangerServiceDef.RangerResourceDef modifiedResourceDef;
            String matcherClassName = resourceDef.getMatcher();
            if (RangerPathResourceMatcher.class.getName().equals(matcherClassName)) {
                HashMap<String, String> modifiedMatcherOptions = new HashMap<String, String>(resourceDef.getMatcherOptions());
                modifiedMatcherOptions.put("wildCard", "false");
                modifiedResourceDef = new RangerServiceDef.RangerResourceDef(resourceDef);
                modifiedResourceDef.setMatcherOptions(modifiedMatcherOptions);
                modifiedResourceDef.setRecursiveSupported(false);
            } else {
                modifiedResourceDef = resourceDef;
            }
            modifiedResourceDefs.add(modifiedResourceDef);
        }
        return new RangerServiceDef(serviceDef.getName(), serviceDef.getDisplayName(), serviceDef.getImplClass(), serviceDef.getLabel(), serviceDef.getDescription(), serviceDef.getOptions(), serviceDef.getConfigs(), modifiedResourceDefs, serviceDef.getAccessTypes(), serviceDef.getPolicyConditions(), serviceDef.getContextEnrichers(), serviceDef.getEnums());
    }

    public static Map<String, String> getFilterResourcesForAncestorPolicyFiltering(RangerServiceDef serviceDef, Map<String, String> filterResources) {
        HashMap<String, String> ret = null;
        for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
            String resourceValue;
            String matcherClassName = resourceDef.getMatcher();
            if (!RangerPathResourceMatcher.class.getName().equals(matcherClassName)) continue;
            String resourceDefName = resourceDef.getName();
            Map<String, String> resourceMatcherOptions = resourceDef.getMatcherOptions();
            String delimiter = resourceMatcherOptions.get("pathSeparatorChar");
            if (StringUtils.isBlank((String)delimiter)) {
                delimiter = Character.toString('/');
            }
            if (!StringUtils.isNotBlank((String)(resourceValue = filterResources.get(resourceDefName)))) continue;
            if (!resourceValue.endsWith(delimiter)) {
                resourceValue = resourceValue + delimiter;
            }
            resourceValue = resourceValue + "*";
            if (ret == null) {
                ret = new HashMap<String, String>();
            }
            ret.put(resourceDefName, resourceValue);
        }
        return ret;
    }

    public RangerServiceDefHelper(RangerServiceDef serviceDef) {
        this(serviceDef, true, false);
    }

    public RangerServiceDefHelper(RangerServiceDef serviceDef, boolean useCache) {
        this(serviceDef, useCache, false);
    }

    public RangerServiceDefHelper(RangerServiceDef serviceDef, boolean useCache, boolean checkForCycles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> RangerServiceDefHelper(). The RangerServiceDef: %s", serviceDef));
        }
        String serviceName = serviceDef.getName();
        Date serviceDefFreshnessDate = serviceDef.getUpdateTime();
        Delegate delegate = null;
        if (useCache && _Cache.containsKey(serviceName)) {
            LOG.debug("RangerServiceDefHelper(): found delegate in cache with matching serviceName.  Need to check date");
            Delegate that = _Cache.get(serviceName);
            if (Objects.equals(that.getServiceFreshnessDate(), serviceDefFreshnessDate)) {
                delegate = that;
                LOG.debug("RangerServiceDefHelper(): cached delegate matched in date, too! Will use it now.");
            } else {
                LOG.debug("RangerServiceDefHelper(): cached delegate date mismatch!");
            }
        }
        if (delegate == null) {
            delegate = new Delegate(serviceDef, checkForCycles);
            if (useCache) {
                LOG.debug("RangerServiceDefHelper(): Created new delegate and put in delegate cache!");
                _Cache.put(serviceName, delegate);
            }
        }
        this._delegate = delegate;
    }

    public RangerServiceDef getServiceDef() {
        return this._delegate._serviceDef;
    }

    public void patchServiceDefWithDefaultValues() {
        this._delegate.patchServiceDefWithDefaultValues();
    }

    public RangerServiceDef.RangerResourceDef getResourceDef(String resourceName) {
        return this._delegate.getResourceDef(resourceName, 0);
    }

    public RangerServiceDef.RangerResourceDef getResourceDef(String resourceName, Integer policyType) {
        return this._delegate.getResourceDef(resourceName, policyType);
    }

    public Set<List<RangerServiceDef.RangerResourceDef>> getResourceHierarchies(Integer policyType) {
        return this._delegate.getResourceHierarchies(policyType);
    }

    public Set<List<RangerServiceDef.RangerResourceDef>> filterHierarchies_containsOnlyMandatoryResources(Integer policyType) {
        Set<List<RangerServiceDef.RangerResourceDef>> hierarchies = this.getResourceHierarchies(policyType);
        HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            Set<String> mandatoryResources = this.getMandatoryResourceNames(aHierarchy);
            if (aHierarchy.size() != mandatoryResources.size()) continue;
            result.add(aHierarchy);
        }
        return result;
    }

    public Set<List<RangerServiceDef.RangerResourceDef>> getResourceHierarchies(Integer policyType, Collection<String> keys) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getResourceHierarchies(policyType=" + policyType + ", keys=" + StringUtils.join(keys, (String)",") + ")");
        }
        HashSet<List<RangerServiceDef.RangerResourceDef>> ret = new HashSet<List<RangerServiceDef.RangerResourceDef>>();
        if (policyType == 3) {
            policyType = 0;
        }
        for (List<RangerServiceDef.RangerResourceDef> hierarchy : this.getResourceHierarchies(policyType)) {
            if (!this.hierarchyHasAllResources(hierarchy, keys)) continue;
            ret.add(hierarchy);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getResourceHierarchies(policyType=" + policyType + ", keys=" + StringUtils.join(keys, (String)",") + ") : " + StringUtils.join(ret, (String)","));
        }
        return ret;
    }

    public boolean hierarchyHasAllResources(List<RangerServiceDef.RangerResourceDef> hierarchy, Collection<String> resourceNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> hierarchyHasAllResources(hierarchy=" + StringUtils.join(hierarchy, (String)",") + ", resourceNames=" + StringUtils.join(resourceNames, (String)",") + ")");
        }
        boolean foundAllResourceKeys = true;
        for (String resourceKey : resourceNames) {
            boolean found = false;
            for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
                if (!resourceDef.getName().equals(resourceKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            foundAllResourceKeys = false;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== hierarchyHasAllResources(hierarchy=" + StringUtils.join(hierarchy, (String)",") + ", resourceNames=" + StringUtils.join(resourceNames, (String)",") + "): " + foundAllResourceKeys);
        }
        return foundAllResourceKeys;
    }

    public Set<String> getMandatoryResourceNames(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        HashSet<String> result = new HashSet<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            if (!Boolean.TRUE.equals(resourceDef.getMandatory())) continue;
            result.add(resourceDef.getName());
        }
        return result;
    }

    public Set<String> getAllResourceNames(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        HashSet<String> result = new HashSet<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            result.add(resourceDef.getName());
        }
        return result;
    }

    public List<String> getAllResourceNamesOrdered(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        ArrayList<String> result = new ArrayList<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            result.add(resourceDef.getName());
        }
        return result;
    }

    public boolean isResourceGraphValid() {
        return this._delegate.isResourceGraphValid();
    }

    public List<String> getOrderedResourceNames(Collection<String> resourceNames) {
        ArrayList<String> ret;
        if (resourceNames != null) {
            ret = new ArrayList<String>();
            block0: for (String orderedName : this._delegate.getAllOrderedResourceNames()) {
                for (String resourceName : resourceNames) {
                    if (!StringUtils.equals((String)orderedName, (String)resourceName) || ret.contains(resourceName)) continue;
                    ret.add(resourceName);
                    continue block0;
                }
            }
        } else {
            ret = Collections.EMPTY_LIST;
        }
        return ret;
    }

    static class DirectedGraph {
        Map<String, Set<String>> _nodes = new HashMap<String, Set<String>>();

        DirectedGraph() {
        }

        void add(String node) {
            if (node == null) {
                throw new IllegalArgumentException("Node can't be null!");
            }
            if (!this._nodes.containsKey(node)) {
                this._nodes.put(node, new HashSet());
            }
        }

        void addArc(String from, String to) {
            if (!this._nodes.containsKey(from)) {
                this.add(from);
            }
            if (!this._nodes.containsKey(to)) {
                this.add(to);
            }
            this._nodes.get(from).add(to);
        }

        boolean hasArc(String from, String to) {
            return this._nodes.containsKey(from) && this._nodes.containsKey(to) && this._nodes.get(from).contains(to);
        }

        boolean hasNeighbors(String from) {
            return this._nodes.containsKey(from) && !this._nodes.get(from).isEmpty();
        }

        Set<String> getSources() {
            HashSet<String> sources = new HashSet<String>(this._nodes.keySet());
            for (Map.Entry<String, Set<String>> entry : this._nodes.entrySet()) {
                Set<String> nbrs = entry.getValue();
                sources.removeAll(nbrs);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Returning sources: " + sources);
            }
            return sources;
        }

        Set<String> getSinks() {
            HashSet<String> sinks = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : this._nodes.entrySet()) {
                Set<String> nbrs = entry.getValue();
                if (!nbrs.isEmpty()) continue;
                String node = entry.getKey();
                sinks.add(node);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Returning sinks: " + sinks);
            }
            return sinks;
        }

        List<String> getACycle(Set<String> sources, Set<String> sinks) {
            List<String> ret = null;
            Sets.SetView nonSourceOrSinkNodes = Sets.difference(this._nodes.keySet(), (Set)Sets.union(sources, sinks));
            for (String node : nonSourceOrSinkNodes) {
                ArrayList<String> seenNodes = new ArrayList<String>();
                seenNodes.add(node);
                ret = this.findCycle(node, seenNodes);
                if (ret == null) continue;
                break;
            }
            return ret;
        }

        List<String> findCycle(String node, List<String> seenNodes) {
            List<String> ret = null;
            Set<String> nbrs = this._nodes.get(node);
            for (String nbr : nbrs) {
                boolean foundCycle = seenNodes.contains(nbr);
                seenNodes.add(nbr);
                if (foundCycle) {
                    ret = seenNodes;
                    break;
                }
                ret = this.findCycle(nbr, seenNodes);
                if (ret == null) continue;
                break;
            }
            return ret;
        }

        List<String> getAPath(String from, String to, Set<String> alreadyVisited) {
            ArrayList<String> path = new ArrayList<String>(this._nodes.size());
            if (this._nodes.containsKey(from) && this._nodes.containsKey(to)) {
                if (this.hasArc(from, to)) {
                    path.add(from);
                    path.add(to);
                } else {
                    alreadyVisited.add(from);
                    Set<String> nbrs = this._nodes.get(from);
                    for (String nbr : nbrs) {
                        List<String> subPath;
                        if (alreadyVisited.contains(nbr) || (subPath = this.getAPath(nbr, to, alreadyVisited)).isEmpty()) continue;
                        path.add(from);
                        path.addAll(subPath);
                    }
                }
            }
            return path;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            DirectedGraph that = (DirectedGraph)object;
            return Objects.equals(this._nodes, that._nodes);
        }

        public int hashCode() {
            return Objects.hashCode(this._nodes);
        }

        public String toString() {
            return "_nodes=" + Objects.toString(this._nodes);
        }
    }

    static class Delegate {
        final RangerServiceDef _serviceDef;
        final Map<Integer, Set<List<RangerServiceDef.RangerResourceDef>>> _hierarchies = new HashMap<Integer, Set<List<RangerServiceDef.RangerResourceDef>>>();
        final Date _serviceDefFreshnessDate;
        final String _serviceName;
        final boolean _checkForCycles;
        final boolean _valid;
        final List<String> _orderedResourceNames;
        static final Set<List<RangerServiceDef.RangerResourceDef>> EMPTY_RESOURCE_HIERARCHY = Collections.unmodifiableSet(new HashSet());

        public Delegate(RangerServiceDef serviceDef, boolean checkForCycles) {
            this._serviceDef = serviceDef;
            this._serviceName = serviceDef.getName();
            this._serviceDefFreshnessDate = serviceDef.getUpdateTime();
            this._checkForCycles = checkForCycles;
            boolean isValid = true;
            int[] nArray = RangerPolicy.POLICY_TYPES;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer policyType = nArray[i];
                List<RangerServiceDef.RangerResourceDef> resources = this.getResourceDefs(serviceDef, policyType);
                DirectedGraph graph = this.createGraph(resources);
                if (graph != null) {
                    Map<String, RangerServiceDef.RangerResourceDef> resourceDefMap = this.getResourcesAsMap(resources);
                    if (this.isValid(graph, resourceDefMap)) {
                        Set<List<RangerServiceDef.RangerResourceDef>> hierarchies = this.getHierarchies(graph, resourceDefMap);
                        this._hierarchies.put(policyType, Collections.unmodifiableSet(hierarchies));
                        continue;
                    }
                    isValid = false;
                    this._hierarchies.put(policyType, EMPTY_RESOURCE_HIERARCHY);
                    continue;
                }
                this._hierarchies.put(policyType, EMPTY_RESOURCE_HIERARCHY);
            }
            this._orderedResourceNames = isValid ? this.buildSortedResourceNames() : new ArrayList<String>();
            this._valid = isValid;
            if (LOG.isDebugEnabled()) {
                String message = String.format("Found [%d] resource hierarchies for service [%s] update-date[%s]: %s", this._hierarchies.size(), this._serviceName, this._serviceDefFreshnessDate == null ? null : this._serviceDefFreshnessDate.toString(), this._hierarchies);
                LOG.debug(message);
            }
        }

        public void patchServiceDefWithDefaultValues() {
            for (int policyType : RangerPolicy.POLICY_TYPES) {
                Set<List<RangerServiceDef.RangerResourceDef>> resourceHierarchies = this.getResourceHierarchies(policyType);
                for (List<RangerServiceDef.RangerResourceDef> resourceHierarchy : resourceHierarchies) {
                    for (int index = 0; index < resourceHierarchy.size(); ++index) {
                        RangerServiceDef.RangerResourceDef resourceDef = resourceHierarchy.get(index);
                        if (Boolean.TRUE.equals(resourceDef.getIsValidLeaf())) continue;
                        resourceDef.setIsValidLeaf(index == resourceHierarchy.size() - 1);
                    }
                }
            }
        }

        public RangerServiceDef.RangerResourceDef getResourceDef(String resourceName, Integer policyType) {
            List<RangerServiceDef.RangerResourceDef> resourceDefs;
            RangerServiceDef.RangerResourceDef ret = null;
            if (policyType == null) {
                policyType = 0;
            }
            if ((resourceDefs = this.getResourceDefs(this._serviceDef, policyType)) != null) {
                for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                    if (!StringUtils.equals((String)resourceName, (String)resourceDef.getName())) continue;
                    ret = resourceDef;
                    break;
                }
            }
            return ret;
        }

        public Set<List<RangerServiceDef.RangerResourceDef>> getResourceHierarchies(Integer policyType) {
            Set<List<RangerServiceDef.RangerResourceDef>> ret;
            if (policyType == null) {
                policyType = 0;
            }
            if ((ret = this._hierarchies.get(policyType)) == null) {
                ret = EMPTY_RESOURCE_HIERARCHY;
            }
            return ret;
        }

        public String getServiceName() {
            return this._serviceName;
        }

        public Date getServiceFreshnessDate() {
            return this._serviceDefFreshnessDate;
        }

        public boolean isResourceGraphValid() {
            return this._valid;
        }

        DirectedGraph createGraph(List<RangerServiceDef.RangerResourceDef> resourceDefs) {
            DirectedGraph graph = null;
            if (CollectionUtils.isNotEmpty(resourceDefs)) {
                graph = new DirectedGraph();
                for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                    String name = resourceDef.getName();
                    graph.add(name);
                    String parent = resourceDef.getParent();
                    if (!StringUtils.isNotEmpty((String)parent)) continue;
                    graph.addArc(parent, name);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created graph for resources: " + graph);
            }
            return graph;
        }

        List<RangerServiceDef.RangerResourceDef> getResourceDefs(RangerServiceDef serviceDef, Integer policyType) {
            List<RangerServiceDef.RangerResourceDef> resourceDefs = policyType == null || policyType == 0 ? serviceDef.getResources() : (policyType == 1 ? (serviceDef.getDataMaskDef() != null ? serviceDef.getDataMaskDef().getResources() : null) : (policyType == 2 ? (serviceDef.getRowFilterDef() != null ? serviceDef.getRowFilterDef().getResources() : null) : serviceDef.getResources()));
            return resourceDefs;
        }

        boolean isValid(DirectedGraph graph, Map<String, RangerServiceDef.RangerResourceDef> resourceDefMap) {
            boolean ret = true;
            Set<String> sources = graph.getSources();
            Set<String> sinks = graph.getSinks();
            if (CollectionUtils.isEmpty(sources) || CollectionUtils.isEmpty(sinks)) {
                ret = false;
            } else {
                List<String> cycle;
                List<String> list = cycle = this._checkForCycles ? graph.getACycle(sources, sinks) : null;
                if (cycle == null) {
                    for (String sink : sinks) {
                        RangerServiceDef.RangerResourceDef sinkResourceDef = resourceDefMap.get(sink);
                        if (!Boolean.FALSE.equals(sinkResourceDef.getIsValidLeaf())) continue;
                        LOG.error("Error in path: sink node:[" + sink + "] is not leaf node");
                        ret = false;
                        break;
                    }
                } else {
                    LOG.error("Graph contains cycle! - " + cycle);
                    ret = false;
                }
            }
            return ret;
        }

        Set<List<RangerServiceDef.RangerResourceDef>> getHierarchies(DirectedGraph graph, Map<String, RangerServiceDef.RangerResourceDef> resourceMap) {
            HashSet<List<String>> hierarchies = new HashSet<List<String>>();
            Set<String> sources = graph.getSources();
            Set<String> sinks = graph.getSinks();
            for (String source : sources) {
                if (!graph.hasNeighbors(source)) {
                    hierarchies.add(Lists.newArrayList((Object[])new String[]{source}));
                    continue;
                }
                for (String sink : sinks) {
                    List<String> path = graph.getAPath(source, sink, new HashSet<String>());
                    if (path.isEmpty()) continue;
                    hierarchies.add(path);
                    ArrayList<String> workingPath = new ArrayList<String>();
                    int pathSize = path.size();
                    for (int index = 0; index < pathSize - 1; ++index) {
                        String node = path.get(index);
                        workingPath.add(node);
                        if (!Boolean.TRUE.equals(resourceMap.get(node).getIsValidLeaf())) continue;
                        hierarchies.add(new ArrayList(workingPath));
                    }
                }
            }
            return this.convertHierarchies(hierarchies, resourceMap);
        }

        Set<List<RangerServiceDef.RangerResourceDef>> convertHierarchies(Set<List<String>> hierarchies, Map<String, RangerServiceDef.RangerResourceDef> resourceMap) {
            HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
            for (List<String> hierarchy : hierarchies) {
                ArrayList<RangerServiceDef.RangerResourceDef> resourceList = new ArrayList<RangerServiceDef.RangerResourceDef>(hierarchy.size());
                for (String name : hierarchy) {
                    RangerServiceDef.RangerResourceDef def = resourceMap.get(name);
                    resourceList.add(def);
                }
                result.add(resourceList);
            }
            return result;
        }

        Map<String, RangerServiceDef.RangerResourceDef> getResourcesAsMap(List<RangerServiceDef.RangerResourceDef> resourceList) {
            HashMap<String, RangerServiceDef.RangerResourceDef> map = new HashMap<String, RangerServiceDef.RangerResourceDef>(resourceList.size());
            for (RangerServiceDef.RangerResourceDef resourceDef : resourceList) {
                map.put(resourceDef.getName(), resourceDef);
            }
            return map;
        }

        List<String> getAllOrderedResourceNames() {
            return this._orderedResourceNames;
        }

        private List<String> buildSortedResourceNames() {
            ArrayList<String> ret = new ArrayList<String>();
            boolean isValid = true;
            ArrayList<ResourceNameLevel> resourceNameLevels = new ArrayList<ResourceNameLevel>();
            for (RangerServiceDef.RangerResourceDef resourceDef : this._serviceDef.getResources()) {
                String name = resourceDef.getName();
                Integer level = resourceDef.getLevel();
                if (name != null && level != null) {
                    ResourceNameLevel resourceNameLevel = new ResourceNameLevel(name, level);
                    resourceNameLevels.add(resourceNameLevel);
                    continue;
                }
                LOG.error("Incorrect resourceDef:[name=" + name + "]");
                isValid = false;
                break;
            }
            if (isValid) {
                Collections.sort(resourceNameLevels);
                for (ResourceNameLevel resourceNameLevel : resourceNameLevels) {
                    ret.add(resourceNameLevel.resourceName);
                }
            }
            return ret;
        }

        private static class ResourceNameLevel
        implements Comparable<ResourceNameLevel> {
            private String resourceName;
            private int level;

            ResourceNameLevel(String resourceName, int level) {
                this.resourceName = resourceName;
                this.level = level;
            }

            @Override
            public int compareTo(ResourceNameLevel other) {
                return Integer.compare(this.level, other.level);
            }
        }
    }
}

