/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerPluginInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ENTITY_TYPE_POLICIES = 0;
    public static final int ENTITY_TYPE_TAGS = 1;
    public static final int ENTITY_TYPE_ROLES = 2;
    public static final int ENTITY_TYPE_USERSTORE = 3;
    public static final String PLUGIN_INFO_POLICY_DOWNLOAD_TIME = "policyDownloadTime";
    public static final String PLUGIN_INFO_POLICY_DOWNLOADED_VERSION = "policyDownloadedVersion";
    public static final String PLUGIN_INFO_POLICY_ACTIVATION_TIME = "policyActivationTime";
    public static final String PLUGIN_INFO_POLICY_ACTIVE_VERSION = "policyActiveVersion";
    public static final String PLUGIN_INFO_TAG_DOWNLOAD_TIME = "tagDownloadTime";
    public static final String PLUGIN_INFO_TAG_DOWNLOADED_VERSION = "tagDownloadedVersion";
    public static final String PLUGIN_INFO_TAG_ACTIVATION_TIME = "tagActivationTime";
    public static final String PLUGIN_INFO_TAG_ACTIVE_VERSION = "tagActiveVersion";
    public static final String PLUGIN_INFO_ROLE_DOWNLOAD_TIME = "roleDownloadTime";
    public static final String PLUGIN_INFO_ROLE_DOWNLOADED_VERSION = "roleDownloadedVersion";
    public static final String PLUGIN_INFO_ROLE_ACTIVATION_TIME = "roleActivationTime";
    public static final String PLUGIN_INFO_ROLE_ACTIVE_VERSION = "roleActiveVersion";
    public static final String PLUGIN_INFO_USERSTORE_DOWNLOAD_TIME = "userstoreDownloadTime";
    public static final String PLUGIN_INFO_USERSTORE_DOWNLOADED_VERSION = "userstoreDownloadedVersion";
    public static final String PLUGIN_INFO_USERSTORE_ACTIVATION_TIME = "userstoreActivationTime";
    public static final String PLUGIN_INFO_USERSTORE_ACTIVE_VERSION = "userstoreActiveVersion";
    public static final String RANGER_ADMIN_LAST_POLICY_UPDATE_TIME = "lastPolicyUpdateTime";
    public static final String RANGER_ADMIN_LATEST_POLICY_VERSION = "latestPolicyVersion";
    public static final String RANGER_ADMIN_LAST_TAG_UPDATE_TIME = "lastTagUpdateTime";
    public static final String RANGER_ADMIN_LATEST_TAG_VERSION = "latestTagVersion";
    public static final String RANGER_ADMIN_CAPABILITIES = "adminCapabilities";
    public static final String PLUGIN_INFO_CAPABILITIES = "pluginCapabilities";
    private Long id;
    private Date createTime;
    private Date updateTime;
    private String serviceName;
    private String serviceDisplayName;
    private String serviceType;
    private String serviceTypeDisplayName;
    private String hostName;
    private String appType;
    private String ipAddress;
    private Map<String, String> info;

    public RangerPluginInfo(Long id, Date createTime, Date updateTime, String serviceName, String appType, String hostName, String ipAddress, Map<String, String> info) {
        this.setId(id);
        this.setCreateTime(createTime);
        this.setUpdateTime(updateTime);
        this.setServiceName(serviceName);
        this.setAppType(appType);
        this.setHostName(hostName);
        this.setIpAddress(ipAddress);
        this.setInfo(info);
    }

    public RangerPluginInfo() {
        this(null, null, null, null, null, null, null, null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceTypeDisplayName() {
        return this.serviceTypeDisplayName;
    }

    public void setServiceTypeDisplayName(String serviceTypeDisplayName) {
        this.serviceTypeDisplayName = serviceTypeDisplayName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceDisplayName() {
        return this.serviceDisplayName;
    }

    public void setServiceDisplayName(String serviceDisplayName) {
        this.serviceDisplayName = serviceDisplayName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, String> info) {
        this.info = info == null ? new HashMap() : info;
    }

    @JsonIgnore
    public void setPolicyDownloadTime(Long policyDownloadTime) {
        this.getInfo().put(PLUGIN_INFO_POLICY_DOWNLOAD_TIME, policyDownloadTime == null ? null : Long.toString(policyDownloadTime));
    }

    @JsonIgnore
    public Long getPolicyDownloadTime() {
        String downloadTimeString = this.getInfo().get(PLUGIN_INFO_POLICY_DOWNLOAD_TIME);
        return StringUtils.isNotBlank((String)downloadTimeString) ? Long.valueOf(downloadTimeString) : null;
    }

    @JsonIgnore
    public void setPolicyDownloadedVersion(Long policyDownloadedVersion) {
        this.getInfo().put(PLUGIN_INFO_POLICY_DOWNLOADED_VERSION, policyDownloadedVersion == null ? null : Long.toString(policyDownloadedVersion));
    }

    @JsonIgnore
    public Long getPolicyDownloadedVersion() {
        String downloadedVersionString = this.getInfo().get(PLUGIN_INFO_POLICY_DOWNLOADED_VERSION);
        return StringUtils.isNotBlank((String)downloadedVersionString) ? Long.valueOf(downloadedVersionString) : null;
    }

    @JsonIgnore
    public void setPolicyActivationTime(Long policyActivationTime) {
        this.getInfo().put(PLUGIN_INFO_POLICY_ACTIVATION_TIME, policyActivationTime == null ? null : Long.toString(policyActivationTime));
    }

    @JsonIgnore
    public Long getPolicyActivationTime() {
        String activationTimeString = this.getInfo().get(PLUGIN_INFO_POLICY_ACTIVATION_TIME);
        return StringUtils.isNotBlank((String)activationTimeString) ? Long.valueOf(activationTimeString) : null;
    }

    @JsonIgnore
    public void setPolicyActiveVersion(Long policyActiveVersion) {
        this.getInfo().put(PLUGIN_INFO_POLICY_ACTIVE_VERSION, policyActiveVersion == null ? null : Long.toString(policyActiveVersion));
    }

    @JsonIgnore
    public Long getPolicyActiveVersion() {
        String activeVersionString = this.getInfo().get(PLUGIN_INFO_POLICY_ACTIVE_VERSION);
        return StringUtils.isNotBlank((String)activeVersionString) ? Long.valueOf(activeVersionString) : null;
    }

    @JsonIgnore
    public void setTagDownloadTime(Long tagDownloadTime) {
        this.getInfo().put(PLUGIN_INFO_TAG_DOWNLOAD_TIME, tagDownloadTime == null ? null : Long.toString(tagDownloadTime));
    }

    @JsonIgnore
    public Long getTagDownloadTime() {
        String downloadTimeString = this.getInfo().get(PLUGIN_INFO_TAG_DOWNLOAD_TIME);
        return StringUtils.isNotBlank((String)downloadTimeString) ? Long.valueOf(downloadTimeString) : null;
    }

    @JsonIgnore
    public void setTagDownloadedVersion(Long tagDownloadedVersion) {
        this.getInfo().put(PLUGIN_INFO_TAG_DOWNLOADED_VERSION, tagDownloadedVersion == null ? null : Long.toString(tagDownloadedVersion));
    }

    @JsonIgnore
    public Long getTagDownloadedVersion() {
        String downloadedVersion = this.getInfo().get(PLUGIN_INFO_TAG_DOWNLOADED_VERSION);
        return StringUtils.isNotBlank((String)downloadedVersion) ? Long.valueOf(downloadedVersion) : null;
    }

    @JsonIgnore
    public void setTagActivationTime(Long tagActivationTime) {
        this.getInfo().put(PLUGIN_INFO_TAG_ACTIVATION_TIME, tagActivationTime == null ? null : Long.toString(tagActivationTime));
    }

    @JsonIgnore
    public Long getTagActivationTime() {
        String activationTimeString = this.getInfo().get(PLUGIN_INFO_TAG_ACTIVATION_TIME);
        return StringUtils.isNotBlank((String)activationTimeString) ? Long.valueOf(activationTimeString) : null;
    }

    @JsonIgnore
    public void setTagActiveVersion(Long tagActiveVersion) {
        this.getInfo().put(PLUGIN_INFO_TAG_ACTIVE_VERSION, tagActiveVersion == null ? null : Long.toString(tagActiveVersion));
    }

    @JsonIgnore
    public Long getTagActiveVersion() {
        String activeVersionString = this.getInfo().get(PLUGIN_INFO_TAG_ACTIVE_VERSION);
        return StringUtils.isNotBlank((String)activeVersionString) ? Long.valueOf(activeVersionString) : null;
    }

    @JsonIgnore
    public Long getLatestPolicyVersion() {
        String latestPolicyVersionString = this.getInfo().get(RANGER_ADMIN_LATEST_POLICY_VERSION);
        return StringUtils.isNotBlank((String)latestPolicyVersionString) ? Long.valueOf(latestPolicyVersionString) : null;
    }

    @JsonIgnore
    public Long getLastPolicyUpdateTime() {
        String updateTimeString = this.getInfo().get(RANGER_ADMIN_LAST_POLICY_UPDATE_TIME);
        return StringUtils.isNotBlank((String)updateTimeString) ? Long.valueOf(updateTimeString) : null;
    }

    @JsonIgnore
    public Long getLatestTagVersion() {
        String latestTagVersionString = this.getInfo().get(RANGER_ADMIN_LATEST_TAG_VERSION);
        return StringUtils.isNotBlank((String)latestTagVersionString) ? Long.valueOf(latestTagVersionString) : null;
    }

    @JsonIgnore
    public Long getLastTagUpdateTime() {
        String updateTimeString = this.getInfo().get(RANGER_ADMIN_LAST_TAG_UPDATE_TIME);
        return StringUtils.isNotBlank((String)updateTimeString) ? Long.valueOf(updateTimeString) : null;
    }

    @JsonIgnore
    public void setRoleDownloadTime(Long roleDownloadTime) {
        this.getInfo().put(PLUGIN_INFO_ROLE_DOWNLOAD_TIME, roleDownloadTime == null ? null : Long.toString(roleDownloadTime));
    }

    @JsonIgnore
    public Long getRoleDownloadTime() {
        String downloadTimeString = this.getInfo().get(PLUGIN_INFO_ROLE_DOWNLOAD_TIME);
        return StringUtils.isNotBlank((String)downloadTimeString) ? Long.valueOf(downloadTimeString) : null;
    }

    @JsonIgnore
    public void setRoleDownloadedVersion(Long roleDownloadedVersion) {
        this.getInfo().put(PLUGIN_INFO_ROLE_DOWNLOADED_VERSION, roleDownloadedVersion == null ? null : Long.toString(roleDownloadedVersion));
    }

    @JsonIgnore
    public Long getRoleDownloadedVersion() {
        String downloadedVersionString = this.getInfo().get(PLUGIN_INFO_ROLE_DOWNLOADED_VERSION);
        return StringUtils.isNotBlank((String)downloadedVersionString) ? Long.valueOf(downloadedVersionString) : null;
    }

    @JsonIgnore
    public void setRoleActivationTime(Long roleActivationTime) {
        this.getInfo().put(PLUGIN_INFO_ROLE_ACTIVATION_TIME, roleActivationTime == null ? null : Long.toString(roleActivationTime));
    }

    @JsonIgnore
    public Long getRoleActivationTime() {
        String activationTimeString = this.getInfo().get(PLUGIN_INFO_ROLE_ACTIVATION_TIME);
        return StringUtils.isNotBlank((String)activationTimeString) ? Long.valueOf(activationTimeString) : null;
    }

    @JsonIgnore
    public void setRoleActiveVersion(Long roleActiveVersion) {
        this.getInfo().put(PLUGIN_INFO_ROLE_ACTIVE_VERSION, roleActiveVersion == null ? null : Long.toString(roleActiveVersion));
    }

    @JsonIgnore
    public Long getRoleActiveVersion() {
        String activeVersionString = this.getInfo().get(PLUGIN_INFO_ROLE_ACTIVE_VERSION);
        return StringUtils.isNotBlank((String)activeVersionString) ? Long.valueOf(activeVersionString) : null;
    }

    @JsonIgnore
    public void setUserStoreDownloadTime(Long userstoreDownloadTime) {
        this.getInfo().put(PLUGIN_INFO_USERSTORE_DOWNLOAD_TIME, userstoreDownloadTime == null ? null : Long.toString(userstoreDownloadTime));
    }

    @JsonIgnore
    public Long getUserStoreDownloadTime() {
        String downloadTimeString = this.getInfo().get(PLUGIN_INFO_USERSTORE_DOWNLOAD_TIME);
        return StringUtils.isNotBlank((String)downloadTimeString) ? Long.valueOf(downloadTimeString) : null;
    }

    @JsonIgnore
    public void setUserStoreDownloadedVersion(Long userstoreDownloadedVersion) {
        this.getInfo().put(PLUGIN_INFO_USERSTORE_DOWNLOADED_VERSION, userstoreDownloadedVersion == null ? null : Long.toString(userstoreDownloadedVersion));
    }

    @JsonIgnore
    public Long getUserStoreDownloadedVersion() {
        String downloadedVersionString = this.getInfo().get(PLUGIN_INFO_USERSTORE_DOWNLOADED_VERSION);
        return StringUtils.isNotBlank((String)downloadedVersionString) ? Long.valueOf(downloadedVersionString) : null;
    }

    @JsonIgnore
    public void setUserStoreActivationTime(Long userstoreActivationTime) {
        this.getInfo().put(PLUGIN_INFO_USERSTORE_ACTIVATION_TIME, userstoreActivationTime == null ? null : Long.toString(userstoreActivationTime));
    }

    @JsonIgnore
    public Long getUserStoreActivationTime() {
        String activationTimeString = this.getInfo().get(PLUGIN_INFO_USERSTORE_ACTIVATION_TIME);
        return StringUtils.isNotBlank((String)activationTimeString) ? Long.valueOf(activationTimeString) : null;
    }

    @JsonIgnore
    public void setUserStoreActiveVersion(Long userstoreActiveVersion) {
        this.getInfo().put(PLUGIN_INFO_USERSTORE_ACTIVE_VERSION, userstoreActiveVersion == null ? null : Long.toString(userstoreActiveVersion));
    }

    @JsonIgnore
    public Long getUserStoreActiveVersion() {
        String activeVersionString = this.getInfo().get(PLUGIN_INFO_USERSTORE_ACTIVE_VERSION);
        return StringUtils.isNotBlank((String)activeVersionString) ? Long.valueOf(activeVersionString) : null;
    }

    @JsonIgnore
    public void setPluginCapabilities(String capabilities) {
        this.setCapabilities(PLUGIN_INFO_CAPABILITIES, capabilities);
    }

    @JsonIgnore
    public String getPluginCapabilities() {
        return this.getCapabilities(PLUGIN_INFO_CAPABILITIES);
    }

    @JsonIgnore
    public void setAdminCapabilities(String capabilities) {
        this.setCapabilities(RANGER_ADMIN_CAPABILITIES, capabilities);
    }

    @JsonIgnore
    public String getAdminCapabilities() {
        return this.getCapabilities(RANGER_ADMIN_CAPABILITIES);
    }

    @JsonIgnore
    private void setCapabilities(String optionName, String capabilities) {
        this.getInfo().put(optionName, capabilities == null ? null : capabilities);
    }

    @JsonIgnore
    private String getCapabilities(String optionName) {
        String capabilitiesString = this.getInfo().get(optionName);
        return StringUtils.isNotBlank((String)capabilitiesString) ? capabilitiesString : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPluginInfo={");
        sb.append("id={").append(this.id).append("} ");
        sb.append("createTime={").append(this.createTime).append("} ");
        sb.append("updateTime={").append(this.updateTime).append("} ");
        sb.append("serviceName={").append(this.serviceName).append("} ");
        sb.append("serviceType={").append(this.serviceType).append("} ");
        sb.append("serviceTypeDisplayName{").append(this.serviceTypeDisplayName).append("} ");
        sb.append("serviceDisplayName={").append(this.serviceDisplayName).append("} ");
        sb.append("hostName={").append(this.hostName).append("} ");
        sb.append("appType={").append(this.appType).append("} ");
        sb.append("ipAddress={").append(this.ipAddress).append("} ");
        sb.append("info={").append(this.info).append("} ");
        sb.append(" }");
        return sb;
    }
}

