/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import com.sun.jersey.api.client.ClientResponse;
import java.nio.channels.ClosedByInterruptException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRetriever;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRESTClientUserStoreRetriever
extends RangerUserStoreRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRESTClientUserStoreRetriever.class);

    public RangerRESTClientUserStoreRetriever(RangerRESTClient rangerRESTClient) {
        super(rangerRESTClient);
        this.init(null);
    }

    @Override
    public void init(Map<String, String> options) {
        if (this.rangerRESTClient == null) {
            LOG.error("FATAL: ranger rest client to retrieving userstore is null. Will NOT be able to retrieve userstore.");
        }
    }

    @Override
    public RangerUserStore retrieveUserStoreInfo(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore rangerUserStore = null;
        try {
            rangerUserStore = this.getUserStoreIfUpdated(lastKnownUserStoreVersion, lastActivationTimeInMillis);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            LOG.error("UserStore-retriever for raz thread was interrupted while blocked on I/O");
            throw new InterruptedException();
        }
        catch (Exception e) {
            LOG.error("UserStore-retriever for raz encounterd exception, exception=", (Throwable)e);
            LOG.error("Returning null userstore info");
        }
        return rangerUserStore;
    }

    private RangerUserStore getUserStoreIfUpdated(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore ret;
        RESTResponse resp;
        ClientResponse response;
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRESTClientUserStoreRetriever.getUserStoreIfUpdated(" + lastKnownUserStoreVersion + ", " + lastActivationTimeInMillis + ")");
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownUserStoreVersion", Long.toString(lastKnownUserStoreVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking UserStore updated as user : " + user);
            }
            queryParams.put("AUTH_TYPE", "KERBEROS");
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    String relativeURL = "/service/xusers/secure/download/";
                    try {
                        clientRes = RangerRESTClientUserStoreRetriever.this.rangerRESTClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientRes;
                }
            };
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking UserStore updated as user : " + user);
            }
            String relativeURL = "/service/xusers/secure/download/";
            response = this.rangerRESTClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error("Error getting UserStore; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user);
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No change in UserStore. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", lastKnownUserStoreVersion=" + lastKnownUserStoreVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = (RangerUserStore)response.getEntity(RangerUserStore.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error("Error getting UserStore; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", lastKnownUserStoreVersion=" + lastKnownUserStoreVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis);
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            LOG.warn("Received 404 error code with body:[" + exceptionMsg + "], Ignoring");
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn("Error getting UserStore. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp);
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRESTClientUserStoreRetriever.getUserStoreIfUpdated(" + lastKnownUserStoreVersion + ", " + lastActivationTimeInMillis + "): ");
        }
        return ret;
    }
}

