/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.audit;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerMultiResourceAuditHandler
extends RangerDefaultAuditHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RangerMultiResourceAuditHandler.class);
    Collection<AuthzAuditEvent> auditEvents = new ArrayList<AuthzAuditEvent>();

    @Override
    public void logAuthzAudit(AuthzAuditEvent auditEvent) {
        this.auditEvents.add(auditEvent);
    }

    @Override
    public void logAuthzAudits(Collection<AuthzAuditEvent> auditEvents) {
        this.auditEvents.addAll(auditEvents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAudit() {
        try {
            boolean deniedExists = false;
            for (AuthzAuditEvent auditEvent : this.auditEvents) {
                if (auditEvent == null || auditEvent.getAccessResult() != 0) continue;
                deniedExists = true;
                break;
            }
            for (AuthzAuditEvent auditEvent : this.auditEvents) {
                if (deniedExists && auditEvent.getAccessResult() != 0) continue;
                super.logAuthzAudit(auditEvent);
            }
        }
        catch (Throwable t) {
            LOG.error("Error occured while writing audit log... ", t);
        }
        finally {
            this.auditEvents = new ArrayList<AuthzAuditEvent>();
        }
    }
}

