/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;

public class StringUtil {
    private static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT+0");

    public static boolean equals(String str1, String str2) {
        boolean ret = false;
        ret = str1 == null ? str2 == null : (str2 == null ? false : str1.equals(str2));
        return ret;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        boolean ret = false;
        ret = str1 == null ? str2 == null : (str2 == null ? false : str1.equalsIgnoreCase(str2));
        return ret;
    }

    public static boolean equals(Collection<String> set1, Collection<String> set2) {
        boolean ret = false;
        if (set1 == null) {
            ret = set2 == null;
        } else if (set2 == null) {
            ret = false;
        } else if (set1.size() == set2.size()) {
            ret = set1.containsAll(set2);
        }
        return ret;
    }

    public static boolean equalsIgnoreCase(Collection<String> set1, Collection<String> set2) {
        boolean ret = false;
        if (set1 == null) {
            ret = set2 == null;
        } else if (set2 == null) {
            ret = false;
        } else if (set1.size() == set2.size()) {
            int numFound = 0;
            for (String str1 : set1) {
                boolean str1Found = false;
                for (String str2 : set2) {
                    if (!StringUtil.equalsIgnoreCase(str1, str2)) continue;
                    str1Found = true;
                    break;
                }
                if (!str1Found) break;
                ++numFound;
            }
            ret = numFound == set1.size();
        }
        return ret;
    }

    public static boolean matches(String pattern, String str) {
        boolean ret = false;
        ret = pattern == null || str == null || pattern.isEmpty() || str.isEmpty() ? true : str.matches(pattern);
        return ret;
    }

    public static boolean contains(String str, String strToFind) {
        return str != null && strToFind != null && str.contains(strToFind);
    }

    public static boolean containsIgnoreCase(String str, String strToFind) {
        return str != null && strToFind != null && str.toLowerCase().contains(strToFind.toLowerCase());
    }

    public static boolean contains(String[] strArr, String str) {
        boolean ret = false;
        if (strArr != null && strArr.length > 0 && str != null) {
            String s;
            String[] stringArray = strArr;
            int n = stringArray.length;
            for (int i = 0; i < n && !(ret = StringUtil.equals(s = stringArray[i], str)); ++i) {
            }
        }
        return ret;
    }

    public static boolean containsIgnoreCase(String[] strArr, String str) {
        boolean ret = false;
        if (strArr != null && strArr.length > 0 && str != null) {
            String s;
            String[] stringArray = strArr;
            int n = stringArray.length;
            for (int i = 0; i < n && !(ret = StringUtil.equalsIgnoreCase(s = stringArray[i], str)); ++i) {
            }
        }
        return ret;
    }

    public static String toString(Iterable<String> iterable) {
        String ret = "";
        if (iterable != null) {
            int count = 0;
            for (String str : iterable) {
                ret = count == 0 ? str : ret + ", " + str;
                ++count;
            }
        }
        return ret;
    }

    public static String toString(String[] arr) {
        String ret = "";
        if (arr != null && arr.length > 0) {
            ret = arr[0];
            for (int i = 1; i < arr.length; ++i) {
                ret = ret + ", " + arr[i];
            }
        }
        return ret;
    }

    public static String toString(List<String> arr) {
        String ret = "";
        if (arr != null && !arr.isEmpty()) {
            ret = arr.get(0);
            for (int i = 1; i < arr.size(); ++i) {
                ret = ret + ", " + arr.get(i);
            }
        }
        return ret;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static <T> boolean isEmpty(Collection<T> set) {
        return set == null || set.isEmpty();
    }

    public static String toLower(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static byte[] getBytes(String str) {
        return str == null ? null : str.getBytes();
    }

    public static Date getUTCDate() {
        Calendar local = Calendar.getInstance();
        int offset = local.getTimeZone().getOffset(local.getTimeInMillis());
        GregorianCalendar utc = new GregorianCalendar(gmtTimeZone);
        utc.setTimeInMillis(local.getTimeInMillis());
        utc.add(14, -offset);
        return utc.getTime();
    }

    public static Date getUTCDateForLocalDate(Date date) {
        Calendar local = Calendar.getInstance();
        int offset = local.getTimeZone().getOffset(local.getTimeInMillis());
        GregorianCalendar utc = new GregorianCalendar(gmtTimeZone);
        utc.setTimeInMillis(date.getTime());
        utc.add(14, -offset);
        return utc.getTime();
    }

    public static Map<String, Object> toStringObjectMap(Map<String, String> map) {
        HashMap<String, String> ret = null;
        if (map != null) {
            ret = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> e : map.entrySet()) {
                ret.put(e.getKey(), e.getValue());
            }
        }
        return ret;
    }

    public static Set<String> toSet(String str) {
        HashSet<String> values = new HashSet<String>();
        if (StringUtils.isNotBlank((String)str)) {
            for (String item : str.split(",")) {
                if (!StringUtils.isNotBlank((String)item)) continue;
                values.add(StringUtils.trim((String)item));
            }
        }
        return values;
    }

    public static List<String> toList(String str) {
        List<String> values;
        if (StringUtils.isNotBlank((String)str)) {
            values = new ArrayList();
            for (String item : str.split(",")) {
                if (!StringUtils.isNotBlank((String)item)) continue;
                values.add(StringUtils.trim((String)item));
            }
        } else {
            values = Collections.emptyList();
        }
        return values;
    }

    public static List<String> getURLs(String configURLs) {
        ArrayList<String> configuredURLs = new ArrayList<String>();
        if (configURLs != null) {
            String[] urls;
            for (String strUrl : urls = configURLs.split(",")) {
                if (StringUtils.isEmpty((String)StringUtils.trimToEmpty((String)strUrl))) continue;
                if (strUrl.endsWith("/")) {
                    strUrl = strUrl.substring(0, strUrl.length() - 1);
                }
                configuredURLs.add(strUrl);
            }
        }
        return configuredURLs;
    }

    public static Map<String, Map<String, String>> dedupStringsMapOfMap(Map<String, Map<String, String>> value, Map<String, String> strTbl) {
        Map<String, Map<String, String>> ret;
        if (MapUtils.isNotEmpty(value)) {
            ret = new HashMap<String, Map<String, String>>(value.size());
            for (Map.Entry<String, Map<String, String>> entry : value.entrySet()) {
                ret.put(StringUtil.dedupString(entry.getKey(), strTbl), StringUtil.dedupStringsMap(entry.getValue(), strTbl));
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static Map<String, Set<String>> dedupStringsMapOfSet(Map<String, Set<String>> value, Map<String, String> strTbl) {
        Map<String, Set<String>> ret;
        if (MapUtils.isNotEmpty(value)) {
            ret = new HashMap<String, Set<String>>(value.size());
            for (Map.Entry<String, Set<String>> entry : value.entrySet()) {
                ret.put(StringUtil.dedupString(entry.getKey(), strTbl), StringUtil.dedupStringsSet(entry.getValue(), strTbl));
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static Map<String, List<String>> dedupStringsMapOfList(Map<String, List<String>> value, Map<String, String> strTbl) {
        Map<String, List<String>> ret;
        if (MapUtils.isNotEmpty(value)) {
            ret = new HashMap<String, List<String>>(value.size());
            for (Map.Entry<String, List<String>> entry : value.entrySet()) {
                ret.put(StringUtil.dedupString(entry.getKey(), strTbl), StringUtil.dedupStringsList(entry.getValue(), strTbl));
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static HashMap<String, List<String>> dedupStringsHashMapOfList(HashMap<String, List<String>> value, Map<String, String> strTbl) {
        HashMap<String, List<String>> ret;
        if (MapUtils.isNotEmpty(value)) {
            ret = new HashMap(value.size());
            for (Map.Entry<String, List<String>> entry : value.entrySet()) {
                ret.put(StringUtil.dedupString(entry.getKey(), strTbl), StringUtil.dedupStringsList(entry.getValue(), strTbl));
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static Map<String, Object> dedupStringsMapOfObject(Map<String, Object> value, Map<String, String> strTbl) {
        Map<String, Object> ret;
        if (MapUtils.isNotEmpty(value)) {
            ret = new HashMap<String, Object>(value.size());
            for (Map.Entry<String, Object> entry : value.entrySet()) {
                ret.put(StringUtil.dedupString(entry.getKey(), strTbl), entry.getValue());
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static Map<String, RangerPolicy.RangerPolicyResource> dedupStringsMapOfPolicyResource(Map<String, RangerPolicy.RangerPolicyResource> value, Map<String, String> strTbl) {
        Map<String, RangerPolicy.RangerPolicyResource> ret;
        if (MapUtils.isNotEmpty(value)) {
            ret = new HashMap<String, RangerPolicy.RangerPolicyResource>(value.size());
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : value.entrySet()) {
                RangerPolicy.RangerPolicyResource resource = entry.getValue();
                resource.dedupStrings(strTbl);
                ret.put(StringUtil.dedupString(entry.getKey(), strTbl), resource);
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static Map<String, String> dedupStringsMap(Map<String, String> value, Map<String, String> strTbl) {
        Map<String, String> ret;
        if (MapUtils.isNotEmpty(value)) {
            ret = new HashMap<String, String>(value.size());
            for (Map.Entry<String, String> entry : value.entrySet()) {
                ret.put(StringUtil.dedupString(entry.getKey(), strTbl), StringUtil.dedupString(entry.getValue(), strTbl));
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static Set<String> dedupStringsSet(Set<String> value, Map<String, String> strTbl) {
        Set<String> ret;
        if (CollectionUtils.isNotEmpty(value)) {
            ret = new HashSet<String>(value.size());
            for (String val : value) {
                ret.add(StringUtil.dedupString(val, strTbl));
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static List<String> dedupStringsList(List<String> value, Map<String, String> strTbl) {
        List<String> ret;
        if (CollectionUtils.isNotEmpty(value)) {
            ret = new ArrayList<String>(value.size());
            for (String val : value) {
                ret.add(StringUtil.dedupString(val, strTbl));
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static Collection<String> dedupStringsCollection(Collection<String> value, Map<String, String> strTbl) {
        Collection<String> ret;
        if (CollectionUtils.isNotEmpty(value)) {
            ret = value instanceof Set ? new HashSet(value.size()) : new ArrayList(value.size());
            for (String val : value) {
                ret.add(StringUtil.dedupString(val, strTbl));
            }
        } else {
            ret = value;
        }
        return ret;
    }

    public static String dedupString(String str, Map<String, String> strTbl) {
        String ret = str != null ? strTbl.putIfAbsent(str, str) : null;
        return ret == null ? str : ret;
    }
}

