/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpRequestRetryHandler;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;

public class SolrAppUtil {
    public static UpdateResponse addDocsToSolr(final SolrClient solrClient, final Collection<SolrInputDocument> docs) throws Exception {
        return MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<UpdateResponse>(){

            @Override
            public UpdateResponse run() throws Exception {
                return solrClient.add(docs);
            }
        });
    }

    public static HttpClient createHttpClient(ModifiableSolrParams params) {
        try (Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();){
            CloseableHttpClient httpClient;
            SolrHttpClientBuilder kb = krbBuild.getBuilder();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(HttpClientUtil.getSocketFactoryRegistryProvider().getSocketFactoryRegistry());
            cm.setMaxTotal(params.getInt("maxConnections", 10000));
            cm.setDefaultMaxPerRoute(params.getInt("maxConnectionsPerHost", 10000));
            cm.setValidateAfterInactivity(Integer.getInteger("validateAfterInactivity", 3000).intValue());
            HttpClientBuilder newHttpClientBuilder = HttpClientBuilder.create();
            newHttpClientBuilder.setConnectionManagerShared(false);
            ConnectionKeepAliveStrategy keepAliveStrat = (response, context) -> -1L;
            if (kb.getAuthSchemeRegistryProvider() != null) {
                newHttpClientBuilder.setDefaultAuthSchemeRegistry(kb.getAuthSchemeRegistryProvider().getAuthSchemeRegistry());
            }
            if (kb.getCookieSpecRegistryProvider() != null) {
                newHttpClientBuilder.setDefaultCookieSpecRegistry(kb.getCookieSpecRegistryProvider().getCookieSpecRegistry());
            }
            if (kb.getCredentialsProviderProvider() != null) {
                newHttpClientBuilder.setDefaultCredentialsProvider(kb.getCredentialsProviderProvider().getCredentialsProvider());
            }
            newHttpClientBuilder = newHttpClientBuilder.setKeepAliveStrategy(keepAliveStrat).evictIdleConnections((long)Integer.getInteger("evictIdleConnections", 50000).intValue(), TimeUnit.MILLISECONDS);
            HttpClientBuilder builder = SolrAppUtil.setupBuilder(newHttpClientBuilder, params);
            HttpRequestInterceptor bufferedEntityInterceptor = (request, context) -> {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
                    HttpEntity requestEntity = enclosingRequest.getEntity();
                    enclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity(requestEntity));
                }
            };
            builder.addInterceptorLast(bufferedEntityInterceptor);
            CloseableHttpClient closeableHttpClient = httpClient = builder.setConnectionManager((HttpClientConnectionManager)cm).build();
            return closeableHttpClient;
        }
    }

    private static HttpClientBuilder setupBuilder(HttpClientBuilder newHttpClientBuilder, ModifiableSolrParams config) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setRedirectsEnabled(config.getBool("followRedirects", false)).setDecompressionEnabled(false).setConnectTimeout(config.getInt("connTimeout", 60000)).setSocketTimeout(config.getInt("socketTimeout", 600000));
        String cPolicy = "solr-portaware";
        requestConfigBuilder.setCookieSpec(cPolicy);
        RequestConfig requestConfig = requestConfigBuilder.build();
        HttpClientBuilder retBuilder = newHttpClientBuilder.setDefaultRequestConfig(requestConfig);
        retBuilder = config.getBool("retry", true) ? retBuilder.setRetryHandler((HttpRequestRetryHandler)new SolrHttpRequestRetryHandler(Integer.getInteger("solr.httpclient.retries", 3).intValue())) : retBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        retBuilder.disableContentCompression();
        return retBuilder;
    }
}

