/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.client.AbstractRangerAuditMetricRESTClient;
import org.apache.ranger.audit.client.RangerAuditMetricRESTClient;
import org.apache.ranger.audit.model.RangerAuditMetrics;
import org.apache.ranger.audit.utils.RangerAuditConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuditMetricsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuditMetricsUtil.class);
    public static final String RANGER_ADMIN_URL = "ranger.plugin.%s.policy.rest.url";
    public static final String RANGER_ADMIN_SSL_CONFIG_FILENAME = "ranger.plugin.%s.policy.rest.ssl.config.file";
    public static final String RANGER_ADMIN_IMPL_CLASS_CONF = "ranger.plugin.%s.policy.source.impl";
    public static final String RANGER_SERVICE_TYPE_CONFIG = "ranger.plugin.serviceType";
    public static final String RANGER_ADMIM_IMPL_CLASS = "org.apache.ranger.admin.client.RangerAdminRESTClient";
    public static final String RANGER_ADMIM_IMPL_JERSEY2_CLASS = "org.apache.ranger.admin.client.RangerAdminJersey2RESTClient";
    public static final String RANGER_ADMIN_AUDIT_METRICS_JERSEY2_CLASS = "org.apache.ranger.admin.client.RangerAuditMetricsJersey2RESTClient";
    private Properties props = null;
    private Configuration auditConfig = null;
    private AbstractRangerAuditMetricRESTClient auditMetricRESTClient = null;

    public RangerAuditMetricsUtil(Properties props) {
        this.props = props;
        this.init(this.props);
    }

    private void init(Properties props) {
        this.auditConfig = RangerAuditConfig.getInstance().getConfig(props);
        this.auditMetricRESTClient = this.getRangerClient();
        if (this.auditMetricRESTClient == null) {
            LOG.error("Error create RangerAuditMetricRESTClient...Audit Metrics collection won't happen");
        }
    }

    private AbstractRangerAuditMetricRESTClient getRangerClient() {
        AbstractRangerAuditMetricRESTClient ret = null;
        String serviceType = this.auditConfig.get(RANGER_SERVICE_TYPE_CONFIG);
        String url = this.auditConfig.get(String.format(RANGER_ADMIN_URL, serviceType));
        String sslConfigFileName = this.auditConfig.get(String.format(RANGER_ADMIN_SSL_CONFIG_FILENAME, serviceType));
        String adminCls = this.auditConfig.get(String.format(RANGER_ADMIN_IMPL_CLASS_CONF, serviceType));
        if (adminCls.equals(RANGER_ADMIM_IMPL_CLASS)) {
            ret = new RangerAuditMetricRESTClient();
        } else if (adminCls.equals(RANGER_ADMIM_IMPL_JERSEY2_CLASS)) {
            try {
                Class<?> auditMetricRESTClientClass = Class.forName(RANGER_ADMIN_AUDIT_METRICS_JERSEY2_CLASS);
                ret = (AbstractRangerAuditMetricRESTClient)auditMetricRESTClientClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error("failed to instantiate policy source of type 'org.apache.ranger.admin.client.RangerAuditMetricsJersey2RESTClient", (Throwable)excp);
            }
        }
        if (ret != null) {
            ((AbstractRangerAuditMetricRESTClient)ret).init(url, sslConfigFileName, this.auditConfig);
        }
        return ret;
    }

    public RangerAuditMetrics createAuditMetrics(RangerAuditMetrics request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuditMetricsUtil.createAuditMetrics(" + request + ")");
        }
        if (this.auditMetricRESTClient == null) {
            throw new Exception("RangerAuditMetricRESTClient is null...Audit Metrics cannot be logged..");
        }
        RangerAuditMetrics ret = null;
        try {
            this.auditMetricRESTClient.createAuditMetrics(request);
        }
        catch (Exception e) {
            LOG.error("Error creating auditMetric: " + request, (Throwable)e);
        }
        return ret;
    }
}

