/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);
    private static final ThreadLocal<ObjectMapper> mapper = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };
    private static final ThreadLocal<Gson> gson = new ThreadLocal<Gson>(){

        @Override
        protected Gson initialValue() {
            return new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").create();
        }
    };

    public static ObjectMapper getMapper() {
        return mapper.get();
    }

    public static Map<String, String> jsonToMap(String jsonStr) throws Exception {
        Map<String, String> ret = jsonStr == null || jsonStr.isEmpty() ? new HashMap<String, String>() : (Map)JsonUtils.getMapper().readValue(jsonStr, (TypeReference)new TypeReference<Map<String, String>>(){});
        return ret;
    }

    public static String mapToJson(Map<?, ?> map) throws Exception {
        return JsonUtils.getMapper().writeValueAsString(map);
    }

    public static String listToJson(List<?> list) throws Exception {
        return JsonUtils.getMapper().writeValueAsString(list);
    }

    public static String objToJson(Serializable obj) throws Exception {
        return JsonUtils.getMapper().writeValueAsString((Object)obj);
    }

    public static <T> T jsonToObj(String json, Class<T> tClass) throws Exception {
        return (T)JsonUtils.getMapper().readValue(json, tClass);
    }

    public static String objectToJson(Object object) {
        String ret = null;
        if (object != null) {
            try {
                ret = gson.get().toJson(object);
            }
            catch (Exception excp) {
                LOG.warn("objectToJson() failed to convert object to Json", (Throwable)excp);
            }
        }
        return ret;
    }

    public static <T> T jsonToObject(String jsonStr, Class<T> clz) {
        Object ret = null;
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                ret = gson.get().fromJson(jsonStr, clz);
            }
            catch (Exception excp) {
                LOG.warn("jsonToObject() failed to convert json to object: " + jsonStr, (Throwable)excp);
            }
        }
        return (T)ret;
    }

    public static Map<String, String> jsonToMapStringString(String jsonStr) {
        Map ret = null;
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                Type mapType = new TypeToken<Map<String, String>>(){}.getType();
                ret = (Map)gson.get().fromJson(jsonStr, mapType);
            }
            catch (Exception excp) {
                LOG.warn("jsonToObject() failed to convert json to object: " + jsonStr, (Throwable)excp);
            }
        }
        return ret;
    }
}

