/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.model;

import java.io.Serializable;
import org.apache.ranger.audit.model.RangerAuditMetricsText;
import org.apache.ranger.audit.model.RangerBaseModelObject;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerAuditMetrics
extends RangerBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceType;
    private String serviceName;
    private String appId;
    private String clusterName;
    private String clientIP;
    private String throughPutUnit;
    private int numberOfAudits;
    private RangerAuditMetricsText metricsText;

    public RangerAuditMetrics() {
    }

    public RangerAuditMetrics(String serviceType, String serviceName, String appId, String clusterName, String clientIP, String throughPutUnit, int numberOfAudits, RangerAuditMetricsText metricsText) {
        this.setServiceType(serviceType);
        this.setServiceName(serviceName);
        this.setAppId(appId);
        this.setClusterName(clusterName);
        this.setclientIP(clientIP);
        this.setMetricsText(metricsText);
        this.setThroughPutUnit(throughPutUnit);
        this.setNumberOfAudits(numberOfAudits);
    }

    public void updateFrom(RangerAuditMetrics other) {
        super.updateFrom(other);
        this.setServiceType(other.getServiceType());
        this.setServiceName(other.getServiceName());
        this.setAppId(other.getAppId());
        this.setClusterName(other.getClusterName());
        this.setclientIP(other.getclientIP());
        this.setMetricsText(other.getMetricsText());
        this.setThroughPutUnit(other.getThroughPutUnit());
        this.setNumberOfAudits(other.getNumberOfAudits());
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getclientIP() {
        return this.clientIP;
    }

    public void setclientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getThroughPutUnit() {
        return this.throughPutUnit;
    }

    public void setThroughPutUnit(String throughPutUnit) {
        this.throughPutUnit = throughPutUnit;
    }

    public int getNumberOfAudits() {
        return this.numberOfAudits;
    }

    public void setNumberOfAudits(int numberOfAudits) {
        this.numberOfAudits = numberOfAudits;
    }

    public RangerAuditMetricsText getMetricsText() {
        return this.metricsText;
    }

    public void setMetricsText(RangerAuditMetricsText metricsText) {
        this.metricsText = metricsText;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAuditMetrics={ ");
        super.toString(sb);
        sb.append("serviceType={").append(this.serviceType).append("} ");
        sb.append("serviceName={").append(this.serviceName).append("} ");
        sb.append("appId={").append(this.appId).append("} ");
        sb.append("clusterName={").append(this.clusterName).append("} ");
        sb.append("clientIP={").append(this.clientIP).append("} ");
        sb.append("throughPutUnit={").append(this.throughPutUnit).append("} ");
        sb.append("numberOfAudits={").append(this.numberOfAudits).append("} ");
        sb.append("metricsText={").append(this.metricsText).append("} ");
        sb.append("numberOfAudits={").append(this.numberOfAudits).append("} ");
        sb.append("metricsText={").append(this.metricsText).append("} ");
        sb.append("}");
        return sb;
    }
}

