/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.credutils.CredentialsProviderUtil;
import org.apache.ranger.authorization.credutils.kerberos.KerberosCredentialsProvider;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchAuditDestination
extends AuditDestination {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchAuditDestination.class);
    public static final String CONFIG_URLS = "urls";
    public static final String CONFIG_PORT = "port";
    public static final String CONFIG_USER = "user";
    public static final String CONFIG_PWRD = "password";
    public static final String CONFIG_PROTOCOL = "protocol";
    public static final String CONFIG_INDEX = "index";
    public static final String CONFIG_PREFIX = "ranger.audit.opensearch";
    public static final String DEFAULT_INDEX = "ranger_audits";
    private String index = "index";
    private volatile RestHighLevelClient client = null;
    private String protocol;
    private String user;
    private int port;
    private String passwd;
    private String hosts;
    private Subject subject;
    private final AtomicLong lastLoggedAt = new AtomicLong(0L);

    public OpenSearchAuditDestination() {
        this.propPrefix = CONFIG_PREFIX;
    }

    @Override
    public void init(Properties props, String propPrefix) {
        super.init(props, propPrefix);
        this.protocol = this.getStringProperty(props, propPrefix + "." + CONFIG_PROTOCOL, "http");
        this.user = this.getStringProperty(props, propPrefix + "." + CONFIG_USER, "");
        this.passwd = this.getStringProperty(props, propPrefix + "." + CONFIG_PWRD, "");
        this.port = MiscUtil.getIntProperty(props, propPrefix + "." + CONFIG_PORT, 9200);
        this.index = this.getStringProperty(props, propPrefix + "." + CONFIG_INDEX, DEFAULT_INDEX);
        this.hosts = this.getHosts();
        LOG.info("Connecting to OpenSearch... " + this.connectionString());
        this.getClient();
    }

    private String connectionString() {
        return String.format(Locale.ROOT, "User:%s, %s://%s:%s/%s", this.user, this.protocol, this.hosts, this.port, this.index);
    }

    @Override
    public void stop() {
        super.stop();
        this.logStatus();
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        boolean ret = false;
        try {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            RestHighLevelClient client = this.getClient();
            if (null == client) {
                this.addDeferredCount(events.size());
                return ret;
            }
            ArrayList<AuditEventBase> eventList = new ArrayList<AuditEventBase>(events);
            BulkRequest bulkRequest = new BulkRequest();
            try {
                for (AuditEventBase event : eventList) {
                    AuthzAuditEvent authzEvent = (AuthzAuditEvent)event;
                    String id = authzEvent.getEventId();
                    Map<String, Object> doc = this.toDoc(authzEvent);
                    bulkRequest.add(new IndexRequest(this.index).id(id).source(doc));
                }
            }
            catch (Exception ex) {
                this.addFailedCount(eventList.size());
                this.logFailedEvent(eventList, (Throwable)ex);
            }
            BulkResponse response = client.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (response.status().getStatus() >= 400) {
                this.addFailedCount(eventList.size());
                this.logFailedEvent(eventList, "HTTP " + response.status().getStatus());
            } else {
                BulkItemResponse[] items = response.getItems();
                for (int i = 0; i < items.length; ++i) {
                    AuditEventBase itemRequest = eventList.get(i);
                    BulkItemResponse itemResponse = items[i];
                    if (itemResponse.isFailed()) {
                        this.addFailedCount(1);
                        this.logFailedEvent(Arrays.asList(itemRequest), itemResponse.getFailureMessage());
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Indexed %s", itemRequest.getEventKey()));
                    }
                    this.addSuccessCount(1);
                    ret = true;
                }
            }
        }
        catch (Throwable t) {
            this.addDeferredCount(events.size());
            this.logError("Error sending message to OpenSearch", t);
        }
        return ret;
    }

    @Override
    public void flush() {
    }

    public boolean isAsync() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized RestHighLevelClient getClient() {
        if (this.client == null) {
            Class<OpenSearchAuditDestination> clazz = OpenSearchAuditDestination.class;
            // MONITORENTER : org.apache.ranger.audit.destination.OpenSearchAuditDestination.class
            if (this.client == null) {
                this.client = this.newClient();
            }
            // MONITOREXIT : clazz
        }
        if (this.subject == null) return this.client;
        KerberosTicket ticket = CredentialsProviderUtil.getTGT((Subject)this.subject);
        try {
            if (new Date().getTime() > ticket.getEndTime().getTime()) {
                this.client = null;
                CredentialsProviderUtil.ticketExpireTime80 = 0L;
                this.newClient();
                return this.client;
            }
            if (CredentialsProviderUtil.ticketWillExpire((KerberosTicket)ticket) == false) return this.client;
            this.subject = CredentialsProviderUtil.login((String)this.user, (String)this.passwd);
            return this.client;
        }
        catch (PrivilegedActionException e) {
            LOG.error("PrivilegedActionException:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static RestClientBuilder getRestClientBuilder(String urls, String protocol, String user, String passwd, int port) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])((HttpHost[])MiscUtil.toArray(urls, ",").stream().map(x -> new HttpHost(x, port, protocol)).toArray(HttpHost[]::new)));
        ThreadFactory clientThreadFactory = new ThreadFactoryBuilder().setNameFormat("OpenSearch rest client %s").setDaemon(true).build();
        if (StringUtils.isNotBlank((String)user) && StringUtils.isNotBlank((String)passwd) && !user.equalsIgnoreCase("NONE") && !passwd.equalsIgnoreCase("NONE")) {
            if (passwd.contains("keytab") && new File(passwd).exists()) {
                KerberosCredentialsProvider credentialsProvider = CredentialsProviderUtil.getKerberosCredentials((String)user, (String)passwd);
                Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory()).build();
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> OpenSearchAuditDestination.lambda$getRestClientBuilder$2(clientThreadFactory, credentialsProvider, (Lookup)authSchemeRegistry, arg_0));
            } else {
                CredentialsProvider credentialsProvider = CredentialsProviderUtil.getBasicCredentials((String)user, (String)passwd);
                restClientBuilder.setHttpClientConfigCallback(clientBuilder -> {
                    clientBuilder.setThreadFactory(clientThreadFactory);
                    clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                    return clientBuilder;
                });
            }
        } else {
            LOG.error("OpenSearch Credentials not provided!!");
            CredentialsProvider credentialsProvider = null;
            restClientBuilder.setHttpClientConfigCallback(clientBuilder -> {
                clientBuilder.setThreadFactory(clientThreadFactory);
                clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                return clientBuilder;
            });
        }
        return restClientBuilder;
    }

    private RestHighLevelClient newClient() {
        try {
            if (StringUtils.isNotBlank((String)this.user) && StringUtils.isNotBlank((String)this.passwd) && this.passwd.contains("keytab") && new File(this.passwd).exists()) {
                this.subject = CredentialsProviderUtil.login((String)this.user, (String)this.passwd);
            }
            RestClientBuilder restClientBuilder = OpenSearchAuditDestination.getRestClientBuilder(this.hosts, this.protocol, this.user, this.passwd, this.port);
            RestHighLevelClient restHighLevelClient = new RestHighLevelClient(restClientBuilder);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized client");
            }
            boolean exits = false;
            try {
                exits = restHighLevelClient.indices().open(new OpenIndexRequest(new String[]{this.index}), RequestOptions.DEFAULT).isShardsAcknowledged();
            }
            catch (Exception e) {
                LOG.warn("Error validating index " + this.index);
            }
            if (exits) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Index exists");
                }
            } else {
                LOG.info("Index does not exist");
            }
            return restHighLevelClient;
        }
        catch (Throwable t) {
            this.lastLoggedAt.updateAndGet(lastLoggedAt -> {
                long now = System.currentTimeMillis();
                long elapsed = now - lastLoggedAt;
                if (elapsed > TimeUnit.MINUTES.toMillis(1L)) {
                    LOG.error("Can't connect to opensearch server: " + this.connectionString(), t);
                    return now;
                }
                return lastLoggedAt;
            });
            return null;
        }
    }

    private String getHosts() {
        String urls = MiscUtil.getStringProperty(this.props, this.propPrefix + "." + CONFIG_URLS);
        if (urls != null) {
            urls = urls.trim();
        }
        if ("NONE".equalsIgnoreCase(urls)) {
            urls = null;
        }
        return urls;
    }

    private String getStringProperty(Properties props, String propName, String defaultValue) {
        String value = MiscUtil.getStringProperty(props, propName);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    Map<String, Object> toDoc(AuthzAuditEvent auditEvent) {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        doc.put("id", auditEvent.getEventId());
        doc.put("access", auditEvent.getAccessType());
        doc.put("enforcer", auditEvent.getAclEnforcer());
        doc.put("agent", auditEvent.getAgentId());
        doc.put("repo", auditEvent.getRepositoryName());
        doc.put("sess", auditEvent.getSessionId());
        doc.put("reqUser", auditEvent.getUser());
        doc.put("reqData", auditEvent.getRequestData());
        doc.put("resource", auditEvent.getResourcePath());
        doc.put("cliIP", auditEvent.getClientIP());
        doc.put("logType", auditEvent.getLogType());
        doc.put("result", auditEvent.getAccessResult());
        doc.put("policy", auditEvent.getPolicyId());
        doc.put("repoType", auditEvent.getRepositoryType());
        doc.put("resType", auditEvent.getResourceType());
        doc.put("reason", auditEvent.getResultReason());
        doc.put("action", auditEvent.getAction());
        doc.put("evtTime", auditEvent.getEventTime());
        doc.put("seq_num", auditEvent.getSeqNum());
        doc.put("event_count", auditEvent.getEventCount());
        doc.put("event_dur_ms", auditEvent.getEventDurationMS());
        doc.put("tags", auditEvent.getTags());
        doc.put("cluster", auditEvent.getClusterName());
        doc.put("zoneName", auditEvent.getZoneName());
        doc.put("agentHost", auditEvent.getAgentHostname());
        doc.put("policyVersion", auditEvent.getPolicyVersion());
        return doc;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getRestClientBuilder$2(ThreadFactory clientThreadFactory, KerberosCredentialsProvider credentialsProvider, Lookup authSchemeRegistry, HttpAsyncClientBuilder clientBuilder) {
        clientBuilder.setThreadFactory(clientThreadFactory);
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        clientBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
        return clientBuilder;
    }
}

