/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.model.RangerAuditMetrics;
import org.apache.ranger.audit.model.RangerAuditMetricsText;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.JsonUtils;
import org.apache.ranger.audit.utils.RangerAuditMetricsUtil;
import org.apache.ranger.audit.utils.RollingTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAuditDestination
extends AuditDestination {
    private static final Logger logger = LoggerFactory.getLogger(MetricsAuditDestination.class);
    private static final String PROP_SERVICE_TYPE = "ranger.plugin.serviceType";
    private static final String PROP_RAZ_SERVICE_TYPE = "ranger.plugin.raz.serviceType";
    private static final String PROP_APP_ID = "ranger.plugin.appId";
    private static final String PROP_SERVICE_NAME = "ranger.plugin.%s.service.name";
    private static final String PROP_AUDIT_METRICS_LOGGING_PERIOD = "metrics.logging.period";
    private static final String AUDIT_METRICS_LOGGING_PERIOD_DEFAULT = "1m";
    private static final String AUDIT_METRICS_LOGGING_PERIOD_DEFAULT_STR = "PER MINUTE";
    private static final String PROP_RAZ_SERVICE_TYPE_ID = "raz";
    private RollingTimeUtil rollingTimeUtil = null;
    private RangerAuditMetricsUtil rangerAuditMetricsUtil = null;
    private String serviceName = null;
    private String serviceType = null;
    private String razServiceType = null;
    private String appId = null;
    private String metricLoggingPeriod = null;
    private String metricLoggingPeriodInStr = null;
    private Instant startTime = Instant.now();
    private long metricLoggingPeriodinMs = 0L;
    private int auditCount = 0;

    public MetricsAuditDestination() {
        logger.info("MetricsAuditDestination() called..");
    }

    @Override
    public void init(Properties props, String propPrefix) {
        super.init(props, propPrefix);
        this.rollingTimeUtil = RollingTimeUtil.getInstance();
        this.metricLoggingPeriod = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_AUDIT_METRICS_LOGGING_PERIOD);
        if (StringUtils.isBlank((String)this.metricLoggingPeriod)) {
            this.metricLoggingPeriod = AUDIT_METRICS_LOGGING_PERIOD_DEFAULT;
        }
        try {
            String computePeriod = this.rollingTimeUtil.getTimeLiteral(this.metricLoggingPeriod);
            int timeNumeral = this.rollingTimeUtil.getTimeNumeral(this.metricLoggingPeriod, computePeriod);
            this.metricLoggingPeriodinMs = this.rollingTimeUtil.getTimeInMilliSeconds(timeNumeral, computePeriod);
            this.metricLoggingPeriodInStr = this.rollingTimeUtil.getTimeString(timeNumeral, computePeriod);
        }
        catch (Exception e) {
            logger.error("Invalid logging period in Audit metrics...Using default period of 1 minute...");
            this.metricLoggingPeriodinMs = 60000L;
            this.metricLoggingPeriodInStr = AUDIT_METRICS_LOGGING_PERIOD_DEFAULT_STR;
        }
        this.rangerAuditMetricsUtil = new RangerAuditMetricsUtil(props);
        this.serviceType = props.getProperty(PROP_SERVICE_TYPE);
        this.serviceName = props.getProperty(String.format(PROP_SERVICE_NAME, this.serviceType));
        this.appId = props.getProperty(PROP_APP_ID);
        this.razServiceType = props.getProperty(PROP_RAZ_SERVICE_TYPE);
    }

    public void setRollingTimeUtil(RollingTimeUtil rollingTimeUtil) {
        this.rollingTimeUtil = rollingTimeUtil;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getRazServiceType() {
        return this.razServiceType;
    }

    public void setRazServiceType(String razServiceType) {
        this.razServiceType = razServiceType;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getAuditCount() {
        return this.auditCount;
    }

    public void setAuditCount(int auditCount) {
        this.auditCount = auditCount;
    }

    @Override
    public boolean log(AuditEventBase event) {
        try {
            if (event != null) {
                this.addAuditCount(1);
                if (this.checkIfThreshHoldReached()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Total number of Audits : " + this.auditCount + " " + this.metricLoggingPeriodInStr);
                    }
                    this.persistAuditMetrics(this.metricLoggingPeriodInStr, this.auditCount, event);
                    this.resetAuditMetricsCount();
                }
            }
        }
        catch (Exception e) {
            this.resetAuditMetricsCount();
            logger.error("Failed to log audit metrics....", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        try {
            if (CollectionUtils.isNotEmpty(events)) {
                this.addAuditCount(events.size());
                if (this.checkIfThreshHoldReached()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Total number of Audits : " + this.auditCount + " " + this.metricLoggingPeriodInStr);
                    }
                    this.persistAuditMetrics(this.metricLoggingPeriodInStr, this.auditCount, this.getSingleEvent(events));
                    this.resetAuditMetricsCount();
                }
            }
        }
        catch (Exception e) {
            this.resetAuditMetricsCount();
            logger.error("Failed to log audit metrics....", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean logJSON(String event) {
        try {
            if (event != null) {
                this.addAuditCount(1);
                if (this.checkIfThreshHoldReached()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Total number of Audits : " + this.auditCount + " " + this.metricLoggingPeriodInStr);
                    }
                    this.persistAuditMetrics(this.metricLoggingPeriodInStr, this.auditCount, this.getSingleEvent(event));
                    this.resetAuditMetricsCount();
                }
            }
        }
        catch (Exception e) {
            this.resetAuditMetricsCount();
            logger.error("Failed to log audit metrics....", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean logJSON(Collection<String> events) {
        try {
            if (CollectionUtils.isNotEmpty(events)) {
                this.addAuditCount(events.size());
                if (this.checkIfThreshHoldReached()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Total number of Audits : " + this.auditCount + " " + this.metricLoggingPeriodInStr);
                    }
                    this.persistAuditMetrics(this.metricLoggingPeriodInStr, this.auditCount, this.getSingleEventFromEvents(events));
                    this.resetAuditMetricsCount();
                }
            }
        }
        catch (Exception e) {
            this.resetAuditMetricsCount();
            logger.error("Failed to log audit metrics....", (Throwable)e);
        }
        return true;
    }

    private boolean checkIfThreshHoldReached() {
        boolean ret = false;
        Duration timeElapsed = Duration.between(this.startTime, Instant.now());
        if (logger.isDebugEnabled()) {
            logger.debug("TimeElapsed in MilliSec: " + timeElapsed.toMillis());
        }
        if (timeElapsed.toMillis() >= this.metricLoggingPeriodinMs) {
            ret = true;
        }
        return ret;
    }

    private void addAuditCount(int count) {
        this.auditCount += count;
    }

    private void persistAuditMetrics(String metricLogginPeriod, int auditCount, AuditEventBase event) throws Exception {
        RangerAuditMetrics rangerAuditMetrics = this.buildRangerAuditMetrics(metricLogginPeriod, auditCount, event);
        this.rangerAuditMetricsUtil.createAuditMetrics(rangerAuditMetrics);
    }

    private RangerAuditMetrics buildRangerAuditMetrics(String interval, int auditCount, AuditEventBase event) {
        RangerAuditMetrics ret = new RangerAuditMetrics();
        AuthzAuditEvent authzAuditEvent = (AuthzAuditEvent)event;
        ret.setServiceName(this.getServiceName());
        String serviceType = this.getServiceType();
        if (PROP_RAZ_SERVICE_TYPE_ID.equals(serviceType)) {
            serviceType = this.getRazServiceType();
        }
        ret.setServiceType(serviceType);
        ret.setAppId(this.getAppId());
        ret.setClusterName(authzAuditEvent.getClusterName());
        ret.setclientIP(this.getIPAddress(authzAuditEvent));
        ret.setThroughPutUnit(interval);
        ret.setNumberOfAudits(auditCount);
        RangerAuditMetricsText metricText = new RangerAuditMetricsText();
        HashMap<String, String> metricsData = new HashMap<String, String>();
        metricsData.put(interval, Integer.toString(auditCount));
        metricText.setMetrics(metricsData);
        ret.setMetricsText(metricText);
        return ret;
    }

    private AuditEventBase getSingleEvent(Collection<AuditEventBase> events) {
        Optional<AuditEventBase> auditEventBase = events.stream().findFirst();
        return auditEventBase.get();
    }

    private AuditEventBase getSingleEvent(String event) {
        return JsonUtils.jsonToObject(event, AuthzAuditEvent.class);
    }

    private AuditEventBase getSingleEventFromEvents(Collection<String> events) {
        Optional<String> auditEventBase = events.stream().findFirst();
        return JsonUtils.jsonToObject(auditEventBase.get(), AuthzAuditEvent.class);
    }

    private String getIPAddress(AuthzAuditEvent event) {
        String ret = event.getClientIP();
        if (StringUtils.isBlank((String)ret)) {
            try {
                InetAddress ip = InetAddress.getLocalHost();
                if (ip != null) {
                    ret = ip.getHostAddress();
                }
            }
            catch (Exception e) {
                ret = "";
            }
        }
        return ret;
    }

    private void resetAuditMetricsCount() {
        this.startTime = Instant.now();
        this.auditCount = 0;
    }
}

