/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.TokenRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPAuditDestination
extends AuditDestination {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPAuditDestination.class);
    public static final String PROP_HTTP_SERVER_URL = "xasecure.audit.destination.http.url";
    public static final String PROP_HTTP_USER_NAME = "xasecure.audit.destination.http.username";
    public static final String PROP_HTTP_USER_PASSWORD = "xasecure.audit.destination.http.password";
    public static final String PROP_HTTP_CLIENT_CONN_TIMEOUT_MS = "xasecure.audit.destination.http.connection.timeout.ms";
    public static final String PROP_HTTP_CLIENT_READ_TIMEOUT_MS = "xasecure.audit.destination.http.read.timeout.ms";
    public static final String PROP_HTTP_MAX_CONNECTION = "xasecure.audit.destination.http.max.connections";
    public static final String PROP_HTTP_MAX_CONNECTION_PER_HOST = "xasecure.audit.destination.http.max.connections.per.host";
    public static final String PROP_HTTP_VALIDATE_INACTIVE_MS = "xasecure.audit.destination.http.validate.inactivity.ms";
    public static final String PROP_HTTP_POOL_RETRY_COUNT = "xasecure.audit.destination.http.pool.retry.count";
    public static final String GSON_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String REST_ACCEPTED_MIME_TYPE_JSON = "application/json";
    public static final String REST_CONTENT_TYPE_MIME_TYPE_JSON = "application/json";
    public static final String REST_HEADER_ACCEPT = "Accept";
    public static final String REST_HEADER_CONTENT_TYPE = "Content-type";
    public static final String REST_RELATIVE_PATH_POST = "/api/audit/post";
    public static final String JWT_COOKIE_NAME_DEFAULT = "hadoop-jwt";
    public static final String RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS = "ranger.audit.auth.jwt.retriever.class";
    public static final String RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS_DEFAULT = "org.apache.ranger.audit.token.JwTokenRetrieverEnv";
    public static final String RANGER_PROP_JWT_SERVER_COOKIE_NAME = "ranger.audit.auth.jwt.server.cookie.name";
    public static final String RANGER_PROP_JWT_IGNOREIF_OTHER_AUTH_EXISTS = "ranger.audit.auth.jwt.ignoreif.other.auth.exists";
    public static final String RANGER_PROP_JWT_ENABLED = "ranger.audit.auth.jwt.enabled";
    public static final String RANGER_PROP_AUTH_TYPE = "AUTH_TYPE";
    public static final String RANGER_AUTH_TYPE_KERBEROS = "KERBEROS";
    public static final String RANGER_AUTH_TYPE_RAZ_DT = "RAZ-DT";
    public static final String RANGER_PROP_DT_OPERATION_TYPE = "DT_OPERATION_TYPE";
    public static final String RANGER_DT_OPERATION_TYPE_GET = "GETDELEGATIONTOKEN";
    public static final String RANGER_DT_OPERATION_TYPE_RENEW = "RENEWDELEGATIONTOKEN";
    public static final String RANGER_DT_OPERATION_TYPE_CANCEL = "CANCELDELEGATIONTOKEN";
    private static final String PROTOCOL_HTTPS = "https";
    private volatile CloseableHttpClient httpClient = null;
    private volatile Gson gsonBuilder = null;
    private TokenRetriever<String> tokenRetriever = null;
    private String jwtServerCookieName = null;
    private String httpURL = null;
    private boolean ignoreJwtIfAuthExists = false;

    @Override
    public void init(Properties props, String propPrefix) {
        LOG.info("==> HTTPAuditDestination:init()");
        super.init(props, propPrefix);
        this.httpClient = this.buildHTTPClient();
        this.gsonBuilder = new GsonBuilder().setDateFormat(GSON_DATE_FORMAT).create();
        boolean isJwtFetcherEnabled = MiscUtil.getBooleanProperty(props, RANGER_PROP_JWT_ENABLED, true);
        if (isJwtFetcherEnabled) {
            String clsName = MiscUtil.getStringProperty(props, RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS, RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS_DEFAULT);
            this.tokenRetriever = this.getJwtTokenRetriever(clsName);
            this.jwtServerCookieName = MiscUtil.getStringProperty(props, RANGER_PROP_JWT_SERVER_COOKIE_NAME, JWT_COOKIE_NAME_DEFAULT);
        } else {
            LOG.warn("HTTPAuditDestination.init(): Skipping JWT fetcher, use property 'ranger.audit.auth.jwt.enabled' to enable.");
        }
        this.ignoreJwtIfAuthExists = MiscUtil.getBooleanProperty(props, RANGER_PROP_JWT_IGNOREIF_OTHER_AUTH_EXISTS, this.ignoreJwtIfAuthExists);
        LOG.info("<== HTTPAuditDestination:init()");
    }

    @Override
    public void stop() {
        LOG.info("==> HTTPAuditDestination.stop() called..");
        this.logStatus();
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException ioe) {
                LOG.error("Error while closing httpclient in HTTPAuditDestination!", (Throwable)ioe);
            }
            finally {
                this.httpClient = null;
            }
        }
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        boolean ret = false;
        try {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            if (this.httpClient == null) {
                this.httpClient = this.buildHTTPClient();
                if (this.httpClient == null) {
                    this.addDeferredCount(events.size());
                    return ret;
                }
            }
            HashMap<String, String> queryParams = new HashMap<String, String>();
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            if (LOG.isDebugEnabled()) {
                LOG.debug("UserGroupInformation: " + ugi);
            }
            for (AuditEventBase event : events) {
                AuthzAuditEvent authzEvent = (AuthzAuditEvent)event;
                PrivilegedExceptionAction<String> action = this.getPrivilegedAction(REST_RELATIVE_PATH_POST, queryParams, authzEvent, String.class);
                this.executeAction(action, ugi);
                ret = true;
            }
        }
        catch (Throwable t) {
            this.addDeferredCount(events.size());
            this.logError("Error sending audit to HTTP Server", t);
        }
        return ret;
    }

    @Override
    public void flush() {
    }

    public boolean isAsync() {
        return true;
    }

    synchronized CloseableHttpClient buildHTTPClient() {
        PoolingHttpClientConnectionManager connectionManager;
        boolean isSSL;
        Registry authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, true)).build();
        HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authRegistry);
        String userName = MiscUtil.getStringProperty(this.props, PROP_HTTP_USER_NAME);
        String passWord = MiscUtil.getStringProperty(this.props, PROP_HTTP_USER_PASSWORD);
        int clientConnTimeOutMs = MiscUtil.getIntProperty(this.props, PROP_HTTP_CLIENT_CONN_TIMEOUT_MS, 1000);
        int clientReadTimeOutMs = MiscUtil.getIntProperty(this.props, PROP_HTTP_CLIENT_READ_TIMEOUT_MS, 1000);
        int maxConnections = MiscUtil.getIntProperty(this.props, PROP_HTTP_MAX_CONNECTION, 10);
        int maxConnectionsPerHost = MiscUtil.getIntProperty(this.props, PROP_HTTP_MAX_CONNECTION_PER_HOST, 10);
        int validateAfterInactivityMs = MiscUtil.getIntProperty(this.props, PROP_HTTP_VALIDATE_INACTIVE_MS, 1000);
        int poolRetryCount = MiscUtil.getIntProperty(this.props, PROP_HTTP_POOL_RETRY_COUNT, 5);
        this.httpURL = MiscUtil.getStringProperty(this.props, PROP_HTTP_SERVER_URL);
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>> Building apache HTTP client with configs={}");
        }
        try {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.isKerberosAuthenticated()) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(null));
            } else if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)passWord)) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, passWord));
            }
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        catch (Exception excp) {
            LOG.error("Exception while adding credentials, skipping setting credentials for client.", (Throwable)excp);
        }
        KeyManager[] kmList = this.getKeyManagers();
        TrustManager[] tmList = this.getTrustManagers();
        SSLContext sslContext = this.getSSLContext(kmList, tmList);
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
        }
        boolean bl = isSSL = this.httpURL != null && this.httpURL.contains("https://");
        if (isSSL) {
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register(PROTOCOL_HTTPS, (Object)sslsf).build();
            connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        } else {
            connectionManager = new PoolingHttpClientConnectionManager();
        }
        connectionManager.setMaxTotal(maxConnections);
        connectionManager.setDefaultMaxPerRoute(maxConnectionsPerHost);
        connectionManager.setValidateAfterInactivity(validateAfterInactivityMs);
        RequestConfig customizedRequestConfig = RequestConfig.custom().setCookieSpec("default").setConnectTimeout(clientConnTimeOutMs).setSocketTimeout(clientReadTimeOutMs).build();
        CloseableHttpClient httpClient = clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((HttpRequestRetryHandler)new AuditHTTPRetryHandler(poolRetryCount, true)).setDefaultRequestConfig(customizedRequestConfig).build();
        return httpClient;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.error("Error while closing file: [" + filename + "]", (Throwable)excp);
            }
        }
    }

    private <T> PrivilegedExceptionAction<T> getPrivilegedAction(String relativeUrl, Map<String, String> queryParams, Object postParam, Class<T> clazz) {
        return () -> this.executeHttpRequestPOST(relativeUrl, queryParams, postParam, clazz);
    }

    public <T> T executeHttpRequestPOST(String relativeUrl, Map<String, String> params, Object obj, Class<T> clazz) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==>  HTTPAuditDestination().executeHttpRequestPOST()");
        }
        T finalResponse = this.postAndParse(this.httpURL + relativeUrl, params, obj, clazz);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HTTPAuditDestination().executeHttpRequestPOST()");
        }
        return finalResponse;
    }

    public <T> T postAndParse(String url, Map<String, String> queryParams, Object obj, Class<T> clazz) throws Exception {
        HttpPost httpPost = new HttpPost(this.buildURI(url, queryParams));
        StringEntity entity = new StringEntity(this.gsonBuilder.toJson(obj));
        httpPost.setEntity((HttpEntity)entity);
        return this.executeAndParseResponse(httpPost, clazz, queryParams);
    }

    private <T extends HttpRequestBase, R> R executeAndParseResponse(T request, Class<R> responseClazz, Map<String, String> queryParams) throws Exception {
        R ret = null;
        CloseableHttpClient client = this.getCloseableHttpClient();
        if (client != null) {
            this.addCommonHeaders(request, queryParams);
            try (CloseableHttpResponse response = client.execute(request);){
                ret = this.parseResponse((HttpResponse)response, responseClazz);
            }
        } else {
            LOG.error("Cannot process request as Audit HTTPClient is null...");
        }
        return ret;
    }

    private <T extends HttpRequestBase> T addCommonHeaders(T t, Map<String, String> queryParams) {
        t.addHeader(REST_HEADER_ACCEPT, "application/json");
        t.setHeader(REST_HEADER_CONTENT_TYPE, "application/json");
        t = this.handleJwt(t, queryParams);
        return t;
    }

    private <T extends HttpRequestBase> T handleJwt(T t, Map<String, String> queryParams) {
        if (!(this.isDtOperation(queryParams) || this.ignoreJwtIfAuthExists && this.otherAuthCredExists(queryParams))) {
            if (this.tokenRetriever != null) {
                Optional<String> jwtOptional = this.tokenRetriever.retrieve();
                if (jwtOptional.isPresent()) {
                    StringBuffer jwtWithCookieName = new StringBuffer();
                    jwtWithCookieName.append(this.jwtServerCookieName);
                    jwtWithCookieName.append("=");
                    jwtWithCookieName.append(jwtOptional.get());
                    t.setHeader("Cookie", jwtWithCookieName.toString());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("HTTPAuditDestination.handleJwt(): Since JWTokenRetriver init failed, skipping JWT auth.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("HTTPAuditDestination.handleJwt(): Skipping JWT as required condition does not meet.");
            LOG.debug("HTTPAuditDestination.handleJwt(): [isDtOperation(queryParams)=" + this.isDtOperation(queryParams) + "], [ignoreJwtIfAuthExists=" + this.ignoreJwtIfAuthExists + "], [otherAuthCredExists(queryParams)=" + this.otherAuthCredExists(queryParams) + "]");
        }
        return t;
    }

    private <R> R parseResponse(HttpResponse response, Class<R> clazz) throws Exception {
        Object type = null;
        if (response != null) {
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus != 200) {
                String error = "Request failed : response= [+" + response + "], response.status= " + httpStatus;
                LOG.error(error);
                throw new Exception(error);
            }
        } else {
            String reponseError = "Received NULL response from server..";
            LOG.error(reponseError);
            throw new Exception(reponseError);
        }
        InputStream responseInputStream = response.getEntity().getContent();
        type = clazz.equals(String.class) ? IOUtils.toString((InputStream)responseInputStream, (Charset)Charset.defaultCharset()) : this.gsonBuilder.fromJson((Reader)new InputStreamReader(responseInputStream), clazz);
        responseInputStream.close();
        return (R)type;
    }

    private <T> T executeAction(PrivilegedExceptionAction<T> action, UserGroupInformation owner) throws Exception {
        Object ret = null;
        ret = owner != null ? owner.doAs(action) : (Object)action.run();
        return (T)ret;
    }

    private URI buildURI(String url, Map<String, String> queryParams) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null) {
            for (Map.Entry<String, String> param : queryParams.entrySet()) {
                builder.addParameter(param.getKey(), param.getValue());
            }
        }
        return builder.build();
    }

    boolean isKerberosAuthenticated() throws Exception {
        boolean status = false;
        try {
            UserGroupInformation loggedInUser = UserGroupInformation.getLoginUser();
            boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
            boolean hasKerberosCredentials = loggedInUser.hasKerberosCredentials();
            UserGroupInformation.AuthenticationMethod loggedInUserAuthMethod = loggedInUser.getAuthenticationMethod();
            status = isSecurityEnabled && hasKerberosCredentials && loggedInUserAuthMethod.equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
        }
        catch (IOException e) {
            throw new Exception("Failed to get authentication details.", e);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getCloseableHttpClient() {
        CloseableHttpClient client = this.httpClient;
        if (client == null) {
            HTTPAuditDestination hTTPAuditDestination = this;
            synchronized (hTTPAuditDestination) {
                client = this.httpClient;
                if (client == null) {
                    this.httpClient = client = this.buildHTTPClient();
                }
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList = null;
        String credentialProviderPath = MiscUtil.getStringProperty(this.props, "xasecure.policymgr.clientssl.keystore.credential.file");
        String keyStoreAlias = "sslKeyStore";
        String keyStoreFile = MiscUtil.getStringProperty(this.props, "xasecure.policymgr.clientssl.keystore");
        String keyStoreFilepwd = MiscUtil.getCredentialString(credentialProviderPath, keyStoreAlias);
        if (StringUtils.isNotEmpty((String)keyStoreFile) && StringUtils.isNotEmpty((String)keyStoreFilepwd)) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(keyStoreFile);
                if (in != null) {
                    String keyStoreType = MiscUtil.getStringProperty(this.props, "xasecure.policymgr.clientssl.keystore.type");
                    keyStoreType = StringUtils.isNotEmpty((String)keyStoreType) ? keyStoreType : "jks";
                    KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                    keyStore.load(in, keyStoreFilepwd.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(RANGER_SSL_KEYMANAGER_ALGO_TYPE);
                    keyManagerFactory.init(keyStore, keyStoreFilepwd.toCharArray());
                    kmList = keyManagerFactory.getKeyManagers();
                } else {
                    LOG.error("Unable to obtain keystore from file [" + keyStoreFile + "]");
                }
            }
            catch (KeyStoreException e) {
                LOG.error("Unable to obtain from KeyStore :" + e.getMessage(), (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("SSL algorithm is NOT available in the environment", (Throwable)e);
            }
            catch (CertificateException e) {
                LOG.error("Unable to obtain the requested certification ", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOG.error("Unable to find the necessary SSL Keystore Files", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Unable to read the necessary SSL Keystore Files", (Throwable)e);
            }
            catch (UnrecoverableKeyException e) {
                LOG.error("Unable to recover the key from keystore", (Throwable)e);
            }
            finally {
                this.close(in, keyStoreFile);
            }
        }
        return kmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] getTrustManagers() {
        TrustManager[] tmList = null;
        String credentialProviderPath = MiscUtil.getStringProperty(this.props, "xasecure.policymgr.clientssl.truststore.credential.file");
        String trustStoreAlias = "sslTrustStore";
        String trustStoreFile = MiscUtil.getStringProperty(this.props, "xasecure.policymgr.clientssl.truststore");
        String trustStoreFilepwd = MiscUtil.getCredentialString(credentialProviderPath, trustStoreAlias);
        if (StringUtils.isNotEmpty((String)trustStoreFile) && StringUtils.isNotEmpty((String)trustStoreFilepwd)) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(trustStoreFile);
                if (in != null) {
                    String trustStoreType = MiscUtil.getStringProperty(this.props, "xasecure.policymgr.clientssl.truststore.type");
                    trustStoreType = StringUtils.isNotEmpty((String)trustStoreType) ? trustStoreType : "jks";
                    KeyStore trustStore = KeyStore.getInstance(trustStoreType);
                    trustStore.load(in, trustStoreFilepwd.toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(RANGER_SSL_TRUSTMANAGER_ALGO_TYPE);
                    trustManagerFactory.init(trustStore);
                    tmList = trustManagerFactory.getTrustManagers();
                } else {
                    LOG.error("Unable to obtain truststore from file [" + trustStoreFile + "]");
                }
            }
            catch (KeyStoreException e) {
                LOG.error("Unable to obtain from KeyStore", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("SSL algorithm is NOT available in the environment :" + e.getMessage(), (Throwable)e);
            }
            catch (CertificateException e) {
                LOG.error("Unable to obtain the requested certification :" + e.getMessage(), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOG.error("Unable to find the necessary SSL TrustStore File:" + trustStoreFile, (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Unable to read the necessary SSL TrustStore Files :" + trustStoreFile, (Throwable)e);
            }
            finally {
                this.close(in, trustStoreFile);
            }
        }
        return tmList;
    }

    private SSLContext getSSLContext(KeyManager[] kmList, TrustManager[] tmList) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            if (sslContext != null) {
                sslContext.init(kmList, tmList, new SecureRandom());
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("SSL algorithm is not available in the environment", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOG.error("Unable to initialise the SSLContext", (Throwable)e);
        }
        return sslContext;
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (StringUtils.isNotEmpty((String)fileName)) {
            File file = new File(fileName);
            in = file != null && file.exists() ? new FileInputStream(file) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private TokenRetriever<String> getJwtTokenRetriever(String clsName) {
        ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
        TokenRetriever ret = null;
        try {
            Configuration config = new Configuration();
            Class<?> cls = clsLoader.loadClass(clsName.trim());
            ret = (TokenRetriever)cls.getConstructor(Configuration.class).newInstance(config);
        }
        catch (Exception e) {
            LOG.error("AuditHTTPRetryHandler.getJwtTokenRetriever(): Failed to initialize JWT token retriever.", (Throwable)e);
        }
        return ret;
    }

    private boolean otherAuthCredExists(Map<String, String> queryParams) {
        String authType;
        boolean ret = false;
        if (queryParams != null && !queryParams.isEmpty() && StringUtils.isNotBlank((String)(authType = queryParams.get(RANGER_PROP_AUTH_TYPE)))) {
            ret = true;
        }
        return ret;
    }

    private boolean isDtOperation(Map<String, String> queryParams) {
        String authType;
        boolean ret = false;
        if (queryParams != null && !queryParams.isEmpty() && StringUtils.isNotBlank((String)(authType = queryParams.get(RANGER_PROP_DT_OPERATION_TYPE)))) {
            ret = true;
        }
        return ret;
    }

    private class AuditHTTPRetryHandler
    extends StandardHttpRequestRetryHandler {
        public AuditHTTPRetryHandler(Integer poolRetryCount, boolean isIdempotentRequest) {
            super(poolRetryCount.intValue(), isIdempotentRequest);
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AuditHTTPRetryHandler.retryRequest" + exception.getMessage() + "Execution Count = " + executionCount);
            }
            boolean ret = super.retryRequest(exception, executionCount, context);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AuditHTTPRetryHandler.retryRequest(): ret= " + ret);
            }
            return ret;
        }
    }
}

