/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.core.Cookie;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.audit.client.AbstractRangerAuditMetricRESTClient;
import org.apache.ranger.audit.client.RESTResponse;
import org.apache.ranger.audit.model.RangerAuditMetrics;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.token.TokenRetriever;
import org.apache.ranger.audit.utils.StringUtil;
import org.apache.ranger.authorization.hadoop.utils.RangerCredentialProvider;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuditMetricRESTClient
extends AbstractRangerAuditMetricRESTClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuditMetricRESTClient.class);
    public static final String RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS = "ranger.audit.auth.jwt.retriever.class";
    public static final String RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS_DEFAULT = "org.apache.ranger.audit.token.JwTokenRetrieverEnv";
    public static final String RANGER_PROP_JWT_SERVER_COOKIE_NAME = "ranger.audit.auth.jwt.server.cookie.name";
    public static final String RANGER_PROP_JWT_IGNOREIF_OTHER_AUTH_EXISTS = "ranger.audit.auth.jwt.ignoreif.other.auth.exists";
    public static final String RANGER_PROP_JWT_ENABLED = "ranger.audit.auth.jwt.enabled";
    public static final String RANGER_PROP_AUTH_TYPE = "AUTH_TYPE";
    public static final String RANGER_AUTH_TYPE_KERBEROS = "KERBEROS";
    public static final String RANGER_AUTH_TYPE_RAZ_DT = "RAZ-DT";
    public static final String RANGER_PROP_DT_OPERATION_TYPE = "DT_OPERATION_TYPE";
    public static final String RANGER_DT_OPERATION_TYPE_GET = "GETDELEGATIONTOKEN";
    public static final String RANGER_DT_OPERATION_TYPE_RENEW = "RENEWDELEGATIONTOKEN";
    public static final String RANGER_DT_OPERATION_TYPE_CANCEL = "CANCELDELEGATIONTOKEN";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE = "xasecure.policymgr.clientssl.keystore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE = "xasecure.policymgr.clientssl.keystore.type";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.keystore.credential.file";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS = "sslKeyStore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE = "xasecure.policymgr.clientssl.truststore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE = "xasecure.policymgr.clientssl.truststore.type";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.truststore.credential.file";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS = "sslTrustStore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String JWT_COOKIE_NAME_DEFAULT = "hadoop-jwt";
    public static final String REST_URL_CREATE_AUDIT_METRICS = "/service/audit/metrics";
    public static final String RANGER_PROP_SERVICE_TYPE = "ranger.plugin.serviceType";
    public static final String RANGER_PROP_CLIENT_CONNECTION_TIMEOUT_MS = "ranger.plugin.%s.policy.rest.client.connection.timeoutMs";
    public static final String RANGER_PROP_CLIENT_READ_TIMEOUT_MS = "ranger.plugin.%s.policy.rest.client.read.timeoutMs";
    public static final String RANGER_PROP_CLIENT_MAX_RETRY_ATTEMPTS = "ranger.plugin.%s.policy.rest.client.max.retry.attempts";
    public static final String RANGER_PROP_CLIENT_RETRY_INTERVAL_MS = "ranger.plugin.%s.policy.rest.client.retry.interval.ms";
    public static final String RANGER_SSL_KEYMANAGER_ALGO_TYPE = KeyManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_TRUSTMANAGER_ALGO_TYPE = TrustManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_CONTEXT_ALGO_TYPE = "TLS";
    public static final String REST_EXPECTED_MIME_TYPE = "application/json";
    public static final String REST_MIME_TYPE_JSON = "application/json";
    private String mUrl;
    private String mSslConfigFileName;
    private String mUsername;
    private String mPassword;
    private boolean mIsSSL;
    private String mKeyStoreURL;
    private String mKeyStoreAlias;
    private String mKeyStoreFile;
    private String mKeyStoreType;
    private String mTrustStoreURL;
    private String mTrustStoreAlias;
    private String mTrustStoreFile;
    private String mTrustStoreType;
    private String serviceType;
    private Gson gsonBuilder;
    private int mRestClientConnTimeOutMs;
    private int mRestClientReadTimeOutMs;
    private int maxRetryAttempts;
    private int retryIntervalMs;
    private int lastKnownActiveUrlIndex;
    private List<String> configuredURLs;
    private volatile Client client;
    private TokenRetriever<String> tokenRetriever = null;
    private String jwtServerCookieName;
    private boolean ignoreJwtIfAuthExists = false;

    @Override
    public void init(String url, String sslConfigFileName, Configuration config) {
        this.mUrl = url;
        this.mSslConfigFileName = sslConfigFileName;
        this.configuredURLs = StringUtil.getURLs(this.mUrl);
        this.setLastKnownActiveUrlIndex(new Random().nextInt(this.getConfiguredURLs().size()));
        this.serviceType = config.get(RANGER_PROP_SERVICE_TYPE);
        this.mRestClientConnTimeOutMs = config.getInt(String.format(RANGER_PROP_CLIENT_CONNECTION_TIMEOUT_MS, this.serviceType), 120000);
        this.mRestClientReadTimeOutMs = config.getInt(String.format(RANGER_PROP_CLIENT_READ_TIMEOUT_MS, this.serviceType), 30000);
        this.maxRetryAttempts = config.getInt(String.format(RANGER_PROP_CLIENT_MAX_RETRY_ATTEMPTS, this.serviceType), 3);
        this.retryIntervalMs = config.getInt(String.format(RANGER_PROP_CLIENT_RETRY_INTERVAL_MS, this.serviceType), 1000);
        this.init(config);
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getRestClientConnTimeOutMs() {
        return this.mRestClientConnTimeOutMs;
    }

    public void setRestClientConnTimeOutMs(int mRestClientConnTimeOutMs) {
        this.mRestClientConnTimeOutMs = mRestClientConnTimeOutMs;
    }

    public int getRestClientReadTimeOutMs() {
        return this.mRestClientReadTimeOutMs;
    }

    public void setRestClientReadTimeOutMs(int mRestClientReadTimeOutMs) {
        this.mRestClientReadTimeOutMs = mRestClientReadTimeOutMs;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public int getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    public void setRetryIntervalMs(int retryIntervalMs) {
        this.retryIntervalMs = retryIntervalMs;
    }

    public void setBasicAuthInfo(String username, String password) {
        this.mUsername = username;
        this.mPassword = password;
    }

    public WebResource getResource(String relativeUrl) {
        WebResource ret = this.getClient().resource(this.getUrl() + relativeUrl);
        return ret;
    }

    public String toJson(Object obj) {
        return this.gsonBuilder.toJson(obj);
    }

    public <T> T fromJson(String json, Class<T> cls) {
        return (T)this.gsonBuilder.fromJson(json, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient() {
        Client result = this.client;
        if (result == null) {
            RangerAuditMetricRESTClient rangerAuditMetricRESTClient = this;
            synchronized (rangerAuditMetricRESTClient) {
                result = this.client;
                if (result == null) {
                    this.client = result = this.buildClient();
                }
            }
        }
        return result;
    }

    private Client buildClient() {
        Client client = null;
        if (this.mIsSSL) {
            KeyManager[] kmList = this.getKeyManagers();
            TrustManager[] tmList = this.getTrustManagers();
            SSLContext sslContext = this.getSSLContext(kmList, tmList);
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return session.getPeerHost().equals(urlHostName);
                }
            };
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, sslContext));
            client = Client.create((ClientConfig)config);
        }
        if (client == null) {
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            client = Client.create((ClientConfig)config);
        }
        if (StringUtils.isNotEmpty((String)this.mUsername) && StringUtils.isNotEmpty((String)this.mPassword)) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.mUsername, this.mPassword));
        }
        client.setConnectTimeout(Integer.valueOf(this.mRestClientConnTimeOutMs));
        client.setReadTimeout(Integer.valueOf(this.mRestClientReadTimeOutMs));
        return client;
    }

    public void resetClient() {
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Configuration config) {
        boolean isJwtFetcherEnabled;
        try {
            this.gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
        }
        catch (Throwable excp) {
            LOG.error("RangerRESTClient.init(): failed to create GsonBuilder object", excp);
        }
        this.mIsSSL = this.isSsl(this.mUrl);
        if (this.mIsSSL) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(this.mSslConfigFileName);
                if (in != null) {
                    config.addResource(in);
                }
                this.mKeyStoreURL = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL);
                this.mKeyStoreAlias = RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS;
                this.mKeyStoreType = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE, "jks");
                this.mKeyStoreFile = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE);
                this.mTrustStoreURL = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL);
                this.mTrustStoreAlias = RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS;
                this.mTrustStoreType = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE, "jks");
                this.mTrustStoreFile = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE);
            }
            catch (IOException ioe) {
                LOG.error("Unable to load SSL Config FileName: [" + this.mSslConfigFileName + "]", (Throwable)ioe);
            }
            finally {
                this.close(in, this.mSslConfigFileName);
            }
        }
        if (isJwtFetcherEnabled = config.getBoolean(RANGER_PROP_JWT_ENABLED, true)) {
            this.tokenRetriever = this.getJwtTokenRetriever(config);
            this.jwtServerCookieName = config.get(RANGER_PROP_JWT_SERVER_COOKIE_NAME, JWT_COOKIE_NAME_DEFAULT);
        } else {
            LOG.warn("RangerAdminJersey2RESTClient.init(): Skipping JWT fetcher, use property 'ranger.audit.auth.jwt.enabled' to enable.");
        }
        this.ignoreJwtIfAuthExists = config.getBoolean(RANGER_PROP_JWT_IGNOREIF_OTHER_AUTH_EXISTS, this.ignoreJwtIfAuthExists);
    }

    private TokenRetriever<String> getJwtTokenRetriever(Configuration config) {
        String clsName = config.get(RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS, RANGER_PROP_JWT_TOKEN_RETRIEVER_CLASS_DEFAULT);
        ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
        TokenRetriever ret = null;
        try {
            Class<?> cls = clsLoader.loadClass(clsName.trim());
            ret = (TokenRetriever)cls.getConstructor(Configuration.class).newInstance(config);
        }
        catch (Exception e) {
            LOG.error("RangerAdminJersey2RESTClient.getJwtTokenRetriever(): Failed to initialize JWT token retriever.", (Throwable)e);
        }
        return ret;
    }

    private boolean isSsl(String url) {
        return !StringUtils.isEmpty((String)url) && url.toLowerCase().startsWith("https");
    }

    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList = null;
        String keyStoreFilepwd = this.getCredential(this.mKeyStoreURL, this.mKeyStoreAlias);
        kmList = this.getKeyManagers(this.mKeyStoreFile, keyStoreFilepwd);
        return kmList;
    }

    public KeyManager[] getKeyManagers(String keyStoreFile, String keyStoreFilePwd) {
        KeyManager[] kmList;
        block12: {
            kmList = null;
            if (StringUtils.isNotEmpty((String)keyStoreFile) && StringUtils.isNotEmpty((String)keyStoreFilePwd)) {
                InputStream in = null;
                try {
                    in = this.getFileInputStream(keyStoreFile);
                    if (in != null) {
                        KeyStore keyStore = KeyStore.getInstance(this.mKeyStoreType);
                        keyStore.load(in, keyStoreFilePwd.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(RANGER_SSL_KEYMANAGER_ALGO_TYPE);
                        keyManagerFactory.init(keyStore, keyStoreFilePwd.toCharArray());
                        kmList = keyManagerFactory.getKeyManagers();
                        break block12;
                    }
                    LOG.error("Unable to obtain keystore from file [" + keyStoreFile + "]");
                    throw new IllegalStateException("Unable to find keystore file :" + keyStoreFile);
                }
                catch (KeyStoreException e) {
                    LOG.error("Unable to obtain from KeyStore :" + e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("Unable to init keystore:" + e.getMessage(), e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is NOT available in the environment", (Throwable)e);
                    throw new IllegalStateException("SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    LOG.error("Unable to obtain the requested certification ", (Throwable)e);
                    throw new IllegalStateException("Unable to obtain the requested certification :" + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Unable to find the necessary SSL Keystore Files", (Throwable)e);
                    throw new IllegalStateException("Unable to find keystore file :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (IOException e) {
                    LOG.error("Unable to read the necessary SSL Keystore Files", (Throwable)e);
                    throw new IllegalStateException("Unable to read keystore file :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (UnrecoverableKeyException e) {
                    LOG.error("Unable to recover the key from keystore", (Throwable)e);
                    throw new IllegalStateException("Unable to recover the key from keystore :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                finally {
                    this.close(in, keyStoreFile);
                }
            }
        }
        return kmList;
    }

    private TrustManager[] getTrustManagers() {
        String trustStoreFilepwd;
        TrustManager[] tmList = null;
        if (StringUtils.isNotEmpty((String)this.mTrustStoreURL) && StringUtils.isNotEmpty((String)this.mTrustStoreAlias) && StringUtils.isNotEmpty((String)(trustStoreFilepwd = this.getCredential(this.mTrustStoreURL, this.mTrustStoreAlias)))) {
            tmList = this.getTrustManagers(this.mTrustStoreFile, trustStoreFilepwd);
        }
        return tmList;
    }

    public TrustManager[] getTrustManagers(String trustStoreFile, String trustStoreFilepwd) {
        TrustManager[] tmList;
        block11: {
            tmList = null;
            if (StringUtils.isNotEmpty((String)trustStoreFile) && StringUtils.isNotEmpty((String)trustStoreFilepwd)) {
                InputStream in = null;
                try {
                    in = this.getFileInputStream(trustStoreFile);
                    if (in != null) {
                        KeyStore trustStore = KeyStore.getInstance(this.mTrustStoreType);
                        trustStore.load(in, trustStoreFilepwd.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(RANGER_SSL_TRUSTMANAGER_ALGO_TYPE);
                        trustManagerFactory.init(trustStore);
                        tmList = trustManagerFactory.getTrustManagers();
                        break block11;
                    }
                    LOG.error("Unable to obtain truststore from file [" + trustStoreFile + "]");
                    throw new IllegalStateException("Unable to find truststore file :" + trustStoreFile);
                }
                catch (KeyStoreException e) {
                    LOG.error("Unable to obtain from KeyStore", (Throwable)e);
                    throw new IllegalStateException("Unable to init keystore:" + e.getMessage(), e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is NOT available in the environment :" + e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    LOG.error("Unable to obtain the requested certification :" + e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("Unable to obtain the requested certification :" + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Unable to find the necessary SSL TrustStore File:" + trustStoreFile, (Throwable)e);
                    throw new IllegalStateException("Unable to find trust store file :" + trustStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (IOException e) {
                    LOG.error("Unable to read the necessary SSL TrustStore Files :" + trustStoreFile, (Throwable)e);
                    throw new IllegalStateException("Unable to read the trust store file :" + trustStoreFile + ", error :" + e.getMessage(), e);
                }
                finally {
                    this.close(in, trustStoreFile);
                }
            }
        }
        return tmList;
    }

    protected SSLContext getSSLContext(KeyManager[] kmList, TrustManager[] tmList) {
        if (tmList == null) {
            try {
                String algo = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algo);
                tmf.init((KeyStore)null);
                tmList = tmf.getTrustManagers();
            }
            catch (IllegalStateException | KeyStoreException | NoSuchAlgorithmException e) {
                LOG.error("Unable to get the default SSL TrustStore for the JVM", (Throwable)e);
                tmList = null;
            }
        }
        Validate.notNull((Object)tmList, (String)"TrustManager is not specified");
        try {
            SSLContext sslContext = SSLContext.getInstance(RANGER_SSL_CONTEXT_ALGO_TYPE);
            sslContext.init(kmList, tmList, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("SSL algorithm is not available in the environment", (Throwable)e);
            throw new IllegalStateException("SSL algorithm is not available in the environment: " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            LOG.error("Unable to initials the SSLContext", (Throwable)e);
            throw new IllegalStateException("Unable to initials the SSLContex: " + e.getMessage(), e);
        }
    }

    private String getCredential(String url, String alias) {
        return RangerCredentialProvider.getInstance().getCredentialString(url, alias);
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (StringUtils.isNotEmpty((String)fileName)) {
            File f = new File(fileName);
            in = f.exists() ? new FileInputStream(f) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.error("Error while closing file: [" + filename + "]", (Throwable)excp);
            }
        }
    }

    @Override
    public RangerAuditMetrics createAuditMetrics(final RangerAuditMetrics request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAdminRESTClient.createAuditMetrics(" + request + ")");
        }
        RangerAuditMetrics ret = null;
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final String relativeURL = REST_URL_CREATE_AUDIT_METRICS;
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAuditMetricRESTClient.this.post(relativeURL, queryParams, request);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get response, Error is : " + e.getMessage());
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug("create createAuditMetrics as user " + user);
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.post(relativeURL, queryParams, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error("createAuditMetrics() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : ""));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during createAuditMetrics .AuditMetrics = " + request);
        }
        ret = (RangerAuditMetrics)response.getEntity(RangerAuditMetrics.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAdminRESTClient.createAuditMetrics(" + request + ")");
        }
        return ret;
    }

    public ClientResponse get(String relativeUrl, Map<String, String> params) throws Exception {
        ClientResponse finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int currentIndex = 0;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.configuredURLs.size();
                WebResource webResource = this.getClient().resource(this.configuredURLs.get(currentIndex) + relativeUrl);
                webResource = RangerAuditMetricRESTClient.setQueryParams(webResource, params);
                WebResource.Builder builder = this.handleJwt(webResource.getRequestBuilder(), params);
                finalResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.accept(new String[]{"application/json"})).type("application/json")).get(ClientResponse.class);
                if (finalResponse == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return finalResponse;
    }

    public ClientResponse get(String relativeUrl, Map<String, String> params, Cookie sessionId) throws Exception {
        ClientResponse finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int currentIndex = 0;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.configuredURLs.size();
                WebResource webResource = this.createWebResourceForCookieAuth(currentIndex, relativeUrl);
                webResource = RangerAuditMetricRESTClient.setQueryParams(webResource, params);
                WebResource.Builder builder = (WebResource.Builder)this.handleJwt(webResource.getRequestBuilder(), params).cookie(sessionId);
                finalResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.accept(new String[]{"application/json"})).type("application/json")).get(ClientResponse.class);
                if (finalResponse == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return finalResponse;
    }

    public ClientResponse post(String relativeUrl, Map<String, String> params, Object obj) throws Exception {
        ClientResponse finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int currentIndex = 0;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.configuredURLs.size();
                WebResource webResource = this.getClient().resource(this.configuredURLs.get(currentIndex) + relativeUrl);
                webResource = RangerAuditMetricRESTClient.setQueryParams(webResource, params);
                WebResource.Builder builder = this.handleJwt(webResource.getRequestBuilder(), params);
                finalResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.accept(new String[]{"application/json"})).type("application/json")).post(ClientResponse.class, (Object)this.toJson(obj));
                if (finalResponse == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return finalResponse;
    }

    protected static WebResource setQueryParams(WebResource webResource, Map<String, String> params) {
        WebResource ret = webResource;
        if (webResource != null && params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                ret = ret.queryParam(entry.getKey(), entry.getValue());
            }
        }
        return ret;
    }

    private WebResource.Builder handleJwt(WebResource.Builder builder, Map<String, String> queryParams) {
        if (!(this.isDtOperation(queryParams) || this.ignoreJwtIfAuthExists && this.otherAuthCredExists(queryParams))) {
            if (this.tokenRetriever != null) {
                Optional<String> jwtOptional = this.tokenRetriever.retrieve();
                if (jwtOptional.isPresent()) {
                    builder.cookie(new Cookie(this.jwtServerCookieName, jwtOptional.get()));
                }
            } else {
                LOG.warn("RangerAdminRESTClient.handleJwt(): Since JWTokenRetriver init failed, skipping JWT auth.");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("RangerAdminRESTClient.handleJwt(): Skipping JWT as required condition does not meet.");
            LOG.debug("RangerAdminRESTClient.handleJwt(): [isDtOperation(queryParams)=" + this.isDtOperation(queryParams) + "], [ignoreJwtIfAuthExists=" + this.ignoreJwtIfAuthExists + "], [otherAuthCredExists(queryParams)=" + this.otherAuthCredExists(queryParams) + "]");
        }
        return builder;
    }

    protected WebResource createWebResourceForCookieAuth(int currentIndex, String relativeURL) {
        Client cookieClient = this.getClient();
        cookieClient.removeAllFilters();
        WebResource ret = cookieClient.resource(this.configuredURLs.get(currentIndex) + relativeURL);
        return ret;
    }

    protected boolean shouldRetry(String currentUrl, int index, int retryAttemptCount, Exception ex) throws Exception {
        boolean ret;
        LOG.warn("Failed to communicate with Ranger Admin. URL: " + currentUrl + ". Error: " + ex.getMessage());
        boolean isLastUrl = index == this.configuredURLs.size() - 1;
        boolean bl = ret = isLastUrl && retryAttemptCount < this.maxRetryAttempts;
        if (ret) {
            LOG.warn("Waiting for " + this.retryIntervalMs + "ms before retry attempt #" + (retryAttemptCount + 1));
            try {
                Thread.sleep(this.retryIntervalMs);
            }
            catch (InterruptedException excp) {
                LOG.error("Failed while waiting to retry", (Throwable)excp);
            }
        } else if (isLastUrl) {
            LOG.error("Failed to communicate with all Ranger Admin's URL's : [ " + this.configuredURLs + " ]");
            throw ex;
        }
        return ret;
    }

    protected void setLastKnownActiveUrlIndex(int lastKnownActiveUrlIndex) {
        this.lastKnownActiveUrlIndex = lastKnownActiveUrlIndex;
    }

    public int getLastKnownActiveUrlIndex() {
        return this.lastKnownActiveUrlIndex;
    }

    public List<String> getConfiguredURLs() {
        return this.configuredURLs;
    }

    public boolean isSSL() {
        return this.mIsSSL;
    }

    public void setSSL(boolean mIsSSL) {
        this.mIsSSL = mIsSSL;
    }

    protected void setClient(Client client) {
        this.client = client;
    }

    protected void setKeyStoreType(String mKeyStoreType) {
        this.mKeyStoreType = mKeyStoreType;
    }

    protected void setTrustStoreType(String mTrustStoreType) {
        this.mTrustStoreType = mTrustStoreType;
    }

    private boolean otherAuthCredExists(Map<String, String> queryParams) {
        String authType;
        boolean ret = false;
        if (queryParams != null && !queryParams.isEmpty() && StringUtils.isNotBlank((String)(authType = queryParams.get(RANGER_PROP_AUTH_TYPE)))) {
            ret = true;
        }
        return ret;
    }

    private boolean isDtOperation(Map<String, String> queryParams) {
        String authType;
        boolean ret = false;
        if (queryParams != null && !queryParams.isEmpty() && StringUtils.isNotBlank((String)(authType = queryParams.get(RANGER_PROP_DT_OPERATION_TYPE)))) {
            ret = true;
        }
        return ret;
    }
}

