/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.classloader;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPluginClassLoaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPluginClassLoaderUtil.class);
    private static final String RANGER_PLUGIN_LIB_DIR = "ranger-%-plugin-impl";
    private static volatile RangerPluginClassLoaderUtil config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangerPluginClassLoaderUtil getInstance() {
        RangerPluginClassLoaderUtil result = config;
        if (result != null) return result;
        Class<RangerPluginClassLoaderUtil> clazz = RangerPluginClassLoaderUtil.class;
        synchronized (RangerPluginClassLoaderUtil.class) {
            result = config;
            if (result != null) return result;
            config = result = new RangerPluginClassLoaderUtil();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public URL[] getPluginFilesForServiceTypeAndPluginclass(String serviceType, Class<?> pluginClass) throws Exception {
        LOG.debug("==> RangerPluginClassLoaderUtil.getPluginFilesForServiceTypeAndPluginclass({}) Pluging Class :{}", (Object)serviceType, (Object)pluginClass.getName());
        String[] libDirs = new String[]{this.getPluginImplLibPath(serviceType, pluginClass)};
        URL[] ret = this.getPluginFiles(libDirs);
        LOG.debug("<== RangerPluginClassLoaderUtil.getPluginFilesForServiceTypeAndPluginclass({}) Pluging Class :{}", (Object)serviceType, (Object)pluginClass.getName());
        return ret;
    }

    private URL[] getPluginFiles(String[] libDirs) {
        LOG.debug("==> RangerPluginClassLoaderUtil.getPluginFiles()");
        ArrayList<URL> ret = new ArrayList<URL>();
        for (String libDir : libDirs) {
            this.getFilesInDirectory(libDir, ret);
        }
        LOG.debug("<== RangerPluginClassLoaderUtil.getPluginFilesForServiceType(): {} files", (Object)ret.size());
        return ret.toArray(new URL[0]);
    }

    /*
     * Unable to fully structure code
     */
    private void getFilesInDirectory(String dirPath, List<URL> files) {
        RangerPluginClassLoaderUtil.LOG.debug("==> RangerPluginClassLoaderUtil.getFilesInDirectory({})", (Object)dirPath);
        if (dirPath != null) {
            try {
                dirFiles = new File(dirPath).listFiles();
                if (dirFiles == null) ** GOTO lbl24
                for (File dirFile : dirFiles) {
                    try {
                        if (!dirFile.canRead() && RangerPluginClassLoaderUtil.LOG.isDebugEnabled()) {
                            RangerPluginClassLoaderUtil.LOG.debug("getFilesInDirectory('{}'): {} is not readable!", (Object)dirPath, (Object)dirFile.getAbsolutePath());
                        }
                        jarPath = dirFile.toURI().toURL();
                        if (RangerPluginClassLoaderUtil.LOG.isDebugEnabled()) {
                            RangerPluginClassLoaderUtil.LOG.debug("getFilesInDirectory('{}'): adding {}", (Object)dirPath, (Object)dirFile.getAbsolutePath());
                        }
                        files.add(jarPath);
                    }
                    catch (Exception excp) {
                        RangerPluginClassLoaderUtil.LOG.warn("getFilesInDirectory('{}'): failed to get URI for file {}", new Object[]{dirPath, dirFile.getAbsolutePath(), excp});
                    }
                }
            }
            catch (Exception excp) {
                RangerPluginClassLoaderUtil.LOG.warn("getFilesInDirectory('{}'): error", (Object)dirPath, (Object)excp);
            }
        } else {
            RangerPluginClassLoaderUtil.LOG.debug("getFilesInDirectory(dirPath=null, files={}): invalid dirPath - null", files);
        }
lbl24:
        // 4 sources

        RangerPluginClassLoaderUtil.LOG.debug("<== RangerPluginClassLoaderUtil.getFilesInDirectory({})", (Object)dirPath);
    }

    private String getPluginImplLibPath(String serviceType, Class<?> pluginClass) throws Exception {
        LOG.debug("==> RangerPluginClassLoaderUtil.getPluginImplLibPath for Class ({})", (Object)pluginClass.getName());
        URI uri = pluginClass.getProtectionDomain().getCodeSource().getLocation().toURI();
        Path path = Paths.get(URI.create(uri.toString()));
        String ret = path.getParent().toString() + File.separatorChar + RANGER_PLUGIN_LIB_DIR.replaceAll("%", serviceType);
        LOG.debug("<== RangerPluginClassLoaderUtil.getPluginImplLibPath for Class ({} PATH :{})", (Object)pluginClass.getName(), (Object)ret);
        return ret;
    }
}

