/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.ozone.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.ozone.client.OzoneClient;
import org.apache.ranger.services.ozone.client.OzoneConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneResourceMgr.class);
    private static final String VOLUME = "volume";
    private static final String BUCKET = "bucket";
    private static final String KEY = "key";

    private OzoneResourceMgr() {
        throw new UnsupportedOperationException("OzoneResourceMgr cannot be instantiated!");
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret;
        LOG.debug("==> OzoneResourceMgr.connectionTest ServiceName: {} Configs: {}", (Object)serviceName, configs);
        try {
            ret = OzoneClient.connectionTest(serviceName, configs);
        }
        catch (HadoopException e) {
            LOG.error("<== OzoneResourceMgr.connectionTest Error: ", (Throwable)e);
            throw e;
        }
        LOG.debug("<== OzoneResourceMgr.connectionTest Result : {}", ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getOzoneResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List keyList;
        List bucketList;
        List volumeList;
        List resultList;
        String userInput;
        block24: {
            userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            volumeList = null;
            bucketList = null;
            keyList = null;
            String volumePrefix = null;
            String bucketPrefix = null;
            String keyPrefix = null;
            LOG.debug("<== OzoneResourceMgr.getOzoneResources()  UserInput: {} resource: {} resourceMap: {}", new Object[]{userInput, resource, resourceMap});
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    volumeList = (List)resourceMap.get(VOLUME);
                    bucketList = (List)resourceMap.get(BUCKET);
                    keyList = (List)resourceMap.get(KEY);
                }
                switch (resource.trim().toLowerCase()) {
                    case "volume": {
                        volumePrefix = userInput;
                        break;
                    }
                    case "bucket": {
                        bucketPrefix = userInput;
                        break;
                    }
                    case "key": {
                        keyPrefix = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                try {
                    LOG.debug("==> OzoneResourceMgr.getOzoneResources() UserInput: {} configs: {} volumeList: {} bucketList: {}  keyList: {}", new Object[]{userInput, configs, volumeList, bucketList, keyList});
                    OzoneClient ozoneClient = new OzoneConnectionMgr().getOzoneConnection(serviceName, serviceType, configs);
                    Callable<List> callableObj = null;
                    List finalvolumeList = volumeList;
                    List finalbucketList = bucketList;
                    if (ozoneClient == null) break block24;
                    if (volumePrefix != null && !volumePrefix.isEmpty()) {
                        String finalVolPrefix = volumePrefix;
                        callableObj = () -> ozoneClient.getVolumeList(finalVolPrefix);
                    } else if (bucketPrefix != null && !bucketPrefix.isEmpty()) {
                        String finalBucketPrefix = bucketPrefix;
                        callableObj = () -> ozoneClient.getBucketList(finalBucketPrefix, finalvolumeList);
                    } else if (keyPrefix != null && !keyPrefix.isEmpty()) {
                        String finalKeyPrefix = keyPrefix;
                        callableObj = () -> ozoneClient.getKeyList(finalKeyPrefix, finalvolumeList, finalbucketList);
                    }
                    if (callableObj != null) {
                        OzoneClient ozoneClient2 = ozoneClient;
                        synchronized (ozoneClient2) {
                            resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                            break block24;
                        }
                    }
                    LOG.error("Could not initiate at timedTask");
                }
                catch (Exception e) {
                    LOG.error("Unable to get ozone resources.", (Throwable)e);
                    throw e;
                }
            }
        }
        LOG.debug("<== OzoneResourceMgr.getOzoneResources() UserInput: {} configs: {} volumeList: {} bucketList: {} keyList: {} Result: {}", new Object[]{userInput, configs, volumeList, bucketList, keyList, resultList});
        return resultList;
    }
}

