/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.ozone.client;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.ozone.client.OzoneClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneConnectionMgr {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneConnectionMgr.class);
    protected ConcurrentMap<String, OzoneClient> ozoneConnectionCache = new ConcurrentHashMap<String, OzoneClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public OzoneClient getOzoneConnection(String serviceName, String serviceType, Map<String, String> configs) {
        OzoneClient ozoneClient = null;
        if (serviceType != null) {
            ozoneClient = (OzoneClient)((Object)this.ozoneConnectionCache.get(serviceName));
            if (ozoneClient == null) {
                if (configs != null) {
                    Callable<OzoneClient> connectOzone = () -> new OzoneClient(serviceName, configs);
                    try {
                        ozoneClient = (OzoneClient)((Object)TimedEventUtil.timedTask(connectOzone, (long)5L, (TimeUnit)TimeUnit.SECONDS));
                    }
                    catch (Exception e) {
                        LOG.error("Error connecting ozone repository: {} using config: {}", new Object[]{serviceName, configs, e});
                    }
                    OzoneClient oldClient = ozoneClient != null ? this.ozoneConnectionCache.putIfAbsent(serviceName, ozoneClient) : (OzoneClient)((Object)this.ozoneConnectionCache.get(serviceName));
                    if (oldClient != null) {
                        if (ozoneClient != null) {
                            ozoneClient.close();
                        }
                        ozoneClient = oldClient;
                    }
                    this.repoConnectStatusMap.put(serviceName, true);
                } else {
                    String message = String.format("Connection Config not defined for asset: %s", serviceName);
                    LOG.error(message, (Throwable)new IllegalStateException(message));
                }
            } else {
                try {
                    ozoneClient.getVolumeList(null);
                }
                catch (Exception e) {
                    this.ozoneConnectionCache.remove(serviceName);
                    ozoneClient.close();
                    ozoneClient = this.getOzoneConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            String message = String.format("Asset not found with name: %s", serviceName);
            LOG.error(message, (Throwable)new IllegalStateException(message));
        }
        return ozoneClient;
    }
}

