/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.ozone.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.ranger.plugin.client.BaseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClient.class);
    private static final String ERR_MSG = "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private final OzoneConfiguration conf = new OzoneConfiguration();
    private org.apache.hadoop.ozone.client.OzoneClient ozoneClient;

    public OzoneClient(String serviceName, Map<String, String> connectionProperties) throws Exception {
        super(serviceName, connectionProperties, "ozone-client");
        Set rangerInternalPropertyKeys = this.getConfigHolder().getRangerInternalPropertyKeys();
        for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (rangerInternalPropertyKeys.contains(key) || value == null) continue;
            this.conf.set(key, value);
        }
        Subject.doAs(this.getLoginSubject(), () -> {
            String[] serviceIds = this.conf.getTrimmedStrings("ozone.om.service.ids", new String[]{"ozone1"});
            this.ozoneClient = OzoneClientFactory.getRpcClient((String)serviceIds[0], (ConfigurationSource)this.conf);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> connectionProperties) throws Exception {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        boolean connectivityStatus = false;
        try (OzoneClient connectionObj = null;){
            connectionObj = new OzoneClient(serviceName, connectionProperties);
            List<String> testResult = connectionObj.getVolumeList("");
            if (testResult != null && testResult.size() != 0) {
                connectivityStatus = true;
            }
            if (connectivityStatus) {
                String successMsg = "ConnectionTest Successful";
                OzoneClient.generateResponseDataMap((boolean)true, (String)successMsg, (String)successMsg, null, null, responseData);
            } else {
                String failureMsg = "Unable to retrieve any volumes using given parameters.";
                String errorMsg = failureMsg + ERR_MSG;
                OzoneClient.generateResponseDataMap((boolean)false, (String)failureMsg, (String)errorMsg, null, null, responseData);
            }
        }
        return responseData;
    }

    public void close() {
        try {
            this.ozoneClient.close();
        }
        catch (IOException e) {
            LOG.error("Unable to close Ozone Client connection", (Throwable)e);
        }
    }

    public List<String> getVolumeList(String volumePrefix) {
        LOG.debug("==> OzoneClient getVolume volumePrefix : {}", (Object)volumePrefix);
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Iterator ozoneVolList;
            if (this.ozoneClient != null && (ozoneVolList = this.ozoneClient.getObjectStore().listVolumes(volumePrefix)) != null) {
                while (ozoneVolList.hasNext()) {
                    ret.add(((OzoneVolume)ozoneVolList.next()).getName());
                }
            }
        }
        catch (IOException e) {
            LOG.error("Unable to get Volume List");
            LOG.debug("<== OzoneClient.getVolumeList() Error : ", (Throwable)e);
        }
        LOG.debug("<== OzoneClient.getVolumeList(): {}", ret);
        return ret;
    }

    public List<String> getBucketList(String bucketPrefix, List<String> finalVolumeList) {
        LOG.debug("==> OzoneClient getBucketList bucketPrefix : {}", (Object)bucketPrefix);
        ArrayList<String> ret = new ArrayList<String>();
        try {
            if (this.ozoneClient != null && finalVolumeList != null && !finalVolumeList.isEmpty()) {
                for (String ozoneVol : finalVolumeList) {
                    Iterator ozoneBucketList = this.ozoneClient.getObjectStore().getVolume(ozoneVol).listBuckets(bucketPrefix);
                    if (ozoneBucketList == null) continue;
                    while (ozoneBucketList.hasNext()) {
                        ret.add(((OzoneBucket)ozoneBucketList.next()).getName());
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error("Unable to get Volume List");
            LOG.debug("<== OzoneClient.getVolumeList() Error : ", (Throwable)e);
        }
        LOG.debug("<== OzoneClient.getVolumeList(): {}", ret);
        return ret;
    }

    public List<String> getKeyList(String keyPrefix, List<String> finalVolumeList, List<String> finalBucketList) {
        LOG.debug("==> OzoneClient getKeyList keyPrefix : {}", (Object)keyPrefix);
        ArrayList<String> ret = new ArrayList<String>();
        try {
            if (this.ozoneClient != null && finalVolumeList != null && !finalVolumeList.isEmpty()) {
                for (String ozoneVol : finalVolumeList) {
                    Iterator ozoneBucketIterator = this.ozoneClient.getObjectStore().getVolume(ozoneVol).listBuckets(null);
                    if (ozoneBucketIterator == null) continue;
                    while (ozoneBucketIterator.hasNext()) {
                        Iterator ozoneKeyIterator;
                        OzoneBucket currentBucket = (OzoneBucket)ozoneBucketIterator.next();
                        if (!finalBucketList.contains(currentBucket.getName()) || (ozoneKeyIterator = currentBucket.listKeys(keyPrefix)) == null) continue;
                        while (ozoneKeyIterator.hasNext()) {
                            ret.add(((OzoneKey)ozoneKeyIterator.next()).getName());
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error("Unable to get Volume List");
            LOG.debug("<== OzoneClient.getVolumeList() Error : ", (Throwable)e);
        }
        LOG.debug("<== OzoneClient.getVolumeList(): {}", ret);
        return ret;
    }
}

