/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.ozone.authorizer;

import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerOzoneAuthorizer
implements IAccessAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerOzoneAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "ozone";
    private static final String RANGER_OZONE_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.ozone.authorizer.RangerOzoneAuthorizer";
    private RangerPluginClassLoader rangerPluginClassLoader;
    private IAccessAuthorizer ozoneAuthorizationProviderImpl;

    public RangerOzoneAuthorizer() {
        LOG.debug("==> RangerOzoneAuthorizer.RangerOzoneAuthorizer()");
        this.init();
        LOG.debug("<== RangerOzoneAuthorizer.RangerOzoneAuthorizer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAccess(IOzoneObj ozoneObject, RequestContext context) throws OMException {
        LOG.debug("==> RangerOzoneAuthorizer.checkAccess()");
        try {
            this.activatePluginClassLoader();
            boolean bl = this.ozoneAuthorizationProviderImpl.checkAccess(ozoneObject, context);
            return bl;
        }
        finally {
            this.deactivatePluginClassLoader();
            LOG.debug("<== RangerOzoneAuthorizer.checkAccess()");
        }
    }

    private void init() {
        LOG.debug("==> RangerOzoneAuthorizer.init()");
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_OZONE_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.ozoneAuthorizationProviderImpl = (IAccessAuthorizer)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerOzonePlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        LOG.debug("<== RangerOzoneAuthorizer.init()");
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }
}

