/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.nestedstructure.authorizer;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.ranger.authorization.nestedstructure.authorizer.MaskingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordFilterJavaScript {
    private static final Logger logger = LoggerFactory.getLogger(RecordFilterJavaScript.class);
    private static final String NASHORN_POLYFILL_ARRAY_PROTOTYPE_INCLUDES = "if (!Array.prototype.includes) { Object.defineProperty(Array.prototype, 'includes', { value: function(valueToFind, fromIndex) { if (this == null) { throw new TypeError('\"this\" is null or not defined'); } var o = Object(this); var len = o.length >>> 0; if (len === 0) { return false; } var n = fromIndex | 0; var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0); function sameValueZero(x, y) { return x === y || (typeof x === 'number' && typeof y === 'number' && isNaN(x) && isNaN(y)); } while (k < len) { if (sameValueZero(o[k], valueToFind)) { return true; } k++; } return false; } }); }";

    private RecordFilterJavaScript() {
    }

    public static boolean filterRow(String user, String filterExpr, String jsonString) {
        SecurityFilter securityFilter = new SecurityFilter();
        if (securityFilter.containsMalware(filterExpr)) {
            throw new MaskingException("cannot process filter expression due to security concern \"this.engine\": " + filterExpr);
        }
        NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
        ScriptEngine engine = factory.getScriptEngine((ClassFilter)securityFilter);
        logger.debug("filterExpr: {}", (Object)filterExpr);
        String script = " jsonAttr = JSON.parse(jsonString); if (!Array.prototype.includes) { Object.defineProperty(Array.prototype, 'includes', { value: function(valueToFind, fromIndex) { if (this == null) { throw new TypeError('\"this\" is null or not defined'); } var o = Object(this); var len = o.length >>> 0; if (len === 0) { return false; } var n = fromIndex | 0; var k = Math.max(n >= 0 ? n : len - Math.abs(n), 0); function sameValueZero(x, y) { return x === y || (typeof x === 'number' && typeof y === 'number' && isNaN(x) && isNaN(y)); } while (k < len) { if (sameValueZero(o[k], valueToFind)) { return true; } k++; } return false; } }); } " + filterExpr;
        try {
            Bindings bindings = engine.createBindings();
            bindings.put("jsonString", (Object)jsonString);
            bindings.put("user", (Object)user);
            boolean hasAccess = (Boolean)engine.eval(script, bindings);
            logger.debug("row filter access={}", (Object)hasAccess);
            return hasAccess;
        }
        catch (Exception e) {
            throw new MaskingException("unable to properly evaluate filter expression: " + filterExpr, e);
        }
    }

    static class SecurityFilter
    implements ClassFilter {
        SecurityFilter() {
        }

        public boolean exposeToScripts(String s) {
            return false;
        }

        boolean containsMalware(String filterExpr) {
            return filterExpr.contains("this.engine");
        }
    }
}

