/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.nestedstructure.authorizer;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.nestedstructure.authorizer.AccessResult;
import org.apache.ranger.authorization.nestedstructure.authorizer.FieldLevelAccess;
import org.apache.ranger.authorization.nestedstructure.authorizer.JsonManipulator;
import org.apache.ranger.authorization.nestedstructure.authorizer.MaskingException;
import org.apache.ranger.authorization.nestedstructure.authorizer.NestedStructureAccessType;
import org.apache.ranger.authorization.nestedstructure.authorizer.NestedStructureAuditHandler;
import org.apache.ranger.authorization.nestedstructure.authorizer.NestedStructureResource;
import org.apache.ranger.authorization.nestedstructure.authorizer.RecordFilterJavaScript;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedStructureAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(NestedStructureAuthorizer.class);
    private static final String RANGER_CMT_SERVICETYPE = "nestedstructure";
    private static final String RANGER_CMT_APPID = "nestedstructure";
    private static volatile NestedStructureAuthorizer instance;
    private final RangerBasePlugin plugin;

    private NestedStructureAuthorizer() {
        this.plugin = new RangerBasePlugin("nestedstructure", "nestedstructure");
        this.plugin.init();
    }

    public NestedStructureAuthorizer(ServicePolicies policies, ServiceTags tags, RangerRoles roles) {
        RangerPolicyEngineOptions options = new RangerPolicyEngineOptions();
        options.disablePolicyRefresher = true;
        options.disableUserStoreRetriever = true;
        options.disableTagRetriever = true;
        RangerPluginConfig pluginConfig = new RangerPluginConfig("nestedstructure", policies.getServiceName(), "nestedstructure", null, null, options);
        this.plugin = new RangerBasePlugin(pluginConfig, policies, tags, roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NestedStructureAuthorizer getInstance() {
        NestedStructureAuthorizer ret = instance;
        if (ret != null) return ret;
        Class<NestedStructureAuthorizer> clazz = NestedStructureAuthorizer.class;
        synchronized (NestedStructureAuthorizer.class) {
            ret = instance;
            if (ret != null) return ret;
            instance = ret = new NestedStructureAuthorizer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessResult authorize(String schema, String user, Set<String> userGroups, String json, NestedStructureAccessType accessType) {
        AccessResult ret;
        NestedStructureAuditHandler auditHandler = new NestedStructureAuditHandler((Configuration)this.plugin.getConfig());
        try {
            ret = this.privateAuthorize(schema, user, userGroups, json, accessType, auditHandler);
        }
        catch (Exception e) {
            logger.warn("exception during processing, user: {}\n json: {}", new Object[]{user, json, e});
            ret = new AccessResult(false, null).addError(e);
        }
        finally {
            auditHandler.flushAudit();
        }
        return ret;
    }

    private AccessResult privateAuthorize(String schema, String user, Set<String> userGroups, String json, NestedStructureAccessType accessType, NestedStructureAuditHandler auditHandler) {
        AccessResult ret;
        if (!this.hasAccessToSchemaOrAnyField(schema, user, userGroups, accessType, auditHandler)) {
            ret = new AccessResult(false, null);
        } else if (!this.hasAccessToRecord(schema, user, userGroups, json, accessType, auditHandler)) {
            ret = new AccessResult(false, null);
        } else {
            boolean accessDenied = false;
            JsonManipulator jsonManipulator = new JsonManipulator(json);
            ArrayList<FieldLevelAccess> fieldResults = new ArrayList<FieldLevelAccess>();
            for (String field : jsonManipulator.getFields()) {
                FieldLevelAccess fieldAccess = this.hasFieldAccess(schema, user, userGroups, field, accessType, auditHandler);
                fieldResults.add(fieldAccess);
                if (fieldAccess.hasAccess) continue;
                accessDenied = true;
                break;
            }
            if (accessDenied) {
                ret = new AccessResult(false, null);
            } else {
                jsonManipulator.maskFields(fieldResults);
                ret = new AccessResult(true, jsonManipulator.getJsonString());
            }
        }
        return ret;
    }

    private FieldLevelAccess hasFieldAccess(String schema, String user, Set<String> userGroups, String fld, NestedStructureAccessType accessType, NestedStructureAuditHandler auditHandler) {
        FieldLevelAccess ret;
        String atlasString = fld.replaceAll("\\.\\[\\*\\]\\.'", ".").replaceAll("\\.\\*\\.", ".");
        NestedStructureResource resource = new NestedStructureResource(Optional.of(schema), Optional.of(atlasString));
        RangerAccessRequestImpl request = new RangerAccessRequestImpl((RangerAccessResource)resource, accessType.getValue(), user, userGroups, null);
        RangerAccessResult result = this.plugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
        if (result == null) {
            throw new MaskingException("unable to determine access");
        }
        boolean hasAccess = result.getIsAccessDetermined() && result.getIsAllowed();
        logger.debug("checking at line 123 {} access to {}.{} as {} for user: {} has access ? {} policyId:  {}", new Object[]{accessType, schema, fld, atlasString, user, hasAccess ? "yes" : "no", result.getPolicyId()});
        if (!hasAccess) {
            ret = new FieldLevelAccess(fld, hasAccess, -1L, true, null, null);
        } else {
            RangerAccessResult maskResult = this.plugin.evalDataMaskPolicies((RangerAccessRequest)request, null);
            if (maskResult == null) {
                throw new MaskingException("unable to determine access");
            }
            boolean isMasked = maskResult.isMaskEnabled();
            Long maskPolicyId = maskResult.getPolicyId();
            if (isMasked) {
                auditHandler.processResult(maskResult);
            }
            String maskPolicy = isMasked ? " policyId:  " + maskPolicyId : "";
            logger.debug("attribute {} as {} masked ? {}{}", new Object[]{fld, atlasString, isMasked ? "yes" : "no", maskPolicy});
            ret = new FieldLevelAccess(fld, hasAccess, maskPolicyId, isMasked, maskResult.getMaskType(), maskResult.getMaskedValue());
        }
        return ret;
    }

    private boolean hasAccessToRecord(String schema, String user, Set<String> userGroups, String jsonString, NestedStructureAccessType accessType, NestedStructureAuditHandler auditHandler) {
        boolean ret = true;
        NestedStructureResource resource = new NestedStructureResource(Optional.of(schema));
        RangerAccessRequestImpl request = new RangerAccessRequestImpl((RangerAccessResource)resource, accessType.getValue(), user, userGroups, null);
        RangerAccessResult result = this.plugin.evalRowFilterPolicies((RangerAccessRequest)request, null);
        if (result == null) {
            throw new MaskingException("unable to determine access");
        }
        if (result.isRowFilterEnabled()) {
            String filterExpr = result.getFilterExpr();
            logger.debug("row level filter enabled with expression: {}", (Object)filterExpr);
            ret = RecordFilterJavaScript.filterRow(user, filterExpr, jsonString);
            if (!ret) {
                result.setIsAllowed(false);
                auditHandler.processResult(result);
            }
        }
        return ret;
    }

    private boolean hasAccessToSchemaOrAnyField(String schema, String user, Set<String> userGroups, NestedStructureAccessType accessType, NestedStructureAuditHandler auditHandler) {
        boolean ret;
        NestedStructureResource resource = new NestedStructureResource(Optional.of(schema));
        RangerAccessRequestImpl request = new RangerAccessRequestImpl((RangerAccessResource)resource, accessType.getValue(), user, userGroups, null);
        request.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS);
        RangerAccessResult result = this.plugin.isAccessAllowed((RangerAccessRequest)request, null);
        if (result == null) {
            throw new MaskingException("unable to determine access");
        }
        boolean bl = ret = result.getIsAccessDetermined() && result.getIsAllowed();
        if (!ret) {
            auditHandler.processResult(result);
        }
        logger.debug("checking LINE 202 {} access to {} for user: {} has access ? {} policyId:  {}", new Object[]{accessType, schema, user, ret ? "yes" : "no", result.getPolicyId()});
        return ret;
    }
}

