/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.metrics.source;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Objects;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.ranger.metrics.RangerMetricsInfo;
import org.apache.ranger.metrics.source.RangerMetricsSource;

public class RangerMetricsJvmSource
extends RangerMetricsSource {
    private final String context;
    private long memoryCurrent;
    private long memoryMaximum;
    private long gcCountTotal;
    private long gcTimeTotal;
    private long gcTimeMax;
    private int threadsBusy;
    private int threadsBlocked;
    private int threadsWaiting;
    private int threadsRemaining;
    private int processorsAvailable;
    private float systemLoadAverage;

    public RangerMetricsJvmSource(String context) {
        this.context = context;
    }

    @Override
    protected void refresh() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.memoryCurrent = memoryMXBean.getHeapMemoryUsage().getUsed();
        this.memoryMaximum = memoryMXBean.getHeapMemoryUsage().getCommitted();
        this.threadsBusy = 0;
        this.threadsBlocked = 0;
        this.threadsWaiting = 0;
        this.threadsRemaining = 0;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.getAllThreadIds();
        int n = lArray.length;
        block10: for (int i = 0; i < n; ++i) {
            Long threadID = lArray[i];
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(threadID, 0);
            if (!Objects.nonNull(threadInfo)) continue;
            switch (threadInfo.getThreadState().toString()) {
                case "RUNNABLE": {
                    ++this.threadsBusy;
                    continue block10;
                }
                case "BLOCKED": {
                    ++this.threadsBlocked;
                    continue block10;
                }
                case "WAITING": {
                    ++this.threadsWaiting;
                    continue block10;
                }
                default: {
                    ++this.threadsRemaining;
                }
            }
        }
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.systemLoadAverage = (float)osMXBean.getSystemLoadAverage();
        this.processorsAvailable = osMXBean.getAvailableProcessors();
        long totalGarbageCollections = 0L;
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = gc.getCollectionCount();
            if (count >= 0L) {
                totalGarbageCollections += count;
            }
            if ((time = gc.getCollectionTime()) >= 0L) {
                garbageCollectionTime += time;
            }
            if (time <= this.gcTimeMax) continue;
            this.gcTimeMax = time;
        }
        this.gcCountTotal = totalGarbageCollections;
        this.gcTimeTotal = garbageCollectionTime;
    }

    @Override
    protected void update(MetricsCollector collector, boolean all) {
        collector.addRecord("RangerJvm").setContext(this.context).addGauge((MetricsInfo)new RangerMetricsInfo("MemoryCurrent", "Ranger current memory utilization"), this.memoryCurrent).addGauge((MetricsInfo)new RangerMetricsInfo("MemoryMax", "Ranger max memory utilization"), this.memoryMaximum).addGauge((MetricsInfo)new RangerMetricsInfo("GcCountTotal", "Ranger app total GCs"), this.gcCountTotal).addGauge((MetricsInfo)new RangerMetricsInfo("GcTimeTotal", "Ranger app total GC time"), this.gcTimeTotal).addGauge((MetricsInfo)new RangerMetricsInfo("GcTimeMax", "Ranger app MAX GC time"), this.gcTimeMax).addGauge((MetricsInfo)new RangerMetricsInfo("ThreadsBusy", "Ranger busy threads"), this.threadsBusy).addGauge((MetricsInfo)new RangerMetricsInfo("ThreadsBlocked", "Ranger blocked threads"), this.threadsBlocked).addGauge((MetricsInfo)new RangerMetricsInfo("ThreadsWaiting", "Ranger waiting threads"), this.threadsWaiting).addGauge((MetricsInfo)new RangerMetricsInfo("ThreadsRemaining", "Ranger remaining threads"), this.threadsRemaining).addGauge((MetricsInfo)new RangerMetricsInfo("ProcessorsAvailable", "Ranger Processors available"), this.processorsAvailable).addGauge((MetricsInfo)new RangerMetricsInfo("SystemLoadAvg", "Ranger System Load Average"), this.systemLoadAverage);
    }
}

