/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.metrics.source;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.ranger.metrics.RangerMetricsInfo;
import org.apache.ranger.metrics.source.RangerMetricsSource;
import org.apache.ranger.server.tomcat.EmbeddedServer;
import org.apache.ranger.server.tomcat.EmbeddedServerMetricsCollector;

public class RangerMetricsContainerSource
extends RangerMetricsSource {
    private final String context;
    private EmbeddedServerMetricsCollector embeddedServerMetricsCollector;
    private long maxConnections;
    private int acceptCount;
    private long activeConnectionsCount;
    private int maxContainersThreadCount;
    private int minSpareThreadsCount;
    private int activeContainerThreadsCount;
    private int totalContainerThreadsCount;
    private long connectionTimeout;
    private long keepAliveTimeout;

    public RangerMetricsContainerSource(String context) {
        this.context = context;
        this.embeddedServerMetricsCollector = EmbeddedServer.getServerMetricsCollector();
    }

    @Override
    protected void refresh() {
        if (Objects.nonNull(this.embeddedServerMetricsCollector)) {
            this.maxConnections = this.embeddedServerMetricsCollector.getMaxAllowedConnection();
            this.acceptCount = this.embeddedServerMetricsCollector.getConnectionAcceptCount();
            this.activeConnectionsCount = this.embeddedServerMetricsCollector.getActiveConnectionCount();
            this.maxContainersThreadCount = this.embeddedServerMetricsCollector.getMaxContainerThreadsCount();
            this.minSpareThreadsCount = this.embeddedServerMetricsCollector.getMinSpareContainerThreadsCount();
            this.activeContainerThreadsCount = this.embeddedServerMetricsCollector.getActiveContainerThreadsCount();
            this.connectionTimeout = this.embeddedServerMetricsCollector.getConnectionTimeout();
            this.keepAliveTimeout = this.embeddedServerMetricsCollector.getKeepAliveTimeout();
            this.totalContainerThreadsCount = this.embeddedServerMetricsCollector.getTotalContainerThreadsCount();
        }
    }

    @Override
    protected void update(MetricsCollector collector, boolean all) {
        collector.addRecord("RangerWebContainer").setContext(this.context).addCounter((MetricsInfo)new RangerMetricsInfo("MaxConnectionsCount", "Ranger max configured container connections"), this.maxConnections).addCounter((MetricsInfo)new RangerMetricsInfo("ActiveConnectionsCount", "Ranger active container connections"), this.activeConnectionsCount).addCounter((MetricsInfo)new RangerMetricsInfo("ConnectionAcceptCount", "Ranger accept connections count"), this.acceptCount).addCounter((MetricsInfo)new RangerMetricsInfo("ConnectionTimeout", "Ranger connection timeout"), this.connectionTimeout).addCounter((MetricsInfo)new RangerMetricsInfo("KeepAliveTimeout", "Ranger connection keepAlive timeout"), this.keepAliveTimeout).addCounter((MetricsInfo)new RangerMetricsInfo("MaxWorkerThreadsCount", "Ranger container worker threads count"), this.maxContainersThreadCount).addCounter((MetricsInfo)new RangerMetricsInfo("MinSpareWorkerThreadsCount", "Ranger container minimum spare worker threads count"), this.minSpareThreadsCount).addCounter((MetricsInfo)new RangerMetricsInfo("ActiveWorkerThreadsCount", "Ranger container active worker threads count"), this.activeContainerThreadsCount).addCounter((MetricsInfo)new RangerMetricsInfo("TotalWorkerThreadsCount", "Ranger container total worker threads count"), this.totalContainerThreadsCount);
    }

    @VisibleForTesting
    void setEmbeddedServerMetricsCollector(EmbeddedServerMetricsCollector embeddedServerMetricsCollector) {
        this.embeddedServerMetricsCollector = embeddedServerMetricsCollector;
    }
}

