/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kylin.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.kylin.client.KylinClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(KylinResourceMgr.class);
    public static final String PROJECT = "project";

    private KylinResourceMgr() {
    }

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) {
        Map<String, Object> ret;
        LOG.debug("==> KylinResourceMgr.validateConfig ServiceName: {}Configs{}", (Object)serviceName, configs);
        try {
            ret = KylinClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== KylinResourceMgr.validateConfig Error: {}", (Object)String.valueOf(e));
            throw e;
        }
        LOG.debug("<== KylinResourceMgr.validateConfig Result: {}", ret);
        return ret;
    }

    public static List<String> getKylinResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        KylinClient kylinClient;
        String userInput = context.getUserInput();
        String resource = context.getResourceName();
        Map resourceMap = context.getResources();
        LOG.debug("==> KylinResourceMgr.getKylinResources()  userInput: {}, resource: {}, resourceMap: {}", new Object[]{userInput, resource, resourceMap});
        if (MapUtils.isEmpty(configs)) {
            LOG.error("Connection Config is empty!");
            return null;
        }
        if (StringUtils.isEmpty((String)userInput)) {
            LOG.warn("User input is empty, set default value : *");
            userInput = "*";
        }
        List projectList = null;
        if (MapUtils.isNotEmpty((Map)resourceMap)) {
            projectList = (List)resourceMap.get(PROJECT);
        }
        if ((kylinClient = KylinClient.getKylinClient(serviceName, configs)) == null) {
            LOG.error("Failed to getKylinClient!");
            return null;
        }
        List<String> resultList = kylinClient.getProjectList(userInput, projectList);
        LOG.debug("<== KylinResourceMgr.getKylinResources() result: {}", resultList);
        return resultList;
    }
}

