/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kylin.authorizer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.model.Permission;

public class RangerKylinAuthorizer
extends ExternalAclProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKylinAuthorizer.class);
    private static volatile RangerKylinPlugin kylinPlugin;
    private static String clientIPAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init() {
        LOG.debug("==> RangerKylinAuthorizer.init()");
        RangerKylinPlugin plugin = kylinPlugin;
        if (plugin == null) {
            Class<RangerKylinAuthorizer> clazz = RangerKylinAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.kylin.authorizer.RangerKylinAuthorizer.class
            plugin = kylinPlugin;
            if (plugin == null) {
                plugin = new RangerKylinPlugin();
                plugin.init();
                kylinPlugin = plugin;
                clientIPAddress = this.getClientIPAddress();
            }
            // MONITOREXIT : clazz
        }
        LOG.debug("<== RangerKylinAuthorizer.init()");
    }

    public boolean checkPermission(String user, List<String> groups, String entityType, String entityUuid, Permission permission) {
        LOG.debug("==> RangerKylinAuthorizer.checkPermission( user={}, groups={}, entityType={}, entityUuid={}, permission={})", new Object[]{user, groups, entityType, entityUuid, permission});
        boolean ret = false;
        if (kylinPlugin != null) {
            String accessType;
            RangerKylinAccessRequest request;
            RangerAccessResult result;
            String projectName = null;
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            if ("ProjectInstance".equals(entityType)) {
                ProjectInstance projectInstance = ProjectManager.getInstance((KylinConfig)kylinConfig).getPrjByUuid(entityUuid);
                if (projectInstance != null) {
                    projectName = projectInstance.getName();
                } else {
                    LOG.warn("Could not find kylin project for given uuid = {}", (Object)entityUuid);
                }
            }
            if ((result = kylinPlugin.isAccessAllowed((RangerAccessRequest)(request = new RangerKylinAccessRequest(projectName, user, groups, accessType = ExternalAclProvider.transformPermission((Permission)permission), clientIPAddress)))) != null && result.getIsAllowed()) {
                ret = true;
            }
        }
        LOG.debug("<== RangerKylinAuthorizer.checkPermission(): result={}", (Object)ret);
        return ret;
    }

    public List<Pair<String, AclPermission>> getAcl(String entityType, String entityUuid) {
        return null;
    }

    private String getClientIPAddress() {
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.debug("Failed to get client IP address. {}", (Object)String.valueOf(e));
        }
        String ret = null;
        if (ip != null) {
            ret = ip.getHostAddress();
        }
        return ret;
    }

    private static class RangerKylinAccessRequest
    extends RangerAccessRequestImpl {
        public RangerKylinAccessRequest(String projectName, String user, List<String> groups, String accessType, String clientIPAddress) {
            super.setResource((RangerAccessResource)new RangerKylinResource(projectName));
            super.setAccessType(accessType);
            super.setUser(user);
            super.setUserGroups((Set)Sets.newHashSet(groups));
            super.setAccessTime(new Date());
            super.setClientIPAddress(clientIPAddress);
            super.setAction(accessType);
        }
    }

    private static class RangerKylinResource
    extends RangerAccessResourceImpl {
        public RangerKylinResource(String projectName) {
            if (StringUtils.isEmpty((String)projectName)) {
                projectName = "*";
            }
            this.setValue("project", projectName);
        }
    }

    private static class RangerKylinPlugin
    extends RangerBasePlugin {
        public RangerKylinPlugin() {
            super("kylin", "kylin");
        }

        public void init() {
            super.init();
            RangerDefaultAuditHandler auditHandler = new RangerDefaultAuditHandler((Configuration)this.getConfig());
            super.setResultProcessor((RangerAccessResultProcessor)auditHandler);
        }
    }
}

