/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.knox;

import java.io.IOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.ImpersonatedPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.knox.KnoxRangerPlugin;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPDPKnoxFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPDPKnoxFilter.class);
    private static final Logger PERF_KNOXAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"knoxauth.request");
    private static final String KNOX_GATEWAY_JASS_CONFIG_SECTION = "com.sun.security.jgss.initiate";
    private static volatile KnoxRangerPlugin plugin;
    private String resourceRole;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(FilterConfig filterConfig) {
        this.resourceRole = this.getInitParameter(filterConfig, "resource.role");
        KnoxRangerPlugin me = plugin;
        if (me != null) return;
        Class<RangerPDPKnoxFilter> clazz = RangerPDPKnoxFilter.class;
        synchronized (RangerPDPKnoxFilter.class) {
            me = plugin;
            if (me != null) return;
            try {
                MiscUtil.setUGIFromJAASConfig((String)KNOX_GATEWAY_JASS_CONFIG_SECTION);
                LOG.info("LoginUser = {}", (Object)MiscUtil.getUGILoginUser());
            }
            catch (Throwable t) {
                LOG.error("Error while setting UGI for Knox Plugin...", t);
            }
            LOG.info("Creating KnoxRangerPlugin");
            plugin = new KnoxRangerPlugin();
            plugin.init();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String sourceUrl = (String)request.getAttribute("sourceRequestContextUrl");
        String topologyName = this.getTopologyName(sourceUrl);
        String serviceName = this.getServiceName();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Logger)PERF_KNOXAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Logger)PERF_KNOXAUTH_REQUEST_LOG, (String)("RangerPDPKnoxFilter.doFilter(url=" + sourceUrl + ", topologyName=" + topologyName + ")"));
        }
        Subject subject = Subject.getSubject(AccessController.getContext());
        Set<PrimaryPrincipal> primaryPrincipals = subject.getPrincipals(PrimaryPrincipal.class);
        String primaryUser = null;
        if (!primaryPrincipals.isEmpty()) {
            primaryUser = ((PrimaryPrincipal)primaryPrincipals.stream().findFirst().get()).getName();
        }
        String impersonatedUser = null;
        Set<ImpersonatedPrincipal> impersonations = subject.getPrincipals(ImpersonatedPrincipal.class);
        if (!impersonations.isEmpty()) {
            impersonatedUser = ((ImpersonatedPrincipal)impersonations.stream().findFirst().get()).getName();
        }
        String user = impersonatedUser != null ? impersonatedUser : primaryUser;
        LOG.debug("Checking access primaryUser: {}, impersonatedUser: {}, effectiveUser: {}", new Object[]{primaryUser, impersonatedUser, user});
        Set<GroupPrincipal> groupObjects = subject.getPrincipals(GroupPrincipal.class);
        HashSet<String> groups = new HashSet<String>();
        for (GroupPrincipal obj : groupObjects) {
            groups.add(obj.getName());
        }
        String clientIp = request.getRemoteAddr();
        List<String> forwardedAddresses = this.getForwardedAddresses(request);
        LOG.debug("Checking access primaryUser: {}, impersonatedUser: {}, effectiveUser: {}, groups: {}, clientIp: {}, remoteIp: {}, forwardedAddresses: {}", new Object[]{primaryUser, impersonatedUser, user, groups, clientIp, clientIp, forwardedAddresses});
        RangerAccessRequest accessRequest = new KnoxRangerPlugin.RequestBuilder().service(serviceName).topology(topologyName).user(user).groups(groups).clientIp(clientIp).remoteIp(clientIp).forwardedAddresses(forwardedAddresses).build();
        boolean accessAllowed = false;
        if (plugin != null) {
            RangerAccessResult result = plugin.isAccessAllowed(accessRequest);
            accessAllowed = result != null && result.getIsAllowed();
        }
        LOG.debug("Access allowed: {}", (Object)accessAllowed);
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (accessAllowed) {
            chain.doFilter(request, response);
        } else {
            this.sendForbidden((HttpServletResponse)response);
        }
    }

    public void destroy() {
    }

    private String getInitParameter(FilterConfig filterConfig, String paramName) {
        return filterConfig.getInitParameter(paramName.toLowerCase());
    }

    private List<String> getForwardedAddresses(ServletRequest request) {
        HttpServletRequest httpRequest;
        String xForwardedFor;
        List<String> forwardedAddresses = null;
        if (request instanceof HttpServletRequest && (xForwardedFor = (httpRequest = (HttpServletRequest)request).getHeader("X-Forwarded-For")) != null) {
            forwardedAddresses = Arrays.asList(xForwardedFor.split(","));
        }
        return forwardedAddresses;
    }

    private void sendForbidden(HttpServletResponse res) {
        this.sendErrorCode(res, 403);
    }

    private void sendErrorCode(HttpServletResponse res, int code) {
        try {
            res.sendError(code);
        }
        catch (IOException e) {
            LOG.error("Error while redirecting: ", (Throwable)e);
        }
    }

    private String getTopologyName(String requestUrl) {
        if (requestUrl == null) {
            return null;
        }
        String url = requestUrl.trim();
        String[] tokens = url.split("/");
        if (tokens.length > 2) {
            return tokens[2];
        }
        return null;
    }

    private String getServiceName() {
        return this.resourceRole;
    }
}

